package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.ht.valuerule.anno.im.*;
import com.ibiz.core.ht.domain.IM;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[IMDTO]
 */
public class IMDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [KGSLDIDS]
     *
     */
    @IMKgsldidsDefault(info = "默认规则")
    private String kgsldids;

    @JsonIgnore
    private boolean kgsldidsDirtyFlag;

    /**
     * 属性 [BZ]
     *
     */
    @IMBzDefault(info = "默认规则")
    private String bz;

    @JsonIgnore
    private boolean bzDirtyFlag;

    /**
     * 属性 [SBLB]
     *
     */
    @IMSblbDefault(info = "默认规则")
    private String sblb;

    @JsonIgnore
    private boolean sblbDirtyFlag;

    /**
     * 属性 [BMLDIDS]
     *
     */
    @IMBmldidsDefault(info = "默认规则")
    private String bmldids;

    @JsonIgnore
    private boolean bmldidsDirtyFlag;

    /**
     * 属性 [JJYY]
     *
     */
    @IMJjyyDefault(info = "默认规则")
    private String jjyy;

    @JsonIgnore
    private boolean jjyyDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @IMCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [HQBM]
     *
     */
    @IMHqbmDefault(info = "默认规则")
    private String hqbm;

    @JsonIgnore
    private boolean hqbmDirtyFlag;

    /**
     * 属性 [SDFS]
     *
     */
    @IMSdfsDefault(info = "默认规则")
    private String sdfs;

    @JsonIgnore
    private boolean sdfsDirtyFlag;

    /**
     * 属性 [KGSBMIDS]
     *
     */
    @IMKgsbmidsDefault(info = "默认规则")
    private String kgsbmids;

    @JsonIgnore
    private boolean kgsbmidsDirtyFlag;

    /**
     * 属性 [SJBM]
     *
     */
    @IMSjbmDefault(info = "默认规则")
    private Integer sjbm;

    @JsonIgnore
    private boolean sjbmDirtyFlag;

    /**
     * 属性 [QTTZYDDX]
     *
     */
    @IMQttzyddxDefault(info = "默认规则")
    private String qttzyddx;

    @JsonIgnore
    private boolean qttzyddxDirtyFlag;

    /**
     * 属性 [LD]
     *
     */
    @IMLdDefault(info = "默认规则")
    private String ld;

    @JsonIgnore
    private boolean ldDirtyFlag;

    /**
     * 属性 [IMNAME]
     *
     */
    @IMIMNameDefault(info = "默认规则")
    private String iMName;

    @JsonIgnore
    private boolean iMNameDirtyFlag;

    /**
     * 属性 [LCBH]
     *
     */
    @IMLcbhDefault(info = "默认规则")
    private String lcbh;

    @JsonIgnore
    private boolean lcbhDirtyFlag;

    /**
     * 属性 [NGSHIDS]
     *
     */
    @IMNgshidsDefault(info = "默认规则")
    private String ngshids;

    @JsonIgnore
    private boolean ngshidsDirtyFlag;

    /**
     * 属性 [KGSLD]
     *
     */
    @IMKgsldDefault(info = "默认规则")
    private String kgsld;

    @JsonIgnore
    private boolean kgsldDirtyFlag;

    /**
     * 属性 [SHFS]
     *
     */
    @IMShfsDefault(info = "默认规则")
    private String shfs;

    @JsonIgnore
    private boolean shfsDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @IMUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [IMID]
     *
     */
    @IMIMIdDefault(info = "默认规则")
    private String iMId;

    @JsonIgnore
    private boolean iMIdDirtyFlag;

    /**
     * 属性 [SBLX]
     *
     */
    @IMSblxDefault(info = "默认规则")
    private String sblx;

    @JsonIgnore
    private boolean sblxDirtyFlag;

    /**
     * 属性 [TZYD]
     *
     */
    @IMTzydDefault(info = "默认规则")
    private Integer tzyd;

    @JsonIgnore
    private boolean tzydDirtyFlag;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @IMWfinstanceidDefault(info = "默认规则")
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;

    /**
     * 属性 [BMLD]
     *
     */
    @IMBmldDefault(info = "默认规则")
    private String bmld;

    @JsonIgnore
    private boolean bmldDirtyFlag;

    /**
     * 属性 [TZYDYY]
     *
     */
    @IMTzydyyDefault(info = "默认规则")
    private String tzydyy;

    @JsonIgnore
    private boolean tzydyyDirtyFlag;

    /**
     * 属性 [IMWFSTATE]
     *
     */
    @IMImwfstateDefault(info = "默认规则")
    private String imwfstate;

    @JsonIgnore
    private boolean imwfstateDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @IMCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [YZDX]
     *
     */
    @IMYzdxDefault(info = "默认规则")
    private String yzdx;

    @JsonIgnore
    private boolean yzdxDirtyFlag;

    /**
     * 属性 [NGSH]
     *
     */
    @IMNgshDefault(info = "默认规则")
    private String ngsh;

    @JsonIgnore
    private boolean ngshDirtyFlag;

    /**
     * 属性 [HJCD]
     *
     */
    @IMHjcdDefault(info = "默认规则")
    private String hjcd;

    @JsonIgnore
    private boolean hjcdDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @IMUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [LDIDS]
     *
     */
    @IMLdidsDefault(info = "默认规则")
    private String ldids;

    @JsonIgnore
    private boolean ldidsDirtyFlag;

    /**
     * 属性 [HQBMIDS]
     *
     */
    @IMHqbmidsDefault(info = "默认规则")
    private String hqbmids;

    @JsonIgnore
    private boolean hqbmidsDirtyFlag;

    /**
     * 属性 [KGSBM]
     *
     */
    @IMKgsbmDefault(info = "默认规则")
    private String kgsbm;

    @JsonIgnore
    private boolean kgsbmDirtyFlag;

    /**
     * 属性 [WFSTEP]
     *
     */
    @IMWfstepDefault(info = "默认规则")
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;

    /**
     * 属性 [ZBBM]
     *
     */
    @IMZbbmDefault(info = "默认规则")
    private String zbbm;

    @JsonIgnore
    private boolean zbbmDirtyFlag;

    /**
     * 属性 [NGRQ]
     *
     */
    @IMNgrqDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    private Timestamp ngrq;

    @JsonIgnore
    private boolean ngrqDirtyFlag;

    /**
     * 属性 [NGRLXFS]
     *
     */
    @IMNgrlxfsDefault(info = "默认规则")
    private String ngrlxfs;

    @JsonIgnore
    private boolean ngrlxfsDirtyFlag;

    /**
     * 属性 [NGRJG]
     *
     */
    @IMNgrjgDefault(info = "默认规则")
    private String ngrjg;

    @JsonIgnore
    private boolean ngrjgDirtyFlag;

    /**
     * 属性 [NGRBMNAME]
     *
     */
    @IMNgrbmnameDefault(info = "默认规则")
    private String ngrbmname;

    @JsonIgnore
    private boolean ngrbmnameDirtyFlag;

    /**
     * 属性 [NGRNAME]
     *
     */
    @IMNgrnameDefault(info = "默认规则")
    private String ngrname;

    @JsonIgnore
    private boolean ngrnameDirtyFlag;

    /**
     * 属性 [NGRID]
     *
     */
    @IMNgridDefault(info = "默认规则")
    private String ngrid;

    @JsonIgnore
    private boolean ngridDirtyFlag;

    /**
     * 属性 [NGRBMID]
     *
     */
    @IMNgrbmidDefault(info = "默认规则")
    private String ngrbmid;

    @JsonIgnore
    private boolean ngrbmidDirtyFlag;

    /**
     * 属性 [PSID]
     *
     */
    @IMPsidDefault(info = "默认规则")
    private String psid;

    @JsonIgnore
    private boolean psidDirtyFlag;


    /**
     * 获取 [KGSLDIDS]
     */
    @JsonProperty("kgsldids")
    public String getKgsldids(){
        return kgsldids ;
    }

    /**
     * 设置 [KGSLDIDS]
     */
    @JsonProperty("kgsldids")
    public void setKgsldids(String  kgsldids){
        this.kgsldids = kgsldids ;
        this.kgsldidsDirtyFlag = true ;
    }

    /**
     * 获取 [KGSLDIDS]脏标记
     */
    @JsonIgnore
    public boolean getKgsldidsDirtyFlag(){
        return kgsldidsDirtyFlag ;
    }

    /**
     * 获取 [BZ]
     */
    @JsonProperty("bz")
    public String getBz(){
        return bz ;
    }

    /**
     * 设置 [BZ]
     */
    @JsonProperty("bz")
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [BZ]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return bzDirtyFlag ;
    }

    /**
     * 获取 [SBLB]
     */
    @JsonProperty("sblb")
    public String getSblb(){
        return sblb ;
    }

    /**
     * 设置 [SBLB]
     */
    @JsonProperty("sblb")
    public void setSblb(String  sblb){
        this.sblb = sblb ;
        this.sblbDirtyFlag = true ;
    }

    /**
     * 获取 [SBLB]脏标记
     */
    @JsonIgnore
    public boolean getSblbDirtyFlag(){
        return sblbDirtyFlag ;
    }

    /**
     * 获取 [BMLDIDS]
     */
    @JsonProperty("bmldids")
    public String getBmldids(){
        return bmldids ;
    }

    /**
     * 设置 [BMLDIDS]
     */
    @JsonProperty("bmldids")
    public void setBmldids(String  bmldids){
        this.bmldids = bmldids ;
        this.bmldidsDirtyFlag = true ;
    }

    /**
     * 获取 [BMLDIDS]脏标记
     */
    @JsonIgnore
    public boolean getBmldidsDirtyFlag(){
        return bmldidsDirtyFlag ;
    }

    /**
     * 获取 [JJYY]
     */
    @JsonProperty("jjyy")
    public String getJjyy(){
        return jjyy ;
    }

    /**
     * 设置 [JJYY]
     */
    @JsonProperty("jjyy")
    public void setJjyy(String  jjyy){
        this.jjyy = jjyy ;
        this.jjyyDirtyFlag = true ;
    }

    /**
     * 获取 [JJYY]脏标记
     */
    @JsonIgnore
    public boolean getJjyyDirtyFlag(){
        return jjyyDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [HQBM]
     */
    @JsonProperty("hqbm")
    public String getHqbm(){
        return hqbm ;
    }

    /**
     * 设置 [HQBM]
     */
    @JsonProperty("hqbm")
    public void setHqbm(String  hqbm){
        this.hqbm = hqbm ;
        this.hqbmDirtyFlag = true ;
    }

    /**
     * 获取 [HQBM]脏标记
     */
    @JsonIgnore
    public boolean getHqbmDirtyFlag(){
        return hqbmDirtyFlag ;
    }

    /**
     * 获取 [SDFS]
     */
    @JsonProperty("sdfs")
    public String getSdfs(){
        return sdfs ;
    }

    /**
     * 设置 [SDFS]
     */
    @JsonProperty("sdfs")
    public void setSdfs(String  sdfs){
        this.sdfs = sdfs ;
        this.sdfsDirtyFlag = true ;
    }

    /**
     * 获取 [SDFS]脏标记
     */
    @JsonIgnore
    public boolean getSdfsDirtyFlag(){
        return sdfsDirtyFlag ;
    }

    /**
     * 获取 [KGSBMIDS]
     */
    @JsonProperty("kgsbmids")
    public String getKgsbmids(){
        return kgsbmids ;
    }

    /**
     * 设置 [KGSBMIDS]
     */
    @JsonProperty("kgsbmids")
    public void setKgsbmids(String  kgsbmids){
        this.kgsbmids = kgsbmids ;
        this.kgsbmidsDirtyFlag = true ;
    }

    /**
     * 获取 [KGSBMIDS]脏标记
     */
    @JsonIgnore
    public boolean getKgsbmidsDirtyFlag(){
        return kgsbmidsDirtyFlag ;
    }

    /**
     * 获取 [SJBM]
     */
    @JsonProperty("sjbm")
    public Integer getSjbm(){
        return sjbm ;
    }

    /**
     * 设置 [SJBM]
     */
    @JsonProperty("sjbm")
    public void setSjbm(Integer  sjbm){
        this.sjbm = sjbm ;
        this.sjbmDirtyFlag = true ;
    }

    /**
     * 获取 [SJBM]脏标记
     */
    @JsonIgnore
    public boolean getSjbmDirtyFlag(){
        return sjbmDirtyFlag ;
    }

    /**
     * 获取 [QTTZYDDX]
     */
    @JsonProperty("qttzyddx")
    public String getQttzyddx(){
        return qttzyddx ;
    }

    /**
     * 设置 [QTTZYDDX]
     */
    @JsonProperty("qttzyddx")
    public void setQttzyddx(String  qttzyddx){
        this.qttzyddx = qttzyddx ;
        this.qttzyddxDirtyFlag = true ;
    }

    /**
     * 获取 [QTTZYDDX]脏标记
     */
    @JsonIgnore
    public boolean getQttzyddxDirtyFlag(){
        return qttzyddxDirtyFlag ;
    }

    /**
     * 获取 [LD]
     */
    @JsonProperty("ld")
    public String getLd(){
        return ld ;
    }

    /**
     * 设置 [LD]
     */
    @JsonProperty("ld")
    public void setLd(String  ld){
        this.ld = ld ;
        this.ldDirtyFlag = true ;
    }

    /**
     * 获取 [LD]脏标记
     */
    @JsonIgnore
    public boolean getLdDirtyFlag(){
        return ldDirtyFlag ;
    }

    /**
     * 获取 [IMNAME]
     */
    @JsonProperty("imname")
    public String getIMName(){
        return iMName ;
    }

    /**
     * 设置 [IMNAME]
     */
    @JsonProperty("imname")
    public void setIMName(String  iMName){
        this.iMName = iMName ;
        this.iMNameDirtyFlag = true ;
    }

    /**
     * 获取 [IMNAME]脏标记
     */
    @JsonIgnore
    public boolean getIMNameDirtyFlag(){
        return iMNameDirtyFlag ;
    }

    /**
     * 获取 [LCBH]
     */
    @JsonProperty("lcbh")
    public String getLcbh(){
        return lcbh ;
    }

    /**
     * 设置 [LCBH]
     */
    @JsonProperty("lcbh")
    public void setLcbh(String  lcbh){
        this.lcbh = lcbh ;
        this.lcbhDirtyFlag = true ;
    }

    /**
     * 获取 [LCBH]脏标记
     */
    @JsonIgnore
    public boolean getLcbhDirtyFlag(){
        return lcbhDirtyFlag ;
    }

    /**
     * 获取 [NGSHIDS]
     */
    @JsonProperty("ngshids")
    public String getNgshids(){
        return ngshids ;
    }

    /**
     * 设置 [NGSHIDS]
     */
    @JsonProperty("ngshids")
    public void setNgshids(String  ngshids){
        this.ngshids = ngshids ;
        this.ngshidsDirtyFlag = true ;
    }

    /**
     * 获取 [NGSHIDS]脏标记
     */
    @JsonIgnore
    public boolean getNgshidsDirtyFlag(){
        return ngshidsDirtyFlag ;
    }

    /**
     * 获取 [KGSLD]
     */
    @JsonProperty("kgsld")
    public String getKgsld(){
        return kgsld ;
    }

    /**
     * 设置 [KGSLD]
     */
    @JsonProperty("kgsld")
    public void setKgsld(String  kgsld){
        this.kgsld = kgsld ;
        this.kgsldDirtyFlag = true ;
    }

    /**
     * 获取 [KGSLD]脏标记
     */
    @JsonIgnore
    public boolean getKgsldDirtyFlag(){
        return kgsldDirtyFlag ;
    }

    /**
     * 获取 [SHFS]
     */
    @JsonProperty("shfs")
    public String getShfs(){
        return shfs ;
    }

    /**
     * 设置 [SHFS]
     */
    @JsonProperty("shfs")
    public void setShfs(String  shfs){
        this.shfs = shfs ;
        this.shfsDirtyFlag = true ;
    }

    /**
     * 获取 [SHFS]脏标记
     */
    @JsonIgnore
    public boolean getShfsDirtyFlag(){
        return shfsDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [IMID]
     */
    @JsonProperty("imid")
    public String getIMId(){
        return iMId ;
    }

    /**
     * 设置 [IMID]
     */
    @JsonProperty("imid")
    public void setIMId(String  iMId){
        this.iMId = iMId ;
        this.iMIdDirtyFlag = true ;
    }

    /**
     * 获取 [IMID]脏标记
     */
    @JsonIgnore
    public boolean getIMIdDirtyFlag(){
        return iMIdDirtyFlag ;
    }

    /**
     * 获取 [SBLX]
     */
    @JsonProperty("sblx")
    public String getSblx(){
        return sblx ;
    }

    /**
     * 设置 [SBLX]
     */
    @JsonProperty("sblx")
    public void setSblx(String  sblx){
        this.sblx = sblx ;
        this.sblxDirtyFlag = true ;
    }

    /**
     * 获取 [SBLX]脏标记
     */
    @JsonIgnore
    public boolean getSblxDirtyFlag(){
        return sblxDirtyFlag ;
    }

    /**
     * 获取 [TZYD]
     */
    @JsonProperty("tzyd")
    public Integer getTzyd(){
        return tzyd ;
    }

    /**
     * 设置 [TZYD]
     */
    @JsonProperty("tzyd")
    public void setTzyd(Integer  tzyd){
        this.tzyd = tzyd ;
        this.tzydDirtyFlag = true ;
    }

    /**
     * 获取 [TZYD]脏标记
     */
    @JsonIgnore
    public boolean getTzydDirtyFlag(){
        return tzydDirtyFlag ;
    }

    /**
     * 获取 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return wfinstanceid ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return wfinstanceidDirtyFlag ;
    }

    /**
     * 获取 [BMLD]
     */
    @JsonProperty("bmld")
    public String getBmld(){
        return bmld ;
    }

    /**
     * 设置 [BMLD]
     */
    @JsonProperty("bmld")
    public void setBmld(String  bmld){
        this.bmld = bmld ;
        this.bmldDirtyFlag = true ;
    }

    /**
     * 获取 [BMLD]脏标记
     */
    @JsonIgnore
    public boolean getBmldDirtyFlag(){
        return bmldDirtyFlag ;
    }

    /**
     * 获取 [TZYDYY]
     */
    @JsonProperty("tzydyy")
    public String getTzydyy(){
        return tzydyy ;
    }

    /**
     * 设置 [TZYDYY]
     */
    @JsonProperty("tzydyy")
    public void setTzydyy(String  tzydyy){
        this.tzydyy = tzydyy ;
        this.tzydyyDirtyFlag = true ;
    }

    /**
     * 获取 [TZYDYY]脏标记
     */
    @JsonIgnore
    public boolean getTzydyyDirtyFlag(){
        return tzydyyDirtyFlag ;
    }

    /**
     * 获取 [IMWFSTATE]
     */
    @JsonProperty("imwfstate")
    public String getImwfstate(){
        return imwfstate ;
    }

    /**
     * 设置 [IMWFSTATE]
     */
    @JsonProperty("imwfstate")
    public void setImwfstate(String  imwfstate){
        this.imwfstate = imwfstate ;
        this.imwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [IMWFSTATE]脏标记
     */
    @JsonIgnore
    public boolean getImwfstateDirtyFlag(){
        return imwfstateDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [YZDX]
     */
    @JsonProperty("yzdx")
    public String getYzdx(){
        return yzdx ;
    }

    /**
     * 设置 [YZDX]
     */
    @JsonProperty("yzdx")
    public void setYzdx(String  yzdx){
        this.yzdx = yzdx ;
        this.yzdxDirtyFlag = true ;
    }

    /**
     * 获取 [YZDX]脏标记
     */
    @JsonIgnore
    public boolean getYzdxDirtyFlag(){
        return yzdxDirtyFlag ;
    }

    /**
     * 获取 [NGSH]
     */
    @JsonProperty("ngsh")
    public String getNgsh(){
        return ngsh ;
    }

    /**
     * 设置 [NGSH]
     */
    @JsonProperty("ngsh")
    public void setNgsh(String  ngsh){
        this.ngsh = ngsh ;
        this.ngshDirtyFlag = true ;
    }

    /**
     * 获取 [NGSH]脏标记
     */
    @JsonIgnore
    public boolean getNgshDirtyFlag(){
        return ngshDirtyFlag ;
    }

    /**
     * 获取 [HJCD]
     */
    @JsonProperty("hjcd")
    public String getHjcd(){
        return hjcd ;
    }

    /**
     * 设置 [HJCD]
     */
    @JsonProperty("hjcd")
    public void setHjcd(String  hjcd){
        this.hjcd = hjcd ;
        this.hjcdDirtyFlag = true ;
    }

    /**
     * 获取 [HJCD]脏标记
     */
    @JsonIgnore
    public boolean getHjcdDirtyFlag(){
        return hjcdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [LDIDS]
     */
    @JsonProperty("ldids")
    public String getLdids(){
        return ldids ;
    }

    /**
     * 设置 [LDIDS]
     */
    @JsonProperty("ldids")
    public void setLdids(String  ldids){
        this.ldids = ldids ;
        this.ldidsDirtyFlag = true ;
    }

    /**
     * 获取 [LDIDS]脏标记
     */
    @JsonIgnore
    public boolean getLdidsDirtyFlag(){
        return ldidsDirtyFlag ;
    }

    /**
     * 获取 [HQBMIDS]
     */
    @JsonProperty("hqbmids")
    public String getHqbmids(){
        return hqbmids ;
    }

    /**
     * 设置 [HQBMIDS]
     */
    @JsonProperty("hqbmids")
    public void setHqbmids(String  hqbmids){
        this.hqbmids = hqbmids ;
        this.hqbmidsDirtyFlag = true ;
    }

    /**
     * 获取 [HQBMIDS]脏标记
     */
    @JsonIgnore
    public boolean getHqbmidsDirtyFlag(){
        return hqbmidsDirtyFlag ;
    }

    /**
     * 获取 [KGSBM]
     */
    @JsonProperty("kgsbm")
    public String getKgsbm(){
        return kgsbm ;
    }

    /**
     * 设置 [KGSBM]
     */
    @JsonProperty("kgsbm")
    public void setKgsbm(String  kgsbm){
        this.kgsbm = kgsbm ;
        this.kgsbmDirtyFlag = true ;
    }

    /**
     * 获取 [KGSBM]脏标记
     */
    @JsonIgnore
    public boolean getKgsbmDirtyFlag(){
        return kgsbmDirtyFlag ;
    }

    /**
     * 获取 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return wfstep ;
    }

    /**
     * 设置 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEP]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return wfstepDirtyFlag ;
    }

    /**
     * 获取 [ZBBM]
     */
    @JsonProperty("zbbm")
    public String getZbbm(){
        return zbbm ;
    }

    /**
     * 设置 [ZBBM]
     */
    @JsonProperty("zbbm")
    public void setZbbm(String  zbbm){
        this.zbbm = zbbm ;
        this.zbbmDirtyFlag = true ;
    }

    /**
     * 获取 [ZBBM]脏标记
     */
    @JsonIgnore
    public boolean getZbbmDirtyFlag(){
        return zbbmDirtyFlag ;
    }

    /**
     * 获取 [NGRQ]
     */
    @JsonProperty("ngrq")
    public Timestamp getNgrq(){
        return ngrq ;
    }

    /**
     * 设置 [NGRQ]
     */
    @JsonProperty("ngrq")
    public void setNgrq(Timestamp  ngrq){
        this.ngrq = ngrq ;
        this.ngrqDirtyFlag = true ;
    }

    /**
     * 获取 [NGRQ]脏标记
     */
    @JsonIgnore
    public boolean getNgrqDirtyFlag(){
        return ngrqDirtyFlag ;
    }

    /**
     * 获取 [NGRLXFS]
     */
    @JsonProperty("ngrlxfs")
    public String getNgrlxfs(){
        return ngrlxfs ;
    }

    /**
     * 设置 [NGRLXFS]
     */
    @JsonProperty("ngrlxfs")
    public void setNgrlxfs(String  ngrlxfs){
        this.ngrlxfs = ngrlxfs ;
        this.ngrlxfsDirtyFlag = true ;
    }

    /**
     * 获取 [NGRLXFS]脏标记
     */
    @JsonIgnore
    public boolean getNgrlxfsDirtyFlag(){
        return ngrlxfsDirtyFlag ;
    }

    /**
     * 获取 [NGRJG]
     */
    @JsonProperty("ngrjg")
    public String getNgrjg(){
        return ngrjg ;
    }

    /**
     * 设置 [NGRJG]
     */
    @JsonProperty("ngrjg")
    public void setNgrjg(String  ngrjg){
        this.ngrjg = ngrjg ;
        this.ngrjgDirtyFlag = true ;
    }

    /**
     * 获取 [NGRJG]脏标记
     */
    @JsonIgnore
    public boolean getNgrjgDirtyFlag(){
        return ngrjgDirtyFlag ;
    }

    /**
     * 获取 [NGRBMNAME]
     */
    @JsonProperty("ngrbmname")
    public String getNgrbmname(){
        return ngrbmname ;
    }

    /**
     * 设置 [NGRBMNAME]
     */
    @JsonProperty("ngrbmname")
    public void setNgrbmname(String  ngrbmname){
        this.ngrbmname = ngrbmname ;
        this.ngrbmnameDirtyFlag = true ;
    }

    /**
     * 获取 [NGRBMNAME]脏标记
     */
    @JsonIgnore
    public boolean getNgrbmnameDirtyFlag(){
        return ngrbmnameDirtyFlag ;
    }

    /**
     * 获取 [NGRNAME]
     */
    @JsonProperty("ngrname")
    public String getNgrname(){
        return ngrname ;
    }

    /**
     * 设置 [NGRNAME]
     */
    @JsonProperty("ngrname")
    public void setNgrname(String  ngrname){
        this.ngrname = ngrname ;
        this.ngrnameDirtyFlag = true ;
    }

    /**
     * 获取 [NGRNAME]脏标记
     */
    @JsonIgnore
    public boolean getNgrnameDirtyFlag(){
        return ngrnameDirtyFlag ;
    }

    /**
     * 获取 [NGRID]
     */
    @JsonProperty("ngrid")
    public String getNgrid(){
        return ngrid ;
    }

    /**
     * 设置 [NGRID]
     */
    @JsonProperty("ngrid")
    public void setNgrid(String  ngrid){
        this.ngrid = ngrid ;
        this.ngridDirtyFlag = true ;
    }

    /**
     * 获取 [NGRID]脏标记
     */
    @JsonIgnore
    public boolean getNgridDirtyFlag(){
        return ngridDirtyFlag ;
    }

    /**
     * 获取 [NGRBMID]
     */
    @JsonProperty("ngrbmid")
    public String getNgrbmid(){
        return ngrbmid ;
    }

    /**
     * 设置 [NGRBMID]
     */
    @JsonProperty("ngrbmid")
    public void setNgrbmid(String  ngrbmid){
        this.ngrbmid = ngrbmid ;
        this.ngrbmidDirtyFlag = true ;
    }

    /**
     * 获取 [NGRBMID]脏标记
     */
    @JsonIgnore
    public boolean getNgrbmidDirtyFlag(){
        return ngrbmidDirtyFlag ;
    }

    /**
     * 获取 [PSID]
     */
    @JsonProperty("psid")
    public String getPsid(){
        return psid ;
    }

    /**
     * 设置 [PSID]
     */
    @JsonProperty("psid")
    public void setPsid(String  psid){
        this.psid = psid ;
        this.psidDirtyFlag = true ;
    }

    /**
     * 获取 [PSID]脏标记
     */
    @JsonIgnore
    public boolean getPsidDirtyFlag(){
        return psidDirtyFlag ;
    }



    public IM toDO() {
        IM srfdomain = new IM();
        if(getKgsldidsDirtyFlag())
            srfdomain.setKgsldids(kgsldids);
        if(getBzDirtyFlag())
            srfdomain.setBz(bz);
        if(getSblbDirtyFlag())
            srfdomain.setSblb(sblb);
        if(getBmldidsDirtyFlag())
            srfdomain.setBmldids(bmldids);
        if(getJjyyDirtyFlag())
            srfdomain.setJjyy(jjyy);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getHqbmDirtyFlag())
            srfdomain.setHqbm(hqbm);
        if(getSdfsDirtyFlag())
            srfdomain.setSdfs(sdfs);
        if(getKgsbmidsDirtyFlag())
            srfdomain.setKgsbmids(kgsbmids);
        if(getSjbmDirtyFlag())
            srfdomain.setSjbm(sjbm);
        if(getQttzyddxDirtyFlag())
            srfdomain.setQttzyddx(qttzyddx);
        if(getLdDirtyFlag())
            srfdomain.setLd(ld);
        if(getIMNameDirtyFlag())
            srfdomain.setIMName(iMName);
        if(getLcbhDirtyFlag())
            srfdomain.setLcbh(lcbh);
        if(getNgshidsDirtyFlag())
            srfdomain.setNgshids(ngshids);
        if(getKgsldDirtyFlag())
            srfdomain.setKgsld(kgsld);
        if(getShfsDirtyFlag())
            srfdomain.setShfs(shfs);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getIMIdDirtyFlag())
            srfdomain.setIMId(iMId);
        if(getSblxDirtyFlag())
            srfdomain.setSblx(sblx);
        if(getTzydDirtyFlag())
            srfdomain.setTzyd(tzyd);
        if(getWfinstanceidDirtyFlag())
            srfdomain.setWfinstanceid(wfinstanceid);
        if(getBmldDirtyFlag())
            srfdomain.setBmld(bmld);
        if(getTzydyyDirtyFlag())
            srfdomain.setTzydyy(tzydyy);
        if(getImwfstateDirtyFlag())
            srfdomain.setImwfstate(imwfstate);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getYzdxDirtyFlag())
            srfdomain.setYzdx(yzdx);
        if(getNgshDirtyFlag())
            srfdomain.setNgsh(ngsh);
        if(getHjcdDirtyFlag())
            srfdomain.setHjcd(hjcd);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getLdidsDirtyFlag())
            srfdomain.setLdids(ldids);
        if(getHqbmidsDirtyFlag())
            srfdomain.setHqbmids(hqbmids);
        if(getKgsbmDirtyFlag())
            srfdomain.setKgsbm(kgsbm);
        if(getWfstepDirtyFlag())
            srfdomain.setWfstep(wfstep);
        if(getZbbmDirtyFlag())
            srfdomain.setZbbm(zbbm);
        if(getNgrqDirtyFlag())
            srfdomain.setNgrq(ngrq);
        if(getNgrlxfsDirtyFlag())
            srfdomain.setNgrlxfs(ngrlxfs);
        if(getNgrjgDirtyFlag())
            srfdomain.setNgrjg(ngrjg);
        if(getNgrbmnameDirtyFlag())
            srfdomain.setNgrbmname(ngrbmname);
        if(getNgrnameDirtyFlag())
            srfdomain.setNgrname(ngrname);
        if(getNgridDirtyFlag())
            srfdomain.setNgrid(ngrid);
        if(getNgrbmidDirtyFlag())
            srfdomain.setNgrbmid(ngrbmid);
        if(getPsidDirtyFlag())
            srfdomain.setPsid(psid);

        return srfdomain;
    }

    public void fromDO(IM srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getKgsldidsDirtyFlag())
            this.setKgsldids(srfdomain.getKgsldids());
        if(srfdomain.getBzDirtyFlag())
            this.setBz(srfdomain.getBz());
        if(srfdomain.getSblbDirtyFlag())
            this.setSblb(srfdomain.getSblb());
        if(srfdomain.getBmldidsDirtyFlag())
            this.setBmldids(srfdomain.getBmldids());
        if(srfdomain.getJjyyDirtyFlag())
            this.setJjyy(srfdomain.getJjyy());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getHqbmDirtyFlag())
            this.setHqbm(srfdomain.getHqbm());
        if(srfdomain.getSdfsDirtyFlag())
            this.setSdfs(srfdomain.getSdfs());
        if(srfdomain.getKgsbmidsDirtyFlag())
            this.setKgsbmids(srfdomain.getKgsbmids());
        if(srfdomain.getSjbmDirtyFlag())
            this.setSjbm(srfdomain.getSjbm());
        if(srfdomain.getQttzyddxDirtyFlag())
            this.setQttzyddx(srfdomain.getQttzyddx());
        if(srfdomain.getLdDirtyFlag())
            this.setLd(srfdomain.getLd());
        if(srfdomain.getIMNameDirtyFlag())
            this.setIMName(srfdomain.getIMName());
        if(srfdomain.getLcbhDirtyFlag())
            this.setLcbh(srfdomain.getLcbh());
        if(srfdomain.getNgshidsDirtyFlag())
            this.setNgshids(srfdomain.getNgshids());
        if(srfdomain.getKgsldDirtyFlag())
            this.setKgsld(srfdomain.getKgsld());
        if(srfdomain.getShfsDirtyFlag())
            this.setShfs(srfdomain.getShfs());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getIMIdDirtyFlag())
            this.setIMId(srfdomain.getIMId());
        if(srfdomain.getSblxDirtyFlag())
            this.setSblx(srfdomain.getSblx());
        if(srfdomain.getTzydDirtyFlag())
            this.setTzyd(srfdomain.getTzyd());
        if(srfdomain.getWfinstanceidDirtyFlag())
            this.setWfinstanceid(srfdomain.getWfinstanceid());
        if(srfdomain.getBmldDirtyFlag())
            this.setBmld(srfdomain.getBmld());
        if(srfdomain.getTzydyyDirtyFlag())
            this.setTzydyy(srfdomain.getTzydyy());
        if(srfdomain.getImwfstateDirtyFlag())
            this.setImwfstate(srfdomain.getImwfstate());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getYzdxDirtyFlag())
            this.setYzdx(srfdomain.getYzdx());
        if(srfdomain.getNgshDirtyFlag())
            this.setNgsh(srfdomain.getNgsh());
        if(srfdomain.getHjcdDirtyFlag())
            this.setHjcd(srfdomain.getHjcd());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getLdidsDirtyFlag())
            this.setLdids(srfdomain.getLdids());
        if(srfdomain.getHqbmidsDirtyFlag())
            this.setHqbmids(srfdomain.getHqbmids());
        if(srfdomain.getKgsbmDirtyFlag())
            this.setKgsbm(srfdomain.getKgsbm());
        if(srfdomain.getWfstepDirtyFlag())
            this.setWfstep(srfdomain.getWfstep());
        if(srfdomain.getZbbmDirtyFlag())
            this.setZbbm(srfdomain.getZbbm());
        if(srfdomain.getNgrqDirtyFlag())
            this.setNgrq(srfdomain.getNgrq());
        if(srfdomain.getNgrlxfsDirtyFlag())
            this.setNgrlxfs(srfdomain.getNgrlxfs());
        if(srfdomain.getNgrjgDirtyFlag())
            this.setNgrjg(srfdomain.getNgrjg());
        if(srfdomain.getNgrbmnameDirtyFlag())
            this.setNgrbmname(srfdomain.getNgrbmname());
        if(srfdomain.getNgrnameDirtyFlag())
            this.setNgrname(srfdomain.getNgrname());
        if(srfdomain.getNgridDirtyFlag())
            this.setNgrid(srfdomain.getNgrid());
        if(srfdomain.getNgrbmidDirtyFlag())
            this.setNgrbmid(srfdomain.getNgrbmid());
        if(srfdomain.getPsidDirtyFlag())
            this.setPsid(srfdomain.getPsid());

    }

    public List<IMDTO> fromDOPage(List<IM> poPage)   {
        if(poPage == null)
            return null;
        List<IMDTO> dtos=new ArrayList<IMDTO>();
        for(IM domain : poPage) {
            IMDTO dto = new IMDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

