import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';

Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/appindexview/:appindexview?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'appindexview';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: '首页',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindexview', parameterName: 'appindexview' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/ungroup/app-index-view/app-index-view.vue'),
            children: [
                {
                    path: 'ims/:im?/ms_20_30editview/:ms_20_30editview?',
                    meta: {
                        caption: 'im.views.ms_20_30editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_30editview', parameterName: 'ms_20_30editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-30-edit-view/imms-20-30-edit-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20editview/:ms_20editview?',
                    meta: {
                        caption: 'im.views.ms_20editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20editview', parameterName: 'ms_20editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-edit-view/imms-20-edit-view.vue'),
                },
                {
                    path: 'wfstepdata/:wfstepdata?/editview/:editview?',
                    meta: {
                        caption: 'wfstepdata.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'wfstepdata', parameterName: 'wfstepdata' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-wf/wfstepdataedit-view/wfstepdataedit-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_10editview/:ms_10editview?',
                    meta: {
                        caption: 'im.views.ms_10editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_10editview', parameterName: 'ms_10editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-10-edit-view/imms-10-edit-view.vue'),
                },
                {
                    path: 'bcs/:bc?/gridview9/:gridview9?',
                    meta: {
                        caption: 'bc.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'bcs', parameterName: 'bc' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/bcgrid-view9/bcgrid-view9.vue'),
                },
                {
                    path: 'bcs/:bc?/ms_40editview3/:ms_40editview3?',
                    meta: {
                        caption: 'bc.views.ms_40editview3.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'bcs', parameterName: 'bc' },
                            { pathName: 'ms_40editview3', parameterName: 'ms_40editview3' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/bcms-40-edit-view3/bcms-40-edit-view3.vue'),
                },
                {
                    path: 'orgdepts/:orgdept?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'orgdept.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgdepts', parameterName: 'orgdept' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-org/org-dept-pickup-grid-view/org-dept-pickup-grid-view.vue'),
                },
                {
                    path: 'bcs/:bc?/ms_10editview3/:ms_10editview3?',
                    meta: {
                        caption: 'bc.views.ms_10editview3.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'bcs', parameterName: 'bc' },
                            { pathName: 'ms_10editview3', parameterName: 'ms_10editview3' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/bcms-10-edit-view3/bcms-10-edit-view3.vue'),
                },
                {
                    path: 'orgdepts/:orgdept?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'orgdept.views.mpickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgdepts', parameterName: 'orgdept' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-org/org-dept-mpickup-view/org-dept-mpickup-view.vue'),
                },
                {
                    path: 'fjs/:fj?/editview/:editview?',
                    meta: {
                        caption: 'fj.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'fjs', parameterName: 'fj' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/fjedit-view/fjedit-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_90editview/:ms_20_90editview?',
                    meta: {
                        caption: 'im.views.ms_20_90editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_90editview', parameterName: 'ms_20_90editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-90-edit-view/imms-20-90-edit-view.vue'),
                },
                {
                    path: 'ims/:im?/wfproxystartview/:wfproxystartview?',
                    meta: {
                        caption: 'im.views.wfproxystartview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'wfproxystartview', parameterName: 'wfproxystartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imwfproxy-start-view/imwfproxy-start-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_20editview/:ms_20_20editview?',
                    meta: {
                        caption: 'im.views.ms_20_20editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_20editview', parameterName: 'ms_20_20editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-20-edit-view/imms-20-20-edit-view.vue'),
                },
                {
                    path: 'bcs/:bc?/ms_30editview3/:ms_30editview3?',
                    meta: {
                        caption: 'bc.views.ms_30editview3.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'bcs', parameterName: 'bc' },
                            { pathName: 'ms_30editview3', parameterName: 'ms_30editview3' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/bcms-30-edit-view3/bcms-30-edit-view3.vue'),
                },
                {
                    path: 'bcs/:bc?/ms_20editview3/:ms_20editview3?',
                    meta: {
                        caption: 'bc.views.ms_20editview3.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'bcs', parameterName: 'bc' },
                            { pathName: 'ms_20editview3', parameterName: 'ms_20editview3' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/bcms-20-edit-view3/bcms-20-edit-view3.vue'),
                },
                {
                    path: 'orgdepts/:orgdept?/pickupview/:pickupview?',
                    meta: {
                        caption: 'orgdept.views.pickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgdepts', parameterName: 'orgdept' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-org/org-dept-pickup-view/org-dept-pickup-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_10editview/:ms_20_10editview?',
                    meta: {
                        caption: 'im.views.ms_20_10editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_10editview', parameterName: 'ms_20_10editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-10-edit-view/imms-20-10-edit-view.vue'),
                },
                {
                    path: 'orgusers/:orguser?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'orguser.views.mpickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgusers', parameterName: 'orguser' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-org/org-user-mpickup-view/org-user-mpickup-view.vue'),
                },
                {
                    path: 'bcs/:bc?/editview/:editview?',
                    meta: {
                        caption: 'bc.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'bcs', parameterName: 'bc' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/bcedit-view/bcedit-view.vue'),
                },
                {
                    path: 'ims/:im?/gridview/:gridview?',
                    meta: {
                        caption: 'im.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imgrid-view/imgrid-view.vue'),
                },
                {
                    path: 'fjs/:fj?/gridview9/:gridview9?',
                    meta: {
                        caption: 'fj.views.gridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'fjs', parameterName: 'fj' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/fjgrid-view9/fjgrid-view9.vue'),
                },
                {
                    path: 'orgusers/:orguser?/pickupview/:pickupview?',
                    meta: {
                        caption: 'orguser.views.pickupview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgusers', parameterName: 'orguser' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-org/org-user-pickup-view/org-user-pickup-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_40editview/:ms_20_40editview?',
                    meta: {
                        caption: 'im.views.ms_20_40editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_40editview', parameterName: 'ms_20_40editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-40-edit-view/imms-20-40-edit-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_60editview/:ms_20_60editview?',
                    meta: {
                        caption: 'im.views.ms_20_60editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_60editview', parameterName: 'ms_20_60editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-60-edit-view/imms-20-60-edit-view.vue'),
                },
                {
                    path: 'orgusers/:orguser?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'orguser.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'orgusers', parameterName: 'orguser' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-org/org-user-pickup-grid-view/org-user-pickup-grid-view.vue'),
                },
                {
                    path: 'ims/:im?/printeditview/:printeditview?',
                    meta: {
                        caption: 'im.views.printeditview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'printeditview', parameterName: 'printeditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imprint-edit-view/imprint-edit-view.vue'),
                },
                {
                    path: 'ims/:im?/editview/:editview?',
                    meta: {
                        caption: 'im.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imedit-view/imedit-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_50editview/:ms_20_50editview?',
                    meta: {
                        caption: 'im.views.ms_20_50editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_50editview', parameterName: 'ms_20_50editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-50-edit-view/imms-20-50-edit-view.vue'),
                },
                {
                    path: 'wfstepdata/:wfstepdata?/datagridview9/:datagridview9?',
                    meta: {
                        caption: 'wfstepdata.views.datagridview9.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'wfstepdata', parameterName: 'wfstepdata' },
                            { pathName: 'datagridview9', parameterName: 'datagridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/r7rt-wf/wfstepdatadata-grid-view9/wfstepdatadata-grid-view9.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_70editview/:ms_20_70editview?',
                    meta: {
                        caption: 'im.views.ms_20_70editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_70editview', parameterName: 'ms_20_70editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-70-edit-view/imms-20-70-edit-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_30editview/:ms_30editview?',
                    meta: {
                        caption: 'im.views.ms_30editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_30editview', parameterName: 'ms_30editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-30-edit-view/imms-30-edit-view.vue'),
                },
                {
                    path: 'ims/:im?/ms_20_80editview/:ms_20_80editview?',
                    meta: {
                        caption: 'im.views.ms_20_80editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ims', parameterName: 'im' },
                            { pathName: 'ms_20_80editview', parameterName: 'ms_20_80editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/ht/imms-20-80-edit-view/imms-20-80-edit-view.vue'),
                },
            {
                path: 'imredirectview/:imredirectview?',
                meta: {
                    caption: 'im.views.redirectview.caption',
                    parameters: [
                        { pathName: 'imredirectview', parameterName: 'imredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/ht/imredirect-view/imredirect-view.vue'),
            },
            {
                path: 'appdataredirectview/:appdataredirectview?',
                meta: {
                    caption: 'app.views.appredirectview.caption',
                    parameters: [
                        { pathName: 'appredirectview', parameterName: 'appredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/ungroup/app-redirect-view/app-redirect-view.vue'),
            },
            ],
        },
    {
        path: '/ims/:im?/ms_10editview/:ms_10editview?',
        meta: {
            caption: 'im.views.ms_10editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_10editview', parameterName: 'ms_10editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-10-edit-view/imms-10-edit-view.vue'),
    },
    {
        path: '/ims/:im?/ms_30editview/:ms_30editview?',
        meta: {
            caption: 'im.views.ms_30editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_30editview', parameterName: 'ms_30editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-30-edit-view/imms-30-edit-view.vue'),
    },
    {
        path: '/orgdepts/:orgdept?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'orgdept.views.pickupgridview.caption',
            parameters: [
                { pathName: 'orgdepts', parameterName: 'orgdept' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-org/org-dept-pickup-grid-view/org-dept-pickup-grid-view.vue'),
    },
    {
        path: '/orgusers/:orguser?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'orguser.views.pickupgridview.caption',
            parameters: [
                { pathName: 'orgusers', parameterName: 'orguser' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-org/org-user-pickup-grid-view/org-user-pickup-grid-view.vue'),
    },
    {
        path: '/ims/:im?/printeditview/:printeditview?',
        meta: {
            caption: 'im.views.printeditview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'printeditview', parameterName: 'printeditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imprint-edit-view/imprint-edit-view.vue'),
    },
    {
        path: '/ims/:im?/ms_20editview/:ms_20editview?',
        meta: {
            caption: 'im.views.ms_20editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20editview', parameterName: 'ms_20editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-edit-view/imms-20-edit-view.vue'),
    },
    {
        path: '/bcs/:bc?/ms_20editview3/:ms_20editview3?',
        meta: {
            caption: 'bc.views.ms_20editview3.caption',
            parameters: [
                { pathName: 'bcs', parameterName: 'bc' },
                { pathName: 'ms_20editview3', parameterName: 'ms_20editview3' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/bcms-20-edit-view3/bcms-20-edit-view3.vue'),
    },
    {
        path: '/ims/:im?/editview/:editview?',
        meta: {
            caption: 'im.views.editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imedit-view/imedit-view.vue'),
    },
    {
        path: '/ims/:im?/ms_20_40editview/:ms_20_40editview?',
        meta: {
            caption: 'im.views.ms_20_40editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_40editview', parameterName: 'ms_20_40editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-40-edit-view/imms-20-40-edit-view.vue'),
    },
    {
        path: '/orgdepts/:orgdept?/mpickupview/:mpickupview?',
        meta: {
            caption: 'orgdept.views.mpickupview.caption',
            parameters: [
                { pathName: 'orgdepts', parameterName: 'orgdept' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-org/org-dept-mpickup-view/org-dept-mpickup-view.vue'),
    },
    {
        path: '/ims/:im?/gridview/:gridview?',
        meta: {
            caption: 'im.views.gridview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imgrid-view/imgrid-view.vue'),
    },
    {
        path: '/orgusers/:orguser?/mpickupview/:mpickupview?',
        meta: {
            caption: 'orguser.views.mpickupview.caption',
            parameters: [
                { pathName: 'orgusers', parameterName: 'orguser' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-org/org-user-mpickup-view/org-user-mpickup-view.vue'),
    },
    {
        path: '/bcs/:bc?/ms_10editview3/:ms_10editview3?',
        meta: {
            caption: 'bc.views.ms_10editview3.caption',
            parameters: [
                { pathName: 'bcs', parameterName: 'bc' },
                { pathName: 'ms_10editview3', parameterName: 'ms_10editview3' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/bcms-10-edit-view3/bcms-10-edit-view3.vue'),
    },
    {
        path: '/ims/:im?/ms_20_80editview/:ms_20_80editview?',
        meta: {
            caption: 'im.views.ms_20_80editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_80editview', parameterName: 'ms_20_80editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-80-edit-view/imms-20-80-edit-view.vue'),
    },
    {
        path: '/orgdepts/:orgdept?/pickupview/:pickupview?',
        meta: {
            caption: 'orgdept.views.pickupview.caption',
            parameters: [
                { pathName: 'orgdepts', parameterName: 'orgdept' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-org/org-dept-pickup-view/org-dept-pickup-view.vue'),
    },
    {
        path: '/orgusers/:orguser?/pickupview/:pickupview?',
        meta: {
            caption: 'orguser.views.pickupview.caption',
            parameters: [
                { pathName: 'orgusers', parameterName: 'orguser' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-org/org-user-pickup-view/org-user-pickup-view.vue'),
    },
            {
                path: '/imredirectview/:imredirectview?',
                meta: {
                    caption: 'im.views.redirectview.caption',
                    parameters: [
                        { pathName: 'imredirectview', parameterName: 'imredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/ht/imredirect-view/imredirect-view.vue'),
            },
    {
        path: '/ims/:im?/ms_20_50editview/:ms_20_50editview?',
        meta: {
            caption: 'im.views.ms_20_50editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_50editview', parameterName: 'ms_20_50editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-50-edit-view/imms-20-50-edit-view.vue'),
    },
    {
        path: '/wfstepdata/:wfstepdata?/editview/:editview?',
        meta: {
            caption: 'wfstepdata.views.editview.caption',
            parameters: [
                { pathName: 'wfstepdata', parameterName: 'wfstepdata' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-wf/wfstepdataedit-view/wfstepdataedit-view.vue'),
    },
    {
        path: '/fjs/:fj?/gridview9/:gridview9?',
        meta: {
            caption: 'fj.views.gridview9.caption',
            parameters: [
                { pathName: 'fjs', parameterName: 'fj' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/fjgrid-view9/fjgrid-view9.vue'),
    },
    {
        path: '/ims/:im?/ms_20_60editview/:ms_20_60editview?',
        meta: {
            caption: 'im.views.ms_20_60editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_60editview', parameterName: 'ms_20_60editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-60-edit-view/imms-20-60-edit-view.vue'),
    },
    {
        path: '/bcs/:bc?/ms_40editview3/:ms_40editview3?',
        meta: {
            caption: 'bc.views.ms_40editview3.caption',
            parameters: [
                { pathName: 'bcs', parameterName: 'bc' },
                { pathName: 'ms_40editview3', parameterName: 'ms_40editview3' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/bcms-40-edit-view3/bcms-40-edit-view3.vue'),
    },
    {
        path: '/ims/:im?/wfproxystartview/:wfproxystartview?',
        meta: {
            caption: 'im.views.wfproxystartview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'wfproxystartview', parameterName: 'wfproxystartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imwfproxy-start-view/imwfproxy-start-view.vue'),
    },
    {
        path: '/wfstepdata/:wfstepdata?/datagridview9/:datagridview9?',
        meta: {
            caption: 'wfstepdata.views.datagridview9.caption',
            parameters: [
                { pathName: 'wfstepdata', parameterName: 'wfstepdata' },
                { pathName: 'datagridview9', parameterName: 'datagridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/r7rt-wf/wfstepdatadata-grid-view9/wfstepdatadata-grid-view9.vue'),
    },
    {
        path: '/ims/:im?/ms_20_20editview/:ms_20_20editview?',
        meta: {
            caption: 'im.views.ms_20_20editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_20editview', parameterName: 'ms_20_20editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-20-edit-view/imms-20-20-edit-view.vue'),
    },
    {
        path: '/ims/:im?/ms_20_30editview/:ms_20_30editview?',
        meta: {
            caption: 'im.views.ms_20_30editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_30editview', parameterName: 'ms_20_30editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-30-edit-view/imms-20-30-edit-view.vue'),
    },
    {
        path: '/ims/:im?/ms_20_10editview/:ms_20_10editview?',
        meta: {
            caption: 'im.views.ms_20_10editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_10editview', parameterName: 'ms_20_10editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-10-edit-view/imms-20-10-edit-view.vue'),
    },
    {
        path: '/fjs/:fj?/editview/:editview?',
        meta: {
            caption: 'fj.views.editview.caption',
            parameters: [
                { pathName: 'fjs', parameterName: 'fj' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/fjedit-view/fjedit-view.vue'),
    },
    {
        path: '/ims/:im?/ms_20_90editview/:ms_20_90editview?',
        meta: {
            caption: 'im.views.ms_20_90editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_90editview', parameterName: 'ms_20_90editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-90-edit-view/imms-20-90-edit-view.vue'),
    },
    {
        path: '/bcs/:bc?/editview/:editview?',
        meta: {
            caption: 'bc.views.editview.caption',
            parameters: [
                { pathName: 'bcs', parameterName: 'bc' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/bcedit-view/bcedit-view.vue'),
    },
    {
        path: '/ims/:im?/ms_20_70editview/:ms_20_70editview?',
        meta: {
            caption: 'im.views.ms_20_70editview.caption',
            parameters: [
                { pathName: 'ims', parameterName: 'im' },
                { pathName: 'ms_20_70editview', parameterName: 'ms_20_70editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/imms-20-70-edit-view/imms-20-70-edit-view.vue'),
    },
    {
        path: '/bcs/:bc?/ms_30editview3/:ms_30editview3?',
        meta: {
            caption: 'bc.views.ms_30editview3.caption',
            parameters: [
                { pathName: 'bcs', parameterName: 'bc' },
                { pathName: 'ms_30editview3', parameterName: 'ms_30editview3' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/bcms-30-edit-view3/bcms-30-edit-view3.vue'),
    },
    {
        path: '/bcs/:bc?/gridview9/:gridview9?',
        meta: {
            caption: 'bc.views.gridview9.caption',
            parameters: [
                { pathName: 'bcs', parameterName: 'bc' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ht/bcgrid-view9/bcgrid-view9.vue'),
    },
            {
                path: '/appdataredirectview/:appdataredirectview?',
                meta: {
                    caption: 'app.views.appredirectview.caption',
                    parameters: [
                        { pathName: 'appredirectview', parameterName: 'appredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/ungroup/app-redirect-view/app-redirect-view.vue'),
            },
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'appindexview'
        },
    ],
});

export default router;
