package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.BCDTO;
import com.ibiz.core.ht.domain.BC;
import com.ibiz.core.ht.service.IBCService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.ht.filter.BCSearchContext;

@Api(tags = {"BC" })
@RestController
@RequestMapping("")
public class BCResource {

    @Autowired
    private IBCService bcService;

    public IBCService getBcService() {
        return this.bcService;
    }

    @ApiOperation(value = "Get", tags = {"BC" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/bcs/{bc_id}")
    public ResponseEntity<BCDTO> get(@PathVariable("bc_id") String bc_id) {
        BCDTO dto = new BCDTO();
        BC domain = bcService.get(bc_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"BC" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/bcs/{bc_id}/getdraft")
    @Transactional
    public ResponseEntity<BCDTO> getDraft(@PathVariable("bc_id") String bc_id, @RequestBody BCDTO bcdto) {
        BC bc = bcdto.toDO();
    	bc = bcService.getDraft(bc) ;
    	bcdto.fromDO(bc);
        return ResponseEntity.status(HttpStatus.OK).body(bcdto);
    }

    @ApiOperation(value = "Create", tags = {"BC" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/bcs")
    @Transactional
    public ResponseEntity<BCDTO> create(@RequestBody BCDTO bcdto) {
        BCDTO dto = new BCDTO();
        BC domain = bcdto.toDO();
		bcService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"BC" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/bcs/{bc_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("bc_id") String bc_id) {
        BCDTO bcdto = new BCDTO();
		BC domain = new BC();
		bcdto.setBCId(bc_id);
		domain.setBCId(bc_id);
        Boolean rst = bcService.remove(domain.getBCId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Update", tags = {"BC" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/bcs/{bc_id}")
    @Transactional
    public ResponseEntity<BCDTO> update(@PathVariable("bc_id") String bc_id, @RequestBody BCDTO bcdto) {
		BC domain = bcdto.toDO();
        domain.setBCId(bc_id);
		bcService.update(domain);
		BCDTO dto = new BCDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"BC" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/bcs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody BCDTO bcdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Save", tags = {"BC" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/bcs/{bc_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody BCDTO bcdto) {
        BC bc = bcdto.toDO();
    	Boolean b = bcService.save(bc) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"BC" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/bcs/fetchdefault")
	public ResponseEntity<Page<BCDTO>> fetchDefault(BCSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<BCDTO> list = new ArrayList<BCDTO>();
        
        Page<BC> domains = bcService.searchDefault(context) ;
        for(BC bc : domains.getContent()){
            BCDTO dto = new BCDTO();
            dto.fromDO(bc);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
