package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.r7rt_wf.valuerule.anno.wfiaaction.*;
import com.ibiz.core.r7rt_wf.domain.WFIAAction;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[WFIAActionDTO]
 */
public class WFIAActionDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [WFIAACTIONID]
     *
     */
    @WFIAActionWFIAActionIdDefault(info = "默认规则")
    private String wFIAActionId;

    @JsonIgnore
    private boolean wFIAActionIdDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @WFIAActionUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [USERDATA2]
     *
     */
    @WFIAActionUserData2Default(info = "默认规则")
    private String userData2;

    @JsonIgnore
    private boolean userData2DirtyFlag;

    /**
     * 属性 [OPINION]
     *
     */
    @WFIAActionOpinionDefault(info = "默认规则")
    private String opinion;

    @JsonIgnore
    private boolean opinionDirtyFlag;

    /**
     * 属性 [ACTIONTYPE]
     *
     */
    @WFIAActionActionTypeDefault(info = "默认规则")
    private String actionType;

    @JsonIgnore
    private boolean actionTypeDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @WFIAActionCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [PERSONLIST]
     *
     */
    @WFIAActionPersonListDefault(info = "默认规则")
    private String personList;

    @JsonIgnore
    private boolean personListDirtyFlag;

    /**
     * 属性 [USERDATA]
     *
     */
    @WFIAActionUserDataDefault(info = "默认规则")
    private String userData;

    @JsonIgnore
    private boolean userDataDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @WFIAActionCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @WFIAActionUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [WFSTEPID]
     *
     */
    @WFIAActionWFStepIdDefault(info = "默认规则")
    private String wFStepId;

    @JsonIgnore
    private boolean wFStepIdDirtyFlag;

    /**
     * 属性 [WFIAACTIONNAME]
     *
     */
    @WFIAActionWFIAActionNameDefault(info = "默认规则")
    private String wFIAActionName;

    @JsonIgnore
    private boolean wFIAActionNameDirtyFlag;

    /**
     * 属性 [OPPERSON]
     *
     */
    @WFIAActionOpPersonDefault(info = "默认规则")
    private String opPerson;

    @JsonIgnore
    private boolean opPersonDirtyFlag;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @WFIAActionWFInstanceIdDefault(info = "默认规则")
    private String wFInstanceId;

    @JsonIgnore
    private boolean wFInstanceIdDirtyFlag;


    /**
     * 获取 [WFIAACTIONID]
     */
    @JsonProperty("wfiaactionid")
    public String getWFIAActionId(){
        return wFIAActionId ;
    }

    /**
     * 设置 [WFIAACTIONID]
     */
    @JsonProperty("wfiaactionid")
    public void setWFIAActionId(String  wFIAActionId){
        this.wFIAActionId = wFIAActionId ;
        this.wFIAActionIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFIAACTIONID]脏标记
     */
    @JsonIgnore
    public boolean getWFIAActionIdDirtyFlag(){
        return wFIAActionIdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [USERDATA2]
     */
    @JsonProperty("userdata2")
    public String getUserData2(){
        return userData2 ;
    }

    /**
     * 设置 [USERDATA2]
     */
    @JsonProperty("userdata2")
    public void setUserData2(String  userData2){
        this.userData2 = userData2 ;
        this.userData2DirtyFlag = true ;
    }

    /**
     * 获取 [USERDATA2]脏标记
     */
    @JsonIgnore
    public boolean getUserData2DirtyFlag(){
        return userData2DirtyFlag ;
    }

    /**
     * 获取 [OPINION]
     */
    @JsonProperty("opinion")
    public String getOpinion(){
        return opinion ;
    }

    /**
     * 设置 [OPINION]
     */
    @JsonProperty("opinion")
    public void setOpinion(String  opinion){
        this.opinion = opinion ;
        this.opinionDirtyFlag = true ;
    }

    /**
     * 获取 [OPINION]脏标记
     */
    @JsonIgnore
    public boolean getOpinionDirtyFlag(){
        return opinionDirtyFlag ;
    }

    /**
     * 获取 [ACTIONTYPE]
     */
    @JsonProperty("actiontype")
    public String getActionType(){
        return actionType ;
    }

    /**
     * 设置 [ACTIONTYPE]
     */
    @JsonProperty("actiontype")
    public void setActionType(String  actionType){
        this.actionType = actionType ;
        this.actionTypeDirtyFlag = true ;
    }

    /**
     * 获取 [ACTIONTYPE]脏标记
     */
    @JsonIgnore
    public boolean getActionTypeDirtyFlag(){
        return actionTypeDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [PERSONLIST]
     */
    @JsonProperty("personlist")
    public String getPersonList(){
        return personList ;
    }

    /**
     * 设置 [PERSONLIST]
     */
    @JsonProperty("personlist")
    public void setPersonList(String  personList){
        this.personList = personList ;
        this.personListDirtyFlag = true ;
    }

    /**
     * 获取 [PERSONLIST]脏标记
     */
    @JsonIgnore
    public boolean getPersonListDirtyFlag(){
        return personListDirtyFlag ;
    }

    /**
     * 获取 [USERDATA]
     */
    @JsonProperty("userdata")
    public String getUserData(){
        return userData ;
    }

    /**
     * 设置 [USERDATA]
     */
    @JsonProperty("userdata")
    public void setUserData(String  userData){
        this.userData = userData ;
        this.userDataDirtyFlag = true ;
    }

    /**
     * 获取 [USERDATA]脏标记
     */
    @JsonIgnore
    public boolean getUserDataDirtyFlag(){
        return userDataDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [WFSTEPID]
     */
    @JsonProperty("wfstepid")
    public String getWFStepId(){
        return wFStepId ;
    }

    /**
     * 设置 [WFSTEPID]
     */
    @JsonProperty("wfstepid")
    public void setWFStepId(String  wFStepId){
        this.wFStepId = wFStepId ;
        this.wFStepIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEPID]脏标记
     */
    @JsonIgnore
    public boolean getWFStepIdDirtyFlag(){
        return wFStepIdDirtyFlag ;
    }

    /**
     * 获取 [WFIAACTIONNAME]
     */
    @JsonProperty("wfiaactionname")
    public String getWFIAActionName(){
        return wFIAActionName ;
    }

    /**
     * 设置 [WFIAACTIONNAME]
     */
    @JsonProperty("wfiaactionname")
    public void setWFIAActionName(String  wFIAActionName){
        this.wFIAActionName = wFIAActionName ;
        this.wFIAActionNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFIAACTIONNAME]脏标记
     */
    @JsonIgnore
    public boolean getWFIAActionNameDirtyFlag(){
        return wFIAActionNameDirtyFlag ;
    }

    /**
     * 获取 [OPPERSON]
     */
    @JsonProperty("opperson")
    public String getOpPerson(){
        return opPerson ;
    }

    /**
     * 设置 [OPPERSON]
     */
    @JsonProperty("opperson")
    public void setOpPerson(String  opPerson){
        this.opPerson = opPerson ;
        this.opPersonDirtyFlag = true ;
    }

    /**
     * 获取 [OPPERSON]脏标记
     */
    @JsonIgnore
    public boolean getOpPersonDirtyFlag(){
        return opPersonDirtyFlag ;
    }

    /**
     * 获取 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public String getWFInstanceId(){
        return wFInstanceId ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public void setWFInstanceId(String  wFInstanceId){
        this.wFInstanceId = wFInstanceId ;
        this.wFInstanceIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWFInstanceIdDirtyFlag(){
        return wFInstanceIdDirtyFlag ;
    }



    public WFIAAction toDO() {
        WFIAAction srfdomain = new WFIAAction();
        if(getWFIAActionIdDirtyFlag())
            srfdomain.setWFIAActionId(wFIAActionId);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getUserData2DirtyFlag())
            srfdomain.setUserData2(userData2);
        if(getOpinionDirtyFlag())
            srfdomain.setOpinion(opinion);
        if(getActionTypeDirtyFlag())
            srfdomain.setActionType(actionType);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getPersonListDirtyFlag())
            srfdomain.setPersonList(personList);
        if(getUserDataDirtyFlag())
            srfdomain.setUserData(userData);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getWFStepIdDirtyFlag())
            srfdomain.setWFStepId(wFStepId);
        if(getWFIAActionNameDirtyFlag())
            srfdomain.setWFIAActionName(wFIAActionName);
        if(getOpPersonDirtyFlag())
            srfdomain.setOpPerson(opPerson);
        if(getWFInstanceIdDirtyFlag())
            srfdomain.setWFInstanceId(wFInstanceId);

        return srfdomain;
    }

    public void fromDO(WFIAAction srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getWFIAActionIdDirtyFlag())
            this.setWFIAActionId(srfdomain.getWFIAActionId());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getUserData2DirtyFlag())
            this.setUserData2(srfdomain.getUserData2());
        if(srfdomain.getOpinionDirtyFlag())
            this.setOpinion(srfdomain.getOpinion());
        if(srfdomain.getActionTypeDirtyFlag())
            this.setActionType(srfdomain.getActionType());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getPersonListDirtyFlag())
            this.setPersonList(srfdomain.getPersonList());
        if(srfdomain.getUserDataDirtyFlag())
            this.setUserData(srfdomain.getUserData());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getWFStepIdDirtyFlag())
            this.setWFStepId(srfdomain.getWFStepId());
        if(srfdomain.getWFIAActionNameDirtyFlag())
            this.setWFIAActionName(srfdomain.getWFIAActionName());
        if(srfdomain.getOpPersonDirtyFlag())
            this.setOpPerson(srfdomain.getOpPerson());
        if(srfdomain.getWFInstanceIdDirtyFlag())
            this.setWFInstanceId(srfdomain.getWFInstanceId());

    }

    public List<WFIAActionDTO> fromDOPage(List<WFIAAction> poPage)   {
        if(poPage == null)
            return null;
        List<WFIAActionDTO> dtos=new ArrayList<WFIAActionDTO>();
        for(WFIAAction domain : poPage) {
            WFIAActionDTO dto = new WFIAActionDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

