package com.ibiz.wfweb.r7rt_org.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb.r7rt_org.domain.OrgUser;
import com.ibiz.wfweb.r7rt_org.filter.*;


public interface OrgUserFeignClient {



	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgusers/{orguser_id}")
    public Boolean remove(@PathVariable("orguser_id") String orguser_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/{orguser_id}/save")
    public OrgUser save(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUser orguser) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgusers/{orguser_id}")
    public OrgUser update(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUser orguser) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/checkkey")
    public Boolean checkKey(@RequestBody OrgUser orguser) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/{orguser_id}/getdraft")
    public OrgUser getDraft(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUser orguser) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers")
    public OrgUser create(@RequestBody OrgUser orguser) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/{orguser_id}")
    public OrgUser get(@PathVariable("orguser_id") String orguser_id) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/orgusers/fetchdefault")
	public Page<OrgUser> fetchDefault(OrgUserSearchContext searchContext) ;
}
