package com.ibiz.wfweb.r7rt_wf.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb.r7rt_wf.service.WFIAActionService;
import com.ibiz.wfweb.r7rt_wf.domain.WFIAAction;
import com.ibiz.wfweb.r7rt_wf.filter.*;

@RestController
@RequestMapping(value = "")
public class WFIAActionController {
	@Autowired
    WFIAActionService wfiaactionservice;


	@RequestMapping(method = RequestMethod.DELETE, value = "/wfiaactions/{wfiaaction_id}")
    @PreAuthorize("@wfiaaction_pms.check(#wfiaaction_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("wfiaaction_id") String wfiaaction_id) {
        boolean b = wfiaactionservice.remove( wfiaaction_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/wfiaactions/{wfiaaction_id}")
    @PreAuthorize("@wfiaaction_pms.check(#wfiaaction_id,'UPDATE')")
    public ResponseEntity<WFIAAction> update(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAAction wfiaaction) {
        WFIAAction wfiaaction2 = wfiaactionservice.update(wfiaaction_id, wfiaaction);
        return ResponseEntity.status(HttpStatus.OK).body(wfiaaction2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/wfiaactions/{wfiaaction_id}")
    @PreAuthorize("@wfiaaction_pms.check(#wfiaaction_id,'UPDATE')")
    public ResponseEntity<WFIAAction> api_update(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAAction wfiaaction) {
        WFIAAction wfiaaction2 = wfiaactionservice.update(wfiaaction_id, wfiaaction);
        return ResponseEntity.status(HttpStatus.OK).body(wfiaaction2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfiaactions/{wfiaaction_id}/save")
    @PreAuthorize("@wfiaaction_pms.check(#wfiaaction_id,'')")
    public ResponseEntity<WFIAAction> save(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAAction wfiaaction) {
        WFIAAction wfiaaction2 = wfiaactionservice.save(wfiaaction_id, wfiaaction);
        return ResponseEntity.status(HttpStatus.OK).body(wfiaaction2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfiaactions/{wfiaaction_id}")
    @PreAuthorize("@wfiaaction_pms.check(#wfiaaction_id,'READ')")
    public ResponseEntity<WFIAAction> get(@PathVariable("wfiaaction_id") String wfiaaction_id) {
        WFIAAction wfiaaction = wfiaactionservice.get( wfiaaction_id);
        return ResponseEntity.status(HttpStatus.OK).body(wfiaaction);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfiaactions/checkkey")
    @PreAuthorize("@wfiaaction_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFIAAction wfiaaction) {
        boolean b = wfiaactionservice.checkKey(wfiaaction);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfiaactions/getdraft")
    @PreAuthorize("@wfiaaction_pms.check('CREATE')")
    public ResponseEntity<WFIAAction> getDraft() {
        //WFIAAction wfiaaction = wfiaactionservice.getDraft( wfiaaction_id);
        return ResponseEntity.status(HttpStatus.OK).body(new WFIAAction());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfiaactions")
    @PreAuthorize("@wfiaaction_pms.check('CREATE')")
    public ResponseEntity<WFIAAction> create(@RequestBody WFIAAction wfiaaction) {
        WFIAAction wfiaaction2 = wfiaactionservice.create(wfiaaction);
        return ResponseEntity.status(HttpStatus.OK).body(wfiaaction2);
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfiaactions/fetchdefault")
    @PreAuthorize("@wfiaaction_pms.check('READ')")
	public ResponseEntity<List<WFIAAction>> fetchDefault(WFIAActionSearchContext searchContext,Pageable pageable) {
        
        Page<WFIAAction> page = wfiaactionservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


}
