package com.ibiz.wfweb.htwf.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb.htwf.service.WFIMService;
import com.ibiz.wfweb.htwf.domain.WFIM;
import com.ibiz.wfweb.htwf.filter.*;

@RestController
@RequestMapping(value = "")
public class WFIMController {
	@Autowired
    WFIMService wfimservice;


	@RequestMapping(method = RequestMethod.DELETE, value = "/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("wfim_id") String wfim_id) {
        boolean b = wfimservice.remove( wfim_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'UPDATE')")
    public ResponseEntity<WFIM> update(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.update(wfim_id, wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'UPDATE')")
    public ResponseEntity<WFIM> api_update(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.update(wfim_id, wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfims/getdraft")
    @PreAuthorize("@wfim_pms.check('CREATE')")
    public ResponseEntity<WFIM> getDraft() {
        //WFIM wfim = wfimservice.getDraft( wfim_id);
        return ResponseEntity.status(HttpStatus.OK).body(new WFIM());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/save")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'')")
    public ResponseEntity<WFIM> save(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.save(wfim_id, wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfims")
    @PreAuthorize("@wfim_pms.check('CREATE')")
    public ResponseEntity<WFIM> create(@RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.create(wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'READ')")
    public ResponseEntity<WFIM> get(@PathVariable("wfim_id") String wfim_id) {
        WFIM wfim = wfimservice.get( wfim_id);
        return ResponseEntity.status(HttpStatus.OK).body(wfim);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfims/checkkey")
    @PreAuthorize("@wfim_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFIM wfim) {
        boolean b = wfimservice.checkKey(wfim);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfims/fetchdefault")
    @PreAuthorize("@wfim_pms.check('READ')")
	public ResponseEntity<List<WFIM>> fetchDefault(WFIMSearchContext searchContext,Pageable pageable) {
        
        Page<WFIM> page = wfimservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


    /** 工作流行为 **/

    /**
     * 开始流程【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfstart")
    public ResponseEntity<JSONObject> wfStart(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", false);
        if (wfimservice.wfStart(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 开始流程2【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/api/wfims/wfstart")
    public ResponseEntity<JSONObject> wfStart(@RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", true);
        if (wfimservice.wfStart(null, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程处理【WFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfsubmit")
    public ResponseEntity<JSONObject> wfSubmit(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (wfimservice.wfSubmit(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 测试当前用户是否提交过工作流【testUserWFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/testuserwfsubmit")
    public ResponseEntity<Boolean> testUserWFSubmit(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfimservice.testUserWFSubmit(wfim_id, data));
    }

    /**
     * 测试当前用户是否存在工作任务【testUserExistWorklist】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/testuserexistworklist")
    public ResponseEntity<Boolean> testUserExistWorklist(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfimservice.testUserExistWorklist(wfim_id, data));
    }

    /**
     * 流程结束【WFClose】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfclose")
    public ResponseEntity<JSONObject> wfClose(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (wfimservice.wfClose(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程跳转【WFGoto】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfgoto")
    public ResponseEntity<JSONObject> wfGoto(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (wfimservice.wfGoto(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重启【WFRestart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfrestart")
    public ResponseEntity<JSONObject> wfRestart(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (wfimservice.wfRestart(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程撤回【WFRollback】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfrollback")
    public ResponseEntity<JSONObject> wfRollback(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (wfimservice.wfRollback(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程退回【WFSendBack】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfsendback")
    public ResponseEntity<JSONObject> wfSendBack(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (wfimservice.wfSendBack(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重新分配【WFReassign】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfreassign")
    public ResponseEntity<JSONObject> wfReassign(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        if (wfimservice.wfReassign(wfim_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程标记已读【WFMarkRead】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/wfmarkread")
    public ResponseEntity<Boolean> wfMarkRead(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfimservice.wfMarkRead(wfim_id, data));
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    @RequestMapping(method = RequestMethod.POST, value = "api/wfims/{wfim_id}/wfaction")
    public ResponseEntity<JSONObject> wfAction(@PathVariable("wfim_id") String wfim_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfimservice.wfAction(wfim_id, data));
    }

    /**
     * 获取代理数据【WFGetProxyData】
     */
    @RequestMapping(method = RequestMethod.GET, value = "/wfims/{wfim_id}/wfgetproxydata")
    public ResponseEntity<JSONObject> wfGetProxyData(@PathVariable("wfim_id") String wfim_id) {
        return ResponseEntity.status(HttpStatus.OK).body(wfimservice.wfGetProxyData(wfim_id));
    }


}
