package com.ibiz.web.r7rt_org.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[组织]
 */
public class Org implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 是否启用
     */
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 组织名称
     */
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * 组织编码
     */
    private String orgCode;

    @JsonIgnore
    private boolean orgCodeDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 级别编码
     */
    private String levelCode;

    @JsonIgnore
    private boolean levelCodeDirtyFlag;
    
    /**
     * 组织标识
     */
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * 上级组织
     */
    private String pOrgName;

    @JsonIgnore
    private boolean pOrgNameDirtyFlag;
    
    /**
     * 上级组织标识
     */
    private String pOrgId;

    @JsonIgnore
    private boolean pOrgIdDirtyFlag;
    

    /**
     * 获取 [是否启用]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return this.enable ;
    }

    /**
     * 设置 [是否启用]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [是否启用]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return this.enableDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [组织名称]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return this.orgName ;
    }

    /**
     * 设置 [组织名称]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [组织名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return this.orgNameDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [组织编码]
     */
    @JsonProperty("orgcode")
    public String getOrgCode(){
        return this.orgCode ;
    }

    /**
     * 设置 [组织编码]
     */
    @JsonProperty("orgcode")
    public void setOrgCode(String  orgCode){
        this.orgCode = orgCode ;
        this.orgCodeDirtyFlag = true ;
    }

    /**
     * 获取 [组织编码]脏标记
     */
    @JsonIgnore
    public boolean getOrgCodeDirtyFlag(){
        return this.orgCodeDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [级别编码]
     */
    @JsonProperty("levelcode")
    public String getLevelCode(){
        return this.levelCode ;
    }

    /**
     * 设置 [级别编码]
     */
    @JsonProperty("levelcode")
    public void setLevelCode(String  levelCode){
        this.levelCode = levelCode ;
        this.levelCodeDirtyFlag = true ;
    }

    /**
     * 获取 [级别编码]脏标记
     */
    @JsonIgnore
    public boolean getLevelCodeDirtyFlag(){
        return this.levelCodeDirtyFlag ;
    }

    /**
     * 获取 [组织标识]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return this.orgId ;
    }

    /**
     * 设置 [组织标识]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [组织标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return this.orgIdDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [上级组织]
     */
    @JsonProperty("porgname")
    public String getPOrgName(){
        return this.pOrgName ;
    }

    /**
     * 设置 [上级组织]
     */
    @JsonProperty("porgname")
    public void setPOrgName(String  pOrgName){
        this.pOrgName = pOrgName ;
        this.pOrgNameDirtyFlag = true ;
    }

    /**
     * 获取 [上级组织]脏标记
     */
    @JsonIgnore
    public boolean getPOrgNameDirtyFlag(){
        return this.pOrgNameDirtyFlag ;
    }

    /**
     * 获取 [上级组织标识]
     */
    @JsonProperty("porgid")
    public String getPOrgId(){
        return this.pOrgId ;
    }

    /**
     * 设置 [上级组织标识]
     */
    @JsonProperty("porgid")
    public void setPOrgId(String  pOrgId){
        this.pOrgId = pOrgId ;
        this.pOrgIdDirtyFlag = true ;
    }

    /**
     * 获取 [上级组织标识]脏标记
     */
    @JsonIgnore
    public boolean getPOrgIdDirtyFlag(){
        return this.pOrgIdDirtyFlag ;
    }



}
