package com.ibiz.client.wf.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.ibiz.core.client.model.IWFSTEPDATA;
import com.ibiz.client.wf.config.WFClientProperties;
import com.ibiz.core.client.service.IWFSTEPDATAClientService;
import com.ibiz.client.wf.model.WFSTEPDATAImpl;
import com.ibiz.client.wf.feign.WFSTEPDATAFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[WFSTEPDATA] 服务对象接口
 */
@Service
public class WFSTEPDATAClientServiceImpl implements IWFSTEPDATAClientService {

    WFSTEPDATAFeignClient wFSTEPDATAFeignClient;

    @Autowired
    public WFSTEPDATAClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,WFClientProperties wfClientProperties) {
        if (wfClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.wFSTEPDATAFeignClient = nameBuilder.target(WFSTEPDATAFeignClient.class,"http://"+wfClientProperties.getServiceId()+"/") ;
		}else if (wfClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.wFSTEPDATAFeignClient = nameBuilder.target(WFSTEPDATAFeignClient.class,"http://"+wfClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public IWFSTEPDATA createModel() {
		return new WFSTEPDATAImpl();
	}


    public Page<IWFSTEPDATA> select(SearchContext context){
        return null ;
    }


    public void checkKey(IWFSTEPDATA wfstepdata){
        IWFSTEPDATA clientModel = wFSTEPDATAFeignClient.checkKey(wfstepdata.getWFSTEPDATAId(),(WFSTEPDATAImpl)wfstepdata) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfstepdata.getClass(), false);
        copier.copy(clientModel, wfstepdata, null);
    }


    public void get(IWFSTEPDATA wfstepdata){
        IWFSTEPDATA clientModel = wFSTEPDATAFeignClient.get(wfstepdata.getWFSTEPDATAId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfstepdata.getClass(), false);
        copier.copy(clientModel, wfstepdata, null);
    }


    public void getDraft(IWFSTEPDATA wfstepdata){
        IWFSTEPDATA clientModel = wFSTEPDATAFeignClient.getDraft(wfstepdata.getWFSTEPDATAId(),(WFSTEPDATAImpl)wfstepdata) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfstepdata.getClass(), false);
        copier.copy(clientModel, wfstepdata, null);
    }


    public void create(IWFSTEPDATA wfstepdata){
        IWFSTEPDATA clientModel = wFSTEPDATAFeignClient.create((WFSTEPDATAImpl)wfstepdata) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfstepdata.getClass(), false);
        copier.copy(clientModel, wfstepdata, null);
    }


    public void update(IWFSTEPDATA wfstepdata){
        IWFSTEPDATA clientModel = wFSTEPDATAFeignClient.update(wfstepdata.getWFSTEPDATAId(),(WFSTEPDATAImpl)wfstepdata) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfstepdata.getClass(), false);
        copier.copy(clientModel, wfstepdata, null);
    }


    public void save(IWFSTEPDATA wfstepdata){
        IWFSTEPDATA clientModel = wFSTEPDATAFeignClient.save(wfstepdata.getWFSTEPDATAId(),(WFSTEPDATAImpl)wfstepdata) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfstepdata.getClass(), false);
        copier.copy(clientModel, wfstepdata, null);
    }


    public void remove(IWFSTEPDATA wfstepdata){
        wFSTEPDATAFeignClient.remove(wfstepdata.getWFSTEPDATAId()) ;
    }


    public Page<IWFSTEPDATA> fetchByBswfdata(SearchContext context){
        Page<WFSTEPDATAImpl> page = this.wFSTEPDATAFeignClient.fetchByBswfdata(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public Page<IWFSTEPDATA> fetchByBsdata(SearchContext context){
        Page<WFSTEPDATAImpl> page = this.wFSTEPDATAFeignClient.fetchByBsdata(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public Page<IWFSTEPDATA> fetchDefault(SearchContext context){
        Page<WFSTEPDATAImpl> page = this.wFSTEPDATAFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }



}

