package com.ibiz.wfweb2.htwf.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb2.htwf.domain.WFIM;
import com.ibiz.wfweb2.htwf.filter.*;


public interface WFIMFeignClient {



	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfims/{wfim_id}")
    public Boolean remove(@PathVariable("wfim_id") String wfim_id) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfims/{wfim_id}")
    public WFIM update(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfims/{wfim_id}/getdraft")
    public WFIM getDraft(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfims/{wfim_id}/save")
    public WFIM save(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfims")
    public WFIM create(@RequestBody WFIM wfim) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfims/{wfim_id}")
    public WFIM get(@PathVariable("wfim_id") String wfim_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfims/checkkey")
    public Boolean checkKey(@RequestBody WFIM wfim) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfims/fetchdefault")
	public Page<WFIM> fetchDefault(WFIMSearchContext searchContext) ;
}
