package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.FJDTO;
import com.ibiz.core.ht.domain.FJ;
import com.ibiz.core.ht.service.IFJService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.ht.filter.FJSearchContext;

@Api(tags = {"FJ" })
@RestController
@RequestMapping("")
public class FJResource {

    @Autowired
    private IFJService fjService;

    public IFJService getFjService() {
        return this.fjService;
    }

    @ApiOperation(value = "Save", tags = {"FJ" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/fjs/{fj_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody FJDTO fjdto) {
        FJ fj = fjdto.toDO();
    	Boolean b = fjService.save(fj) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Create", tags = {"FJ" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/fjs")
    @Transactional
    public ResponseEntity<FJDTO> create(@RequestBody FJDTO fjdto) {
        FJDTO dto = new FJDTO();
        FJ domain = fjdto.toDO();
		fjService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Update", tags = {"FJ" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/fjs/{fj_id}")
    @Transactional
    public ResponseEntity<FJDTO> update(@PathVariable("fj_id") String fj_id, @RequestBody FJDTO fjdto) {
		FJ domain = fjdto.toDO();
        domain.setFJId(fj_id);
		fjService.update(domain);
		FJDTO dto = new FJDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"FJ" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/fjs/{fj_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("fj_id") String fj_id) {
        FJDTO fjdto = new FJDTO();
		FJ domain = new FJ();
		fjdto.setFJId(fj_id);
		domain.setFJId(fj_id);
        Boolean rst = fjService.remove(domain.getFJId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Get", tags = {"FJ" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/fjs/{fj_id}")
    public ResponseEntity<FJDTO> get(@PathVariable("fj_id") String fj_id) {
        FJDTO dto = new FJDTO();
        FJ domain = fjService.get(fj_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"FJ" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/fjs/{fj_id}/getdraft")
    @Transactional
    public ResponseEntity<FJDTO> getDraft(@PathVariable("fj_id") String fj_id, @RequestBody FJDTO fjdto) {
        FJ fj = fjdto.toDO();
    	fj = fjService.getDraft(fj) ;
    	fjdto.fromDO(fj);
        return ResponseEntity.status(HttpStatus.OK).body(fjdto);
    }

    @ApiOperation(value = "CheckKey", tags = {"FJ" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/fjs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody FJDTO fjdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取CurFJ", tags = {"FJ" } ,notes = "获取CurFJ")
    @RequestMapping(method= RequestMethod.GET , value="/web/fjs/fetchcurfj")
	public ResponseEntity<Page<FJDTO>> fetchCurFJ(FJSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<FJDTO> list = new ArrayList<FJDTO>();
        
        Page<FJ> domains = fjService.searchCurFJ(context) ;
        for(FJ fj : domains.getContent()){
            FJDTO dto = new FJDTO();
            dto.fromDO(fj);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取DEFAULT", tags = {"FJ" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/fjs/fetchdefault")
	public ResponseEntity<Page<FJDTO>> fetchDefault(FJSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<FJDTO> list = new ArrayList<FJDTO>();
        
        Page<FJ> domains = fjService.searchDefault(context) ;
        for(FJ fj : domains.getContent()){
            FJDTO dto = new FJDTO();
            dto.fromDO(fj);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
