package com.ibiz.mybatis.ht.po;

import com.ibiz.core.repository.po.IM;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.ibiz.util.annotation.PreField;
import com.ibiz.util.enums.FillMode;
import com.ibiz.util.enums.PredefinedType;

/**
 * 关系型数据实体表[IM] 对象
 */
@TableName(value = "T_IM",resultMap = "T_IMResultMap")
public class T_IMImpl implements IM,Serializable {

    /**
     * [跨公司领导人员清单]
     */
    private String kgsldids;
    /**
     * [跨公司领导人员清单]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean kgsldidsDirtyFlag;

    /**
     * [备注]
     */
    private String bz;
    /**
     * [备注]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bzDirtyFlag;

    /**
     * [申报类别]
     */
    private String sblb;
    /**
     * [申报类别]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean sblbDirtyFlag;

    /**
     * [部门领导人员清单]
     */
    private String bmldids;
    /**
     * [部门领导人员清单]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bmldidsDirtyFlag;

    /**
     * [加急原因]
     */
    private String jjyy;
    /**
     * [加急原因]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean jjyyDirtyFlag;

    /**
     * [建立时间]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEDATE)
    private Timestamp createDate;
    /**
     * [建立时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createDateDirtyFlag;

    /**
     * [会签部门]
     */
    private String hqbm;
    /**
     * [会签部门]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean hqbmDirtyFlag;

    /**
     * [送达方式]
     */
    private String sdfs;
    /**
     * [送达方式]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean sdfsDirtyFlag;

    /**
     * [跨公司部门人员清单]
     */
    private String kgsbmids;
    /**
     * [跨公司部门人员清单]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean kgsbmidsDirtyFlag;

    /**
     * [上级部门]
     */
    private Integer sjbm;
    /**
     * [上级部门]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean sjbmDirtyFlag;

    /**
     * [其他通知阅读对象]
     */
    private String qttzyddx;
    /**
     * [其他通知阅读对象]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean qttzyddxDirtyFlag;

    /**
     * [领导]
     */
    private String ld;
    /**
     * [领导]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ldDirtyFlag;

    /**
     * [标题]
     */
    private String iMName;
    /**
     * [标题]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean iMNameDirtyFlag;

    /**
     * [流程编号]
     */
    private String lcbh;
    /**
     * [流程编号]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean lcbhDirtyFlag;

    /**
     * [内部审核人员清单]
     */
    private String ngshids;
    /**
     * [内部审核人员清单]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngshidsDirtyFlag;

    /**
     * [跨公司领导]
     */
    private String kgsld;
    /**
     * [跨公司领导]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean kgsldDirtyFlag;

    /**
     * [审核方式]
     */
    private String shfs;
    /**
     * [审核方式]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean shfsDirtyFlag;

    /**
     * [更新时间]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEDATE)
    private Timestamp updateDate;
    /**
     * [更新时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateDateDirtyFlag;

    /**
     * [重要事项标识]
     */
    @TableId(value= "imid",type=IdType.UUID)
    private String iMId;
    /**
     * [重要事项标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean iMIdDirtyFlag;

    /**
     * [申报类型]
     */
    private String sblx;
    /**
     * [申报类型]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean sblxDirtyFlag;

    /**
     * [通知阅读]
     */
    private Integer tzyd;
    /**
     * [通知阅读]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean tzydDirtyFlag;

    /**
     * [流程实例]
     */
    private String wfinstanceid;
    /**
     * [流程实例]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wfinstanceidDirtyFlag;

    /**
     * [部门领导]
     */
    private String bmld;
    /**
     * [部门领导]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bmldDirtyFlag;

    /**
     * [通知阅读原因]
     */
    private String tzydyy;
    /**
     * [通知阅读原因]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean tzydyyDirtyFlag;

    /**
     * [工作流状态]
     */
    private String imwfstate;
    /**
     * [工作流状态]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean imwfstateDirtyFlag;

    /**
     * [建立人]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMAN)
    private String createMan;
    /**
     * [建立人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createManDirtyFlag;

    /**
     * [阅知对象]
     */
    private String yzdx;
    /**
     * [阅知对象]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean yzdxDirtyFlag;

    /**
     * [内部审核]
     */
    private String ngsh;
    /**
     * [内部审核]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngshDirtyFlag;

    /**
     * [缓急程度]
     */
    private String hjcd;
    /**
     * [缓急程度]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean hjcdDirtyFlag;

    /**
     * [更新人]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMAN)
    private String updateMan;
    /**
     * [更新人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateManDirtyFlag;

    /**
     * [领导人员清单]
     */
    private String ldids;
    /**
     * [领导人员清单]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ldidsDirtyFlag;

    /**
     * [会签部门人员清单]
     */
    private String hqbmids;
    /**
     * [会签部门人员清单]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean hqbmidsDirtyFlag;

    /**
     * [跨公司部门]
     */
    private String kgsbm;
    /**
     * [跨公司部门]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean kgsbmDirtyFlag;

    /**
     * [重要事项审批步骤]
     */
    private String wfstep;
    /**
     * [重要事项审批步骤]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wfstepDirtyFlag;

    /**
     * [主办部门]
     */
    private String zbbm;
    /**
     * [主办部门]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean zbbmDirtyFlag;

    /**
     * [拟稿日期]
     */
    private Timestamp ngrq;
    /**
     * [拟稿日期]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngrqDirtyFlag;

    /**
     * [拟稿人联系方式]
     */
    private String ngrlxfs;
    /**
     * [拟稿人联系方式]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngrlxfsDirtyFlag;

    /**
     * [拟稿人所在机构]
     */
    private String ngrjg;
    /**
     * [拟稿人所在机构]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngrjgDirtyFlag;

    /**
     * [拟稿人所在部门]
     */
    private String ngrbmname;
    /**
     * [拟稿人所在部门]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngrbmnameDirtyFlag;

    /**
     * [拟稿人]
     */
    private String ngrname;
    /**
     * [拟稿人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngrnameDirtyFlag;

    /**
     * [组织用户标识]
     */
    private String ngrid;
    /**
     * [组织用户标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngridDirtyFlag;

    /**
     * [部门标识]
     */
    private String ngrbmid;
    /**
     * [部门标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ngrbmidDirtyFlag;

    /**
     * [PSID]
     */
    private String psid;
    /**
     * [PSID]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean psidDirtyFlag;

    /**
     * 获取 [跨公司领导人员清单]
     */
    public String getKgsldids(){
        return this.kgsldids ;
    }

    /**
     * 设置 [跨公司领导人员清单]
     */
    public void setKgsldids(String  kgsldids){
        this.kgsldids = kgsldids ;
        this.kgsldidsDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司领导人员清单]脏标记
     */
    @JsonIgnore
    public boolean getKgsldidsDirtyFlag(){
        return this.kgsldidsDirtyFlag ;
    }
    /**
     * 获取 [备注]
     */
    public String getBz(){
        return this.bz ;
    }

    /**
     * 设置 [备注]
     */
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [备注]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return this.bzDirtyFlag ;
    }
    /**
     * 获取 [申报类别]
     */
    public String getSblb(){
        return this.sblb ;
    }

    /**
     * 设置 [申报类别]
     */
    public void setSblb(String  sblb){
        this.sblb = sblb ;
        this.sblbDirtyFlag = true ;
    }

    /**
     * 获取 [申报类别]脏标记
     */
    @JsonIgnore
    public boolean getSblbDirtyFlag(){
        return this.sblbDirtyFlag ;
    }
    /**
     * 获取 [部门领导人员清单]
     */
    public String getBmldids(){
        return this.bmldids ;
    }

    /**
     * 设置 [部门领导人员清单]
     */
    public void setBmldids(String  bmldids){
        this.bmldids = bmldids ;
        this.bmldidsDirtyFlag = true ;
    }

    /**
     * 获取 [部门领导人员清单]脏标记
     */
    @JsonIgnore
    public boolean getBmldidsDirtyFlag(){
        return this.bmldidsDirtyFlag ;
    }
    /**
     * 获取 [加急原因]
     */
    public String getJjyy(){
        return this.jjyy ;
    }

    /**
     * 设置 [加急原因]
     */
    public void setJjyy(String  jjyy){
        this.jjyy = jjyy ;
        this.jjyyDirtyFlag = true ;
    }

    /**
     * 获取 [加急原因]脏标记
     */
    @JsonIgnore
    public boolean getJjyyDirtyFlag(){
        return this.jjyyDirtyFlag ;
    }
    /**
     * 获取 [建立时间]
     */
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }
    /**
     * 获取 [会签部门]
     */
    public String getHqbm(){
        return this.hqbm ;
    }

    /**
     * 设置 [会签部门]
     */
    public void setHqbm(String  hqbm){
        this.hqbm = hqbm ;
        this.hqbmDirtyFlag = true ;
    }

    /**
     * 获取 [会签部门]脏标记
     */
    @JsonIgnore
    public boolean getHqbmDirtyFlag(){
        return this.hqbmDirtyFlag ;
    }
    /**
     * 获取 [送达方式]
     */
    public String getSdfs(){
        return this.sdfs ;
    }

    /**
     * 设置 [送达方式]
     */
    public void setSdfs(String  sdfs){
        this.sdfs = sdfs ;
        this.sdfsDirtyFlag = true ;
    }

    /**
     * 获取 [送达方式]脏标记
     */
    @JsonIgnore
    public boolean getSdfsDirtyFlag(){
        return this.sdfsDirtyFlag ;
    }
    /**
     * 获取 [跨公司部门人员清单]
     */
    public String getKgsbmids(){
        return this.kgsbmids ;
    }

    /**
     * 设置 [跨公司部门人员清单]
     */
    public void setKgsbmids(String  kgsbmids){
        this.kgsbmids = kgsbmids ;
        this.kgsbmidsDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司部门人员清单]脏标记
     */
    @JsonIgnore
    public boolean getKgsbmidsDirtyFlag(){
        return this.kgsbmidsDirtyFlag ;
    }
    /**
     * 获取 [上级部门]
     */
    public Integer getSjbm(){
        return this.sjbm ;
    }

    /**
     * 设置 [上级部门]
     */
    public void setSjbm(Integer  sjbm){
        this.sjbm = sjbm ;
        this.sjbmDirtyFlag = true ;
    }

    /**
     * 获取 [上级部门]脏标记
     */
    @JsonIgnore
    public boolean getSjbmDirtyFlag(){
        return this.sjbmDirtyFlag ;
    }
    /**
     * 获取 [其他通知阅读对象]
     */
    public String getQttzyddx(){
        return this.qttzyddx ;
    }

    /**
     * 设置 [其他通知阅读对象]
     */
    public void setQttzyddx(String  qttzyddx){
        this.qttzyddx = qttzyddx ;
        this.qttzyddxDirtyFlag = true ;
    }

    /**
     * 获取 [其他通知阅读对象]脏标记
     */
    @JsonIgnore
    public boolean getQttzyddxDirtyFlag(){
        return this.qttzyddxDirtyFlag ;
    }
    /**
     * 获取 [领导]
     */
    public String getLd(){
        return this.ld ;
    }

    /**
     * 设置 [领导]
     */
    public void setLd(String  ld){
        this.ld = ld ;
        this.ldDirtyFlag = true ;
    }

    /**
     * 获取 [领导]脏标记
     */
    @JsonIgnore
    public boolean getLdDirtyFlag(){
        return this.ldDirtyFlag ;
    }
    /**
     * 获取 [标题]
     */
    public String getIMName(){
        return this.iMName ;
    }

    /**
     * 设置 [标题]
     */
    public void setIMName(String  iMName){
        this.iMName = iMName ;
        this.iMNameDirtyFlag = true ;
    }

    /**
     * 获取 [标题]脏标记
     */
    @JsonIgnore
    public boolean getIMNameDirtyFlag(){
        return this.iMNameDirtyFlag ;
    }
    /**
     * 获取 [流程编号]
     */
    public String getLcbh(){
        return this.lcbh ;
    }

    /**
     * 设置 [流程编号]
     */
    public void setLcbh(String  lcbh){
        this.lcbh = lcbh ;
        this.lcbhDirtyFlag = true ;
    }

    /**
     * 获取 [流程编号]脏标记
     */
    @JsonIgnore
    public boolean getLcbhDirtyFlag(){
        return this.lcbhDirtyFlag ;
    }
    /**
     * 获取 [内部审核人员清单]
     */
    public String getNgshids(){
        return this.ngshids ;
    }

    /**
     * 设置 [内部审核人员清单]
     */
    public void setNgshids(String  ngshids){
        this.ngshids = ngshids ;
        this.ngshidsDirtyFlag = true ;
    }

    /**
     * 获取 [内部审核人员清单]脏标记
     */
    @JsonIgnore
    public boolean getNgshidsDirtyFlag(){
        return this.ngshidsDirtyFlag ;
    }
    /**
     * 获取 [跨公司领导]
     */
    public String getKgsld(){
        return this.kgsld ;
    }

    /**
     * 设置 [跨公司领导]
     */
    public void setKgsld(String  kgsld){
        this.kgsld = kgsld ;
        this.kgsldDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司领导]脏标记
     */
    @JsonIgnore
    public boolean getKgsldDirtyFlag(){
        return this.kgsldDirtyFlag ;
    }
    /**
     * 获取 [审核方式]
     */
    public String getShfs(){
        return this.shfs ;
    }

    /**
     * 设置 [审核方式]
     */
    public void setShfs(String  shfs){
        this.shfs = shfs ;
        this.shfsDirtyFlag = true ;
    }

    /**
     * 获取 [审核方式]脏标记
     */
    @JsonIgnore
    public boolean getShfsDirtyFlag(){
        return this.shfsDirtyFlag ;
    }
    /**
     * 获取 [更新时间]
     */
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }
    /**
     * 获取 [重要事项标识]
     */
    public String getIMId(){
        return this.iMId ;
    }

    /**
     * 设置 [重要事项标识]
     */
    public void setIMId(String  iMId){
        this.iMId = iMId ;
        this.iMIdDirtyFlag = true ;
    }

    /**
     * 获取 [重要事项标识]脏标记
     */
    @JsonIgnore
    public boolean getIMIdDirtyFlag(){
        return this.iMIdDirtyFlag ;
    }
    /**
     * 获取 [申报类型]
     */
    public String getSblx(){
        return this.sblx ;
    }

    /**
     * 设置 [申报类型]
     */
    public void setSblx(String  sblx){
        this.sblx = sblx ;
        this.sblxDirtyFlag = true ;
    }

    /**
     * 获取 [申报类型]脏标记
     */
    @JsonIgnore
    public boolean getSblxDirtyFlag(){
        return this.sblxDirtyFlag ;
    }
    /**
     * 获取 [通知阅读]
     */
    public Integer getTzyd(){
        return this.tzyd ;
    }

    /**
     * 设置 [通知阅读]
     */
    public void setTzyd(Integer  tzyd){
        this.tzyd = tzyd ;
        this.tzydDirtyFlag = true ;
    }

    /**
     * 获取 [通知阅读]脏标记
     */
    @JsonIgnore
    public boolean getTzydDirtyFlag(){
        return this.tzydDirtyFlag ;
    }
    /**
     * 获取 [流程实例]
     */
    public String getWfinstanceid(){
        return this.wfinstanceid ;
    }

    /**
     * 设置 [流程实例]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [流程实例]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return this.wfinstanceidDirtyFlag ;
    }
    /**
     * 获取 [部门领导]
     */
    public String getBmld(){
        return this.bmld ;
    }

    /**
     * 设置 [部门领导]
     */
    public void setBmld(String  bmld){
        this.bmld = bmld ;
        this.bmldDirtyFlag = true ;
    }

    /**
     * 获取 [部门领导]脏标记
     */
    @JsonIgnore
    public boolean getBmldDirtyFlag(){
        return this.bmldDirtyFlag ;
    }
    /**
     * 获取 [通知阅读原因]
     */
    public String getTzydyy(){
        return this.tzydyy ;
    }

    /**
     * 设置 [通知阅读原因]
     */
    public void setTzydyy(String  tzydyy){
        this.tzydyy = tzydyy ;
        this.tzydyyDirtyFlag = true ;
    }

    /**
     * 获取 [通知阅读原因]脏标记
     */
    @JsonIgnore
    public boolean getTzydyyDirtyFlag(){
        return this.tzydyyDirtyFlag ;
    }
    /**
     * 获取 [工作流状态]
     */
    public String getImwfstate(){
        return this.imwfstate ;
    }

    /**
     * 设置 [工作流状态]
     */
    public void setImwfstate(String  imwfstate){
        this.imwfstate = imwfstate ;
        this.imwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [工作流状态]脏标记
     */
    @JsonIgnore
    public boolean getImwfstateDirtyFlag(){
        return this.imwfstateDirtyFlag ;
    }
    /**
     * 获取 [建立人]
     */
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }
    /**
     * 获取 [阅知对象]
     */
    public String getYzdx(){
        return this.yzdx ;
    }

    /**
     * 设置 [阅知对象]
     */
    public void setYzdx(String  yzdx){
        this.yzdx = yzdx ;
        this.yzdxDirtyFlag = true ;
    }

    /**
     * 获取 [阅知对象]脏标记
     */
    @JsonIgnore
    public boolean getYzdxDirtyFlag(){
        return this.yzdxDirtyFlag ;
    }
    /**
     * 获取 [内部审核]
     */
    public String getNgsh(){
        return this.ngsh ;
    }

    /**
     * 设置 [内部审核]
     */
    public void setNgsh(String  ngsh){
        this.ngsh = ngsh ;
        this.ngshDirtyFlag = true ;
    }

    /**
     * 获取 [内部审核]脏标记
     */
    @JsonIgnore
    public boolean getNgshDirtyFlag(){
        return this.ngshDirtyFlag ;
    }
    /**
     * 获取 [缓急程度]
     */
    public String getHjcd(){
        return this.hjcd ;
    }

    /**
     * 设置 [缓急程度]
     */
    public void setHjcd(String  hjcd){
        this.hjcd = hjcd ;
        this.hjcdDirtyFlag = true ;
    }

    /**
     * 获取 [缓急程度]脏标记
     */
    @JsonIgnore
    public boolean getHjcdDirtyFlag(){
        return this.hjcdDirtyFlag ;
    }
    /**
     * 获取 [更新人]
     */
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }
    /**
     * 获取 [领导人员清单]
     */
    public String getLdids(){
        return this.ldids ;
    }

    /**
     * 设置 [领导人员清单]
     */
    public void setLdids(String  ldids){
        this.ldids = ldids ;
        this.ldidsDirtyFlag = true ;
    }

    /**
     * 获取 [领导人员清单]脏标记
     */
    @JsonIgnore
    public boolean getLdidsDirtyFlag(){
        return this.ldidsDirtyFlag ;
    }
    /**
     * 获取 [会签部门人员清单]
     */
    public String getHqbmids(){
        return this.hqbmids ;
    }

    /**
     * 设置 [会签部门人员清单]
     */
    public void setHqbmids(String  hqbmids){
        this.hqbmids = hqbmids ;
        this.hqbmidsDirtyFlag = true ;
    }

    /**
     * 获取 [会签部门人员清单]脏标记
     */
    @JsonIgnore
    public boolean getHqbmidsDirtyFlag(){
        return this.hqbmidsDirtyFlag ;
    }
    /**
     * 获取 [跨公司部门]
     */
    public String getKgsbm(){
        return this.kgsbm ;
    }

    /**
     * 设置 [跨公司部门]
     */
    public void setKgsbm(String  kgsbm){
        this.kgsbm = kgsbm ;
        this.kgsbmDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司部门]脏标记
     */
    @JsonIgnore
    public boolean getKgsbmDirtyFlag(){
        return this.kgsbmDirtyFlag ;
    }
    /**
     * 获取 [重要事项审批步骤]
     */
    public String getWfstep(){
        return this.wfstep ;
    }

    /**
     * 设置 [重要事项审批步骤]
     */
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [重要事项审批步骤]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return this.wfstepDirtyFlag ;
    }
    /**
     * 获取 [主办部门]
     */
    public String getZbbm(){
        return this.zbbm ;
    }

    /**
     * 设置 [主办部门]
     */
    public void setZbbm(String  zbbm){
        this.zbbm = zbbm ;
        this.zbbmDirtyFlag = true ;
    }

    /**
     * 获取 [主办部门]脏标记
     */
    @JsonIgnore
    public boolean getZbbmDirtyFlag(){
        return this.zbbmDirtyFlag ;
    }
    /**
     * 获取 [拟稿日期]
     */
    public Timestamp getNgrq(){
        return this.ngrq ;
    }

    /**
     * 设置 [拟稿日期]
     */
    public void setNgrq(Timestamp  ngrq){
        this.ngrq = ngrq ;
        this.ngrqDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿日期]脏标记
     */
    @JsonIgnore
    public boolean getNgrqDirtyFlag(){
        return this.ngrqDirtyFlag ;
    }
    /**
     * 获取 [拟稿人联系方式]
     */
    public String getNgrlxfs(){
        return this.ngrlxfs ;
    }

    /**
     * 设置 [拟稿人联系方式]
     */
    public void setNgrlxfs(String  ngrlxfs){
        this.ngrlxfs = ngrlxfs ;
        this.ngrlxfsDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人联系方式]脏标记
     */
    @JsonIgnore
    public boolean getNgrlxfsDirtyFlag(){
        return this.ngrlxfsDirtyFlag ;
    }
    /**
     * 获取 [拟稿人所在机构]
     */
    public String getNgrjg(){
        return this.ngrjg ;
    }

    /**
     * 设置 [拟稿人所在机构]
     */
    public void setNgrjg(String  ngrjg){
        this.ngrjg = ngrjg ;
        this.ngrjgDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人所在机构]脏标记
     */
    @JsonIgnore
    public boolean getNgrjgDirtyFlag(){
        return this.ngrjgDirtyFlag ;
    }
    /**
     * 获取 [拟稿人所在部门]
     */
    public String getNgrbmname(){
        return this.ngrbmname ;
    }

    /**
     * 设置 [拟稿人所在部门]
     */
    public void setNgrbmname(String  ngrbmname){
        this.ngrbmname = ngrbmname ;
        this.ngrbmnameDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人所在部门]脏标记
     */
    @JsonIgnore
    public boolean getNgrbmnameDirtyFlag(){
        return this.ngrbmnameDirtyFlag ;
    }
    /**
     * 获取 [拟稿人]
     */
    public String getNgrname(){
        return this.ngrname ;
    }

    /**
     * 设置 [拟稿人]
     */
    public void setNgrname(String  ngrname){
        this.ngrname = ngrname ;
        this.ngrnameDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人]脏标记
     */
    @JsonIgnore
    public boolean getNgrnameDirtyFlag(){
        return this.ngrnameDirtyFlag ;
    }
    /**
     * 获取 [组织用户标识]
     */
    public String getNgrid(){
        return this.ngrid ;
    }

    /**
     * 设置 [组织用户标识]
     */
    public void setNgrid(String  ngrid){
        this.ngrid = ngrid ;
        this.ngridDirtyFlag = true ;
    }

    /**
     * 获取 [组织用户标识]脏标记
     */
    @JsonIgnore
    public boolean getNgridDirtyFlag(){
        return this.ngridDirtyFlag ;
    }
    /**
     * 获取 [部门标识]
     */
    public String getNgrbmid(){
        return this.ngrbmid ;
    }

    /**
     * 设置 [部门标识]
     */
    public void setNgrbmid(String  ngrbmid){
        this.ngrbmid = ngrbmid ;
        this.ngrbmidDirtyFlag = true ;
    }

    /**
     * 获取 [部门标识]脏标记
     */
    @JsonIgnore
    public boolean getNgrbmidDirtyFlag(){
        return this.ngrbmidDirtyFlag ;
    }
    /**
     * 获取 [PSID]
     */
    public String getPsid(){
        return this.psid ;
    }

    /**
     * 设置 [PSID]
     */
    public void setPsid(String  psid){
        this.psid = psid ;
        this.psidDirtyFlag = true ;
    }

    /**
     * 获取 [PSID]脏标记
     */
    @JsonIgnore
    public boolean getPsidDirtyFlag(){
        return this.psidDirtyFlag ;
    }
}