package com.ibiz.web.ht.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.web.ht.service.IMService;
import com.ibiz.web.ht.domain.IM;
import com.ibiz.web.ht.filter.*;

@RestController
@RequestMapping(value = "")
public class IMController {
	@Autowired
    IMService imservice;


	@RequestMapping(method = RequestMethod.PUT, value = "/ims/{im_id}")
    @PreAuthorize("@im_pms.check(#im_id,'UPDATE')")
    public ResponseEntity<IM> update(@PathVariable("im_id") String im_id, @RequestBody IM im) {
        IM im2 = imservice.update(im_id, im);
        return ResponseEntity.status(HttpStatus.OK).body(im2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/ims/{im_id}")
    @PreAuthorize("@im_pms.check(#im_id,'UPDATE')")
    public ResponseEntity<IM> api_update(@PathVariable("im_id") String im_id, @RequestBody IM im) {
        IM im2 = imservice.update(im_id, im);
        return ResponseEntity.status(HttpStatus.OK).body(im2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ims/{im_id}/hd")
    @PreAuthorize("@im_pms.check(#im_id,'')")
    public ResponseEntity<IM> hD(@PathVariable("im_id") String im_id, @RequestBody IM im) {
        IM im2 = imservice.hD(im_id, im);
        return ResponseEntity.status(HttpStatus.OK).body(im2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/ims/getdraft")
    @PreAuthorize("@im_pms.check('CREATE')")
    public ResponseEntity<IM> getDraft() {
        //IM im = imservice.getDraft( im_id);
        return ResponseEntity.status(HttpStatus.OK).body(new IM());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ims")
    @PreAuthorize("@im_pms.check('CREATE')")
    public ResponseEntity<IM> create(@RequestBody IM im) {
        IM im2 = imservice.create(im);
        return ResponseEntity.status(HttpStatus.OK).body(im2);
    }

	@RequestMapping(method = RequestMethod.DELETE, value = "/ims/{im_id}")
    @PreAuthorize("@im_pms.check(#im_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("im_id") String im_id) {
        boolean b = imservice.remove( im_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ims/{im_id}/save")
    @PreAuthorize("@im_pms.check(#im_id,'')")
    public ResponseEntity<IM> save(@PathVariable("im_id") String im_id, @RequestBody IM im) {
        IM im2 = imservice.save(im_id, im);
        return ResponseEntity.status(HttpStatus.OK).body(im2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/ims/{im_id}")
    @PreAuthorize("@im_pms.check(#im_id,'READ')")
    public ResponseEntity<IM> get(@PathVariable("im_id") String im_id) {
        IM im = imservice.get( im_id);
        return ResponseEntity.status(HttpStatus.OK).body(im);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ims/checkkey")
    @PreAuthorize("@im_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody IM im) {
        boolean b = imservice.checkKey(im);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/ims/{im_id}/getmp")
    @PreAuthorize("@im_pms.check(#im_id,'READ')")
    public ResponseEntity<IM> getMP(@PathVariable("im_id") String im_id, @RequestBody IM im) {
        IM im2 = imservice.getMP(im_id, im);
        return ResponseEntity.status(HttpStatus.OK).body(im2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/ims/{im_id}/createandstart")
    @PreAuthorize("@im_pms.check(#im_id,'CREATE')")
    public ResponseEntity<IM> createAndStart(@PathVariable("im_id") String im_id, @RequestBody IM im) {
        IM im2 = imservice.createAndStart(im_id, im);
        return ResponseEntity.status(HttpStatus.OK).body(im2);
    }

    @RequestMapping(method= RequestMethod.GET , value="/ims/fetchdefault")
    @PreAuthorize("@im_pms.check('READ')")
	public ResponseEntity<List<IM>> fetchDefault(IMSearchContext searchContext,Pageable pageable) {
        
        Page<IM> page = imservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    @RequestMapping(method= RequestMethod.POST , value="/ims/{im_id}/wfstart")
	public ResponseEntity<JSONObject> wfStart(@PathVariable("im_id") String im_id) {
        return ResponseEntity.status(HttpStatus.OK).body(imservice.wfStart(im_id));
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    @RequestMapping(method = RequestMethod.POST, value = "api/ims/{im_id}/wfaction")
    public ResponseEntity<JSONObject> wfAction(@PathVariable("im_id") String im_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(imservice.wfAction(im_id, data));
    }

}
