package com.ibiz.web.ht.service;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.ibiz.web.ps.domain.PS;
import com.ibiz.web.ps.service.PSService;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.web.ht.domain.IM;
import com.ibiz.web.ht.filter.*;
import com.ibiz.web.ht.feign.IMFeignClient;
import com.ibiz.web.WebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.domain.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IMService {

    IMFeignClient client;
    @Autowired
    SysInfoProperties sysInfoProperties;

    UniWFClientProperties uniWFClientProperties;

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    PSService psService;

    @Autowired
    public IMService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties, UniWFClientProperties uniWFClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(IMFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(IMFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
        this.uniWFClientProperties = uniWFClientProperties;
		if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    public IM update(String im_id, IM im) {
        return client.update(im_id, im);
    }

    public IM hD(String im_id, IM im) {
        return client.hD(im_id, im);
    }

    public IM getDraft(String im_id, IM im) {
        return client.getDraft(im_id, im);
    }

	public IM create(IM im) {
        return client.create(im);
    }

    public boolean remove( String im_id) {
        return client.remove( im_id);
    }

    public IM save(String im_id, IM im) {
        return client.save(im_id, im);
    }

    public IM get( String im_id) {
        return client.get( im_id);
    }

    public boolean checkKey(IM im) {
        return client.checkKey(im);
    }

    public IM getMP(String im_id, IM im) {
        return client.getMP(im_id, im);
    }

    public IM createAndStart(String im_id, IM im) {
        return client.createAndStart(im_id, im);
    }

	public Page<IM> fetchDefault(IMSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

	public JSONObject wfStart(String im_id) {
	    PSDataEntity psdataentity = new PSDataEntity();
        psdataentity.setPsdataentityid("6ebc01c300b54d50486ccff26162752b");
        psdataentity.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity.setPssystemid(sysInfoProperties.getSystemid());
        String uniwfUrl = "http://localhost:8111/";
        if (uniWFClientProperties.getAppUrl() != null && !uniWFClientProperties.getAppUrl().isEmpty()) {
            uniwfUrl = uniWFClientProperties.getAppUrl();
        }
    	JSONObject json = new JSONObject();
    	json.put("url", uniwfUrl
                        + "#/selectindexview/null/pswfversions/null/dataview?customParams=dataentityid:"
                        + psdataentity.getPsdataentityid() + ","
                        + "proxydataid:" + im_id + ","
                        + "proxymoduleid:IM"
    			);

        return json;
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    public JSONObject wfAction(String im_id, JSONObject data) {
        if (data == null
            || data.getString("type") == null
            || data.getString("wfinstanceid") == null) {
            System.err.println("传入参数缺失");
            data.put("rst", "0");
            data.put("msg", "传入参数缺失");
            return data;
        }
        String type = data.getString("type");
        String wfinstanceid = data.getString("wfinstanceid");
        String wfstep = data.getString("wfstep");

        // 业务实体
        IM im = this.get(im_id);

        WFInstance wfinstance = this.uniWFFeignClient.getWFInstance(wfinstanceid);
        if (wfinstance == null) {
            System.err.println("查询不到流程实例");
            data.put("rst", "0");
            data.put("msg", "查询不到流程实例");
            return data;
        }
        JSONObject psdewfCond = new JSONObject();
        psdewfCond.put("n_psworkflowid_eq", wfinstance.getPsworkflowid());
        psdewfCond.put("n_psdataentityid_eq", "6ebc01c300b54d50486ccff26162752b");
        Page<PSDEWF> psdewfs = this.uniWFFeignClient.getPSDEWFByCondition(psdewfCond);
        if (psdewfs == null || psdewfs.getContent().size() == 0) {
            data.put("rst", "0");
            data.put("msg", "未查到流程实体");
            return data;
        }
        PSDEWF psdewf = psdewfs.getContent().get(0);

         // 业务状态
        String status = null;
        if ("start".equals(type)) {
            status = psdewf.getProcessvalue();
        } else if ("gotostep".equals(type)) {
            status = psdewf.getProcessvalue();
        } else if ("finish".equals(type)) {
            status = psdewf.getFinishvalue();
        } else if ("cancel".equals(type)) {

        } else if ("error".equals(type)) {
            status = psdewf.getErrorvalue();
        }

        // 保存当前数据
        if (status != null && !status.isEmpty()) {
            im.setImwfstate(status);
        }
        if (wfstep != null && !wfstep.isEmpty()) {
        }

        // 保存业务数据
        this.update(im_id, im);

        // FOR TEST ADD gotostep
        if ("finish".equals(type) || "gotostep".equals(type)) {
            // PS
            PS ps = new PS();
            ps.setPSId(im.getIMId());
            ps = psService.get(ps.getPSId());
            if (ps != null) {
                ps.setImstate("30");
//                psService.update(ps.getPSId(), ps);
            }
            if (data.getString("callbackdata") != null) {
                JSONArray callbackdata = JSONObject.parseArray(data.getString("callbackdata"));
                if (callbackdata.size() > 0) {
                    for (int i =0; i < callbackdata.size(); i++) {
                        JSONObject jo = callbackdata.getJSONObject(i);
                        HttpMethod httpMethod = HttpMethod.valueOf(jo.getString("method"));
                        String url = jo.getString("url");
                        JSONObject params = null;
                        if (jo.getBoolean("containspk")) {
                            String replaceStr = url.substring(url.indexOf("{"), url.indexOf("}") + 1);
                            replaceStr = "\\" + replaceStr;
                            replaceStr = replaceStr.substring(0, replaceStr.length() - 1) + "\\}";
                            url = url.replaceAll(replaceStr, im.getIMId());
                        }
                        if (jo.getBoolean("containset")) {
                            params = (JSONObject) JSONObject.toJSON(ps);
                        }
                        doRestRequest(url, httpMethod, getHeader(), params);
                    }
                }
            }
        }

        data.put("rst", "1");
        return data;
    }

    public JSONObject getHeader(){
        JSONObject header = new JSONObject();
        header.put("Content-Type","application/json");
//        String token= null;
//        try {
//            Base64 base64 = new Base64();
//            token = base64.encodeToString((username+":"+password).getBytes("UTF-8"));
//        } catch (UnsupportedEncodingException e) {
//            e.printStackTrace();
//        }
//        header.put("Authorization","Basic "+ token);
        return header;
    }

    private String doRestRequest(String url, HttpMethod method, JSONObject headerMap, JSONObject paramMap){
        RestTemplate restTemplate = getRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        if(headerMap!=null){
            for(String key : headerMap.keySet()){
                headers.add(key,headerMap.getString(key));
            }
        }
        MultiValueMap<String,String> params = new LinkedMultiValueMap<String,String>();
        HttpEntity<String> entity;
        if(paramMap!=null){
            entity = new HttpEntity<>(paramMap.toString(), headers);
        }else{
            entity = new HttpEntity<>(null, headers);
        }
        ResponseEntity<String> responseEntity = restTemplate.exchange(url, method, entity, String.class);
        return responseEntity.getBody();
    }

    private RestTemplate getRestTemplate(){
        RestTemplate restTemplate = new RestTemplate();
        for (HttpMessageConverter<?> httpMessageConverter : restTemplate.getMessageConverters()) {
            if (httpMessageConverter instanceof StringHttpMessageConverter) {
                ((StringHttpMessageConverter) httpMessageConverter).setDefaultCharset(Charset.forName("UTF-8"));
                break;
            }
        }
        return restTemplate;
    }
}
