package com.ibiz.web.job;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.core.io.ClassPathResource;
import com.alibaba.fastjson.JSONObject;

import java.io.InputStream;
import java.util.List;
import java.util.ArrayList;

import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.domain.*;

/**
 *
 */
@Component
public class WFAppJob implements ApplicationRunner {

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    SysInfoProperties sysInfoProperties;

    @Autowired
    public WFAppJob(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor, UniWFClientProperties uniWFClientProperties) {
        if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        /* ---------- 工作流应用注册内容 ---------- */

        // 注册业务应用
        registPSSysApp();

    }

    /**
     * 注册业务应用
     */
    private void registPSSysApp() {
        PSSysApp pssysapp = new PSSysApp();
        pssysapp.setPssysappid(sysInfoProperties.getAppid());
        pssysapp.setPssysappname(sysInfoProperties.getAppname());
        pssysapp.setPssystemid(sysInfoProperties.getSystemid());
        pssysapp.setWorkflowid(sysInfoProperties.getDomainid());
        pssysapp.setServiceid(sysInfoProperties.getServiceid());
        pssysapp.setServiceurl(sysInfoProperties.getServiceurl());
        pssysapp.setAppurl(sysInfoProperties.getAppurl());
        pssysapp.setProxyviewurl(sysInfoProperties.getProxyviewurl());
        pssysapp.setLogicname(sysInfoProperties.getApplogicname());
        uniWFFeignClient.registPSSysApp(pssysapp);
    }
}
