
package com.ibiz.wfweb.r7rt_org.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb.r7rt_org.domain.OrgDeptUser;
import com.ibiz.wfweb.r7rt_org.filter.*;
import com.ibiz.wfweb.r7rt_org.feign.OrgDeptUserFeignClient;
import com.ibiz.wfweb.WFWebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;

@Service
public class OrgDeptUserService {

    OrgDeptUserFeignClient client;

    @Autowired
    public OrgDeptUserService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgDeptUserFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgDeptUserFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public OrgDeptUser getDraft(String orgdeptuser_id, OrgDeptUser orgdeptuser) {
        return client.getDraft(orgdeptuser_id, orgdeptuser);
    }

    public OrgDeptUser get( String orgdeptuser_id) {
        return client.get( orgdeptuser_id);
    }

    public OrgDeptUser save(String orgdeptuser_id, OrgDeptUser orgdeptuser) {
        return client.save(orgdeptuser_id, orgdeptuser);
    }

	public OrgDeptUser create(OrgDeptUser orgdeptuser) {
        return client.create(orgdeptuser);
    }

    public boolean remove( String orgdeptuser_id) {
        return client.remove( orgdeptuser_id);
    }

    public OrgDeptUser update(String orgdeptuser_id, OrgDeptUser orgdeptuser) {
        return client.update(orgdeptuser_id, orgdeptuser);
    }

    public boolean checkKey(OrgDeptUser orgdeptuser) {
        return client.checkKey(orgdeptuser);
    }

	public Page<OrgDeptUser> fetchGetorgdeptuser(OrgDeptUserSearchContext searchContext) {
        return client.fetchGetorgdeptuser(searchContext);
    }

	public Page<OrgDeptUser> fetchDefault(OrgDeptUserSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
