
package com.ibiz.wfweb2.htwf.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb2.htwf.domain.WFIM;
import com.ibiz.wfweb2.htwf.filter.*;
import com.ibiz.wfweb2.htwf.feign.WFIMFeignClient;
import com.ibiz.wfweb2.WFWeb2Application.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;

@Service
public class WFIMService {

    WFIMFeignClient client;

    @Autowired
    public WFIMService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFIMFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFIMFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public boolean remove( String wfim_id) {
        return client.remove( wfim_id);
    }

    public WFIM update(String wfim_id, WFIM wfim) {
        return client.update(wfim_id, wfim);
    }

    public WFIM getDraft(String wfim_id, WFIM wfim) {
        return client.getDraft(wfim_id, wfim);
    }

    public WFIM save(String wfim_id, WFIM wfim) {
        return client.save(wfim_id, wfim);
    }

	public WFIM create(WFIM wfim) {
        return client.create(wfim);
    }

    public WFIM get( String wfim_id) {
        return client.get( wfim_id);
    }

    public boolean checkKey(WFIM wfim) {
        return client.checkKey(wfim);
    }

	public Page<WFIM> fetchDefault(WFIMSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
