package com.ibiz.client.wf.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.ibiz.core.client.model.IWFIAAction;
import com.ibiz.client.wf.config.WFClientProperties;
import com.ibiz.core.client.service.IWFIAActionClientService;
import com.ibiz.client.wf.model.WFIAActionImpl;
import com.ibiz.client.wf.feign.WFIAActionFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[WFIAAction] 服务对象接口
 */
@Service
public class WFIAActionClientServiceImpl implements IWFIAActionClientService {

    WFIAActionFeignClient wFIAActionFeignClient;

    @Autowired
    public WFIAActionClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,WFClientProperties wfClientProperties) {
        if (wfClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.wFIAActionFeignClient = nameBuilder.target(WFIAActionFeignClient.class,"http://"+wfClientProperties.getServiceId()+"/") ;
		}else if (wfClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.wFIAActionFeignClient = nameBuilder.target(WFIAActionFeignClient.class,wfClientProperties.getServiceUrl()) ;
		}
    }
    @Override
    public IWFIAAction createModel() {
		return new WFIAActionImpl();
	}


    public Page<IWFIAAction> select(SearchContext context){
        return null ;
    }


    public void remove(IWFIAAction wfiaaction){
        wFIAActionFeignClient.remove(wfiaaction.getWFIAActionId()) ;
    }


    public void update(IWFIAAction wfiaaction){
        IWFIAAction clientModel = wFIAActionFeignClient.update(wfiaaction.getWFIAActionId(),(WFIAActionImpl)wfiaaction) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfiaaction.getClass(), false);
        copier.copy(clientModel, wfiaaction, null);
    }


    public void save(IWFIAAction wfiaaction){
        IWFIAAction clientModel = wFIAActionFeignClient.save(wfiaaction.getWFIAActionId(),(WFIAActionImpl)wfiaaction) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfiaaction.getClass(), false);
        copier.copy(clientModel, wfiaaction, null);
    }


    public void get(IWFIAAction wfiaaction){
        IWFIAAction clientModel = wFIAActionFeignClient.get(wfiaaction.getWFIAActionId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfiaaction.getClass(), false);
        copier.copy(clientModel, wfiaaction, null);
    }


    public void checkKey(IWFIAAction wfiaaction){
        IWFIAAction clientModel = wFIAActionFeignClient.checkKey(wfiaaction.getWFIAActionId(),(WFIAActionImpl)wfiaaction) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfiaaction.getClass(), false);
        copier.copy(clientModel, wfiaaction, null);
    }


    public void getDraft(IWFIAAction wfiaaction){
        IWFIAAction clientModel = wFIAActionFeignClient.getDraft(wfiaaction.getWFIAActionId(),(WFIAActionImpl)wfiaaction) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfiaaction.getClass(), false);
        copier.copy(clientModel, wfiaaction, null);
    }


    public void create(IWFIAAction wfiaaction){
        IWFIAAction clientModel = wFIAActionFeignClient.create((WFIAActionImpl)wfiaaction) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), wfiaaction.getClass(), false);
        copier.copy(clientModel, wfiaaction, null);
    }


    public Page<IWFIAAction> fetchDefault(SearchContext context){
        Page<WFIAActionImpl> page = this.wFIAActionFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }



}

