package com.ibiz.client.ps.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.ibiz.core.client.model.IPS;
import com.ibiz.client.ps.model.PSImpl;
import com.ibiz.util.SearchContext;
/**
 * 实体[PS] 服务对象接口
 */
public interface PSFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/web/ps/select")
    public Page<PSImpl> select();


    @RequestMapping(method = RequestMethod.GET, value = "/web/ps/{psid}")
    public PSImpl get(@PathVariable("psid") String psid);


    @RequestMapping(method = RequestMethod.PUT, value = "/web/ps/{psid}")
    public PSImpl update(@PathVariable("psid") String psid,@RequestBody PSImpl ps);


    @RequestMapping(method = RequestMethod.POST, value = "/web/ps")
    public PSImpl create(@RequestBody PSImpl ps);


    @RequestMapping(method = RequestMethod.POST, value = "/web/ps/{psid}/save")
    public PSImpl save(@PathVariable("psid") String psid,@RequestBody PSImpl ps);


    @RequestMapping(method = RequestMethod.GET, value = "/web/ps/{psid}/getdraft")
    public PSImpl getDraft(@PathVariable("psid") String psid,@RequestBody PSImpl ps);


    @RequestMapping(method = RequestMethod.POST, value = "/web/ps/{psid}/checkkey")
    public PSImpl checkKey(@PathVariable("psid") String psid,@RequestBody PSImpl ps);


    @RequestMapping(method = RequestMethod.DELETE, value = "/web/ps/{psid}")
    public Boolean remove(@PathVariable("psid") String psid);


    @RequestMapping(method = RequestMethod.GET, value = "/web/ps/fetchdefault")
    public Page<PSImpl> fetchDefault(SearchContext context);



}
