package com.ibiz.wfweb.htwf.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb.htwf.domain.WFBM;
import com.ibiz.wfweb.htwf.filter.*;


public interface WFBMFeignClient {



	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfbms/{wfbm_id}")
    public Boolean remove(@PathVariable("wfbm_id") String wfbm_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbms/checkkey")
    public Boolean checkKey(@RequestBody WFBM wfbm) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbms/{wfbm_id}/getdraft")
    public WFBM getDraft(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBM wfbm) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbms")
    public WFBM create(@RequestBody WFBM wfbm) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfbms/{wfbm_id}")
    public WFBM update(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBM wfbm) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbms/{wfbm_id}")
    public WFBM get(@PathVariable("wfbm_id") String wfbm_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbms/{wfbm_id}/save")
    public WFBM save(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBM wfbm) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfbms/fetchdefault")
	public Page<WFBM> fetchDefault(WFBMSearchContext searchContext) ;
}
