package com.ibiz.web.ht.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.web.ht.service.FJService;
import com.ibiz.web.ht.domain.FJ;
import com.ibiz.web.ht.filter.*;

@RestController
@RequestMapping(value = "")
public class FJController {
	@Autowired
    FJService fjservice;


	@RequestMapping(method = RequestMethod.POST, value = "/fjs/{fj_id}/save")
    @PreAuthorize("@fj_pms.check(#fj_id,'')")
    public ResponseEntity<FJ> save(@PathVariable("fj_id") String fj_id, @RequestBody FJ fj) {
        FJ fj2 = fjservice.save(fj_id, fj);
        return ResponseEntity.status(HttpStatus.OK).body(fj2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/fjs")
    @PreAuthorize("@fj_pms.check('CREATE')")
    public ResponseEntity<FJ> create(@RequestBody FJ fj) {
        FJ fj2 = fjservice.create(fj);
        return ResponseEntity.status(HttpStatus.OK).body(fj2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/fjs/{fj_id}")
    @PreAuthorize("@fj_pms.check(#fj_id,'UPDATE')")
    public ResponseEntity<FJ> update(@PathVariable("fj_id") String fj_id, @RequestBody FJ fj) {
        FJ fj2 = fjservice.update(fj_id, fj);
        return ResponseEntity.status(HttpStatus.OK).body(fj2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/fjs/{fj_id}")
    @PreAuthorize("@fj_pms.check(#fj_id,'UPDATE')")
    public ResponseEntity<FJ> api_update(@PathVariable("fj_id") String fj_id, @RequestBody FJ fj) {
        FJ fj2 = fjservice.update(fj_id, fj);
        return ResponseEntity.status(HttpStatus.OK).body(fj2);
    }

	@RequestMapping(method = RequestMethod.DELETE, value = "/fjs/{fj_id}")
    @PreAuthorize("@fj_pms.check(#fj_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("fj_id") String fj_id) {
        boolean b = fjservice.remove( fj_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/fjs/{fj_id}")
    @PreAuthorize("@fj_pms.check(#fj_id,'READ')")
    public ResponseEntity<FJ> get(@PathVariable("fj_id") String fj_id) {
        FJ fj = fjservice.get( fj_id);
        return ResponseEntity.status(HttpStatus.OK).body(fj);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/fjs/getdraft")
    @PreAuthorize("@fj_pms.check('CREATE')")
    public ResponseEntity<FJ> getDraft() {
        //FJ fj = fjservice.getDraft( fj_id);
        return ResponseEntity.status(HttpStatus.OK).body(new FJ());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/fjs/checkkey")
    @PreAuthorize("@fj_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody FJ fj) {
        boolean b = fjservice.checkKey(fj);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @RequestMapping(method= RequestMethod.GET , value="/fjs/fetchcurfj")
    @PreAuthorize("@fj_pms.check('READ')")
	public ResponseEntity<List<FJ>> fetchCurFJ(FJSearchContext searchContext,Pageable pageable) {
        
        Page<FJ> page = fjservice.fetchCurFJ(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    @RequestMapping(method= RequestMethod.GET , value="/fjs/fetchdefault")
    @PreAuthorize("@fj_pms.check('READ')")
	public ResponseEntity<List<FJ>> fetchDefault(FJSearchContext searchContext,Pageable pageable) {
        
        Page<FJ> page = fjservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


}
