package com.ibiz.web.r7rt_org.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.web.r7rt_org.domain.OrgDept;
import com.ibiz.web.r7rt_org.filter.*;


public interface OrgDeptFeignClient {



	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts/{orgdept_id}/save")
    public OrgDept save(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts/{orgdept_id}/synctousergroup")
    public OrgDept syncToUserGroup(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}/getorgdeptchild")
    public OrgDept getOrgDeptChild(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgdepts/{orgdept_id}")
    public Boolean remove(@PathVariable("orgdept_id") String orgdept_id) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}")
    public OrgDept get(@PathVariable("orgdept_id") String orgdept_id) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgdepts/{orgdept_id}")
    public OrgDept update(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}/getdraft")
    public OrgDept getDraft(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts")
    public OrgDept create(@RequestBody OrgDept orgdept) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts/checkkey")
    public Boolean checkKey(@RequestBody OrgDept orgdept) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}/getorgdeptprent")
    public OrgDept getOrgDeptPrent(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDept orgdept) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/orgdepts/fetchdefault")
	public Page<OrgDept> fetchDefault(OrgDeptSearchContext searchContext) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/orgdepts/fetchcur_org")
	public Page<OrgDept> fetchCUR_ORG(OrgDeptSearchContext searchContext) ;
}
