package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.OrgDeptDTO;
import com.ibiz.core.r7rt_org.domain.OrgDept;
import com.ibiz.core.r7rt_org.service.IOrgDeptService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.r7rt_org.filter.OrgDeptSearchContext;

@Api(tags = {"OrgDept" })
@RestController
@RequestMapping("")
public class OrgDeptResource {

    @Autowired
    private IOrgDeptService orgdeptService;

    public IOrgDeptService getOrgdeptService() {
        return this.orgdeptService;
    }

    @ApiOperation(value = "Save", tags = {"OrgDept" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts/{orgdept_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody OrgDeptDTO orgdeptdto) {
        OrgDept orgdept = orgdeptdto.toDO();
    	Boolean b = orgdeptService.save(orgdept) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "同步到用户组", tags = {"OrgDept" },  notes = "同步到用户组")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts/{orgdept_id}/synctousergroup")

    public ResponseEntity<OrgDeptDTO> syncToUserGroup(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDeptDTO orgdeptdto) {
        OrgDept orgdept = orgdeptdto.toDO();
    	orgdept = orgdeptService.syncToUserGroup(orgdept) ;
    	orgdeptdto.fromDO(orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptdto);
    }

    @ApiOperation(value = "getorgdeptchild", tags = {"OrgDept" },  notes = "getorgdeptchild")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}/getorgdeptchild")

    public ResponseEntity<OrgDeptDTO> getOrgDeptChild(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDeptDTO orgdeptdto) {
        OrgDept orgdept = orgdeptdto.toDO();
    	orgdept = orgdeptService.getOrgDeptChild(orgdept) ;
    	orgdeptdto.fromDO(orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptdto);
    }

    @ApiOperation(value = "Remove", tags = {"OrgDept" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgdepts/{orgdept_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("orgdept_id") String orgdept_id) {
        OrgDeptDTO orgdeptdto = new OrgDeptDTO();
		OrgDept domain = new OrgDept();
		orgdeptdto.setOrgDeptId(orgdept_id);
		domain.setOrgDeptId(orgdept_id);
        Boolean rst = orgdeptService.remove(domain.getOrgDeptId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Get", tags = {"OrgDept" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}")
    public ResponseEntity<OrgDeptDTO> get(@PathVariable("orgdept_id") String orgdept_id) {
        OrgDeptDTO dto = new OrgDeptDTO();
        OrgDept domain = orgdeptService.get(orgdept_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Update", tags = {"OrgDept" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgdepts/{orgdept_id}")

    public ResponseEntity<OrgDeptDTO> update(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDeptDTO orgdeptdto) {
		OrgDept domain = orgdeptdto.toDO();
        domain.setOrgDeptId(orgdept_id);
		orgdeptService.update(domain);
		OrgDeptDTO dto = new OrgDeptDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"OrgDept" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}/getdraft")

    public ResponseEntity<OrgDeptDTO> getDraft(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDeptDTO orgdeptdto) {
        OrgDept orgdept = orgdeptdto.toDO();
    	orgdept = orgdeptService.getDraft(orgdept) ;
    	orgdeptdto.fromDO(orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptdto);
    }

    @ApiOperation(value = "Create", tags = {"OrgDept" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts")

    public ResponseEntity<OrgDeptDTO> create(@RequestBody OrgDeptDTO orgdeptdto) {
        OrgDeptDTO dto = new OrgDeptDTO();
        OrgDept domain = orgdeptdto.toDO();
		orgdeptService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"OrgDept" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdepts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody OrgDeptDTO orgdeptdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "getorgdeptprent", tags = {"OrgDept" },  notes = "getorgdeptprent")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdepts/{orgdept_id}/getorgdeptprent")

    public ResponseEntity<OrgDeptDTO> getOrgDeptPrent(@PathVariable("orgdept_id") String orgdept_id, @RequestBody OrgDeptDTO orgdeptdto) {
        OrgDept orgdept = orgdeptdto.toDO();
    	orgdept = orgdeptService.getOrgDeptPrent(orgdept) ;
    	orgdeptdto.fromDO(orgdept);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptdto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"OrgDept" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgdepts/fetchdefault")
	public ResponseEntity<Page<OrgDeptDTO>> fetchDefault(OrgDeptSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<OrgDeptDTO> list = new ArrayList<OrgDeptDTO>();
        
        Page<OrgDept> domains = orgdeptService.searchDefault(context) ;
        for(OrgDept orgdept : domains.getContent()){
            OrgDeptDTO dto = new OrgDeptDTO();
            dto.fromDO(orgdept);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取当前组织下的部门", tags = {"OrgDept" } ,notes = "获取当前组织下的部门")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgdepts/fetchcur_org")
	public ResponseEntity<Page<OrgDeptDTO>> fetchCUR_ORG(OrgDeptSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<OrgDeptDTO> list = new ArrayList<OrgDeptDTO>();
        
        Page<OrgDept> domains = orgdeptService.searchCUR_ORG(context) ;
        for(OrgDept orgdept : domains.getContent()){
            OrgDeptDTO dto = new OrgDeptDTO();
            dto.fromDO(orgdept);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
