package com.ibiz.wfweb.r7rt_wf.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[工作流步骤操作]
 */
public class WFIAAction implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 工作流步骤操作标识
     */
    private String wFIAActionId;

    @JsonIgnore
    private boolean wFIAActionIdDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 用户数据2
     */
    private String userData2;

    @JsonIgnore
    private boolean userData2DirtyFlag;
    
    /**
     * 审批意见
     */
    private String opinion;

    @JsonIgnore
    private boolean opinionDirtyFlag;
    
    /**
     * 操作类型
     */
    private String actionType;

    @JsonIgnore
    private boolean actionTypeDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * 处理人
     */
    private String personList;

    @JsonIgnore
    private boolean personListDirtyFlag;
    
    /**
     * 用户数据
     */
    private String userData;

    @JsonIgnore
    private boolean userDataDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 步骤
     */
    private String wFStepId;

    @JsonIgnore
    private boolean wFStepIdDirtyFlag;
    
    /**
     * 工作流步骤操作名称
     */
    private String wFIAActionName;

    @JsonIgnore
    private boolean wFIAActionNameDirtyFlag;
    
    /**
     * 操作人
     */
    private String opPerson;

    @JsonIgnore
    private boolean opPersonDirtyFlag;
    
    /**
     * 实例
     */
    private String wFInstanceId;

    @JsonIgnore
    private boolean wFInstanceIdDirtyFlag;
    

    /**
     * 获取 [工作流步骤操作标识]
     */
    @JsonProperty("wfiaactionid")
    public String getWFIAActionId(){
        return this.wFIAActionId ;
    }

    /**
     * 设置 [工作流步骤操作标识]
     */
    @JsonProperty("wfiaactionid")
    public void setWFIAActionId(String  wFIAActionId){
        this.wFIAActionId = wFIAActionId ;
        this.wFIAActionIdDirtyFlag = true ;
    }

    /**
     * 获取 [工作流步骤操作标识]脏标记
     */
    @JsonIgnore
    public boolean getWFIAActionIdDirtyFlag(){
        return this.wFIAActionIdDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [用户数据2]
     */
    @JsonProperty("userdata2")
    public String getUserData2(){
        return this.userData2 ;
    }

    /**
     * 设置 [用户数据2]
     */
    @JsonProperty("userdata2")
    public void setUserData2(String  userData2){
        this.userData2 = userData2 ;
        this.userData2DirtyFlag = true ;
    }

    /**
     * 获取 [用户数据2]脏标记
     */
    @JsonIgnore
    public boolean getUserData2DirtyFlag(){
        return this.userData2DirtyFlag ;
    }

    /**
     * 获取 [审批意见]
     */
    @JsonProperty("opinion")
    public String getOpinion(){
        return this.opinion ;
    }

    /**
     * 设置 [审批意见]
     */
    @JsonProperty("opinion")
    public void setOpinion(String  opinion){
        this.opinion = opinion ;
        this.opinionDirtyFlag = true ;
    }

    /**
     * 获取 [审批意见]脏标记
     */
    @JsonIgnore
    public boolean getOpinionDirtyFlag(){
        return this.opinionDirtyFlag ;
    }

    /**
     * 获取 [操作类型]
     */
    @JsonProperty("actiontype")
    public String getActionType(){
        return this.actionType ;
    }

    /**
     * 设置 [操作类型]
     */
    @JsonProperty("actiontype")
    public void setActionType(String  actionType){
        this.actionType = actionType ;
        this.actionTypeDirtyFlag = true ;
    }

    /**
     * 获取 [操作类型]脏标记
     */
    @JsonIgnore
    public boolean getActionTypeDirtyFlag(){
        return this.actionTypeDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [处理人]
     */
    @JsonProperty("personlist")
    public String getPersonList(){
        return this.personList ;
    }

    /**
     * 设置 [处理人]
     */
    @JsonProperty("personlist")
    public void setPersonList(String  personList){
        this.personList = personList ;
        this.personListDirtyFlag = true ;
    }

    /**
     * 获取 [处理人]脏标记
     */
    @JsonIgnore
    public boolean getPersonListDirtyFlag(){
        return this.personListDirtyFlag ;
    }

    /**
     * 获取 [用户数据]
     */
    @JsonProperty("userdata")
    public String getUserData(){
        return this.userData ;
    }

    /**
     * 设置 [用户数据]
     */
    @JsonProperty("userdata")
    public void setUserData(String  userData){
        this.userData = userData ;
        this.userDataDirtyFlag = true ;
    }

    /**
     * 获取 [用户数据]脏标记
     */
    @JsonIgnore
    public boolean getUserDataDirtyFlag(){
        return this.userDataDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [步骤]
     */
    @JsonProperty("wfstepid")
    public String getWFStepId(){
        return this.wFStepId ;
    }

    /**
     * 设置 [步骤]
     */
    @JsonProperty("wfstepid")
    public void setWFStepId(String  wFStepId){
        this.wFStepId = wFStepId ;
        this.wFStepIdDirtyFlag = true ;
    }

    /**
     * 获取 [步骤]脏标记
     */
    @JsonIgnore
    public boolean getWFStepIdDirtyFlag(){
        return this.wFStepIdDirtyFlag ;
    }

    /**
     * 获取 [工作流步骤操作名称]
     */
    @JsonProperty("wfiaactionname")
    public String getWFIAActionName(){
        return this.wFIAActionName ;
    }

    /**
     * 设置 [工作流步骤操作名称]
     */
    @JsonProperty("wfiaactionname")
    public void setWFIAActionName(String  wFIAActionName){
        this.wFIAActionName = wFIAActionName ;
        this.wFIAActionNameDirtyFlag = true ;
    }

    /**
     * 获取 [工作流步骤操作名称]脏标记
     */
    @JsonIgnore
    public boolean getWFIAActionNameDirtyFlag(){
        return this.wFIAActionNameDirtyFlag ;
    }

    /**
     * 获取 [操作人]
     */
    @JsonProperty("opperson")
    public String getOpPerson(){
        return this.opPerson ;
    }

    /**
     * 设置 [操作人]
     */
    @JsonProperty("opperson")
    public void setOpPerson(String  opPerson){
        this.opPerson = opPerson ;
        this.opPersonDirtyFlag = true ;
    }

    /**
     * 获取 [操作人]脏标记
     */
    @JsonIgnore
    public boolean getOpPersonDirtyFlag(){
        return this.opPersonDirtyFlag ;
    }

    /**
     * 获取 [实例]
     */
    @JsonProperty("wfinstanceid")
    public String getWFInstanceId(){
        return this.wFInstanceId ;
    }

    /**
     * 设置 [实例]
     */
    @JsonProperty("wfinstanceid")
    public void setWFInstanceId(String  wFInstanceId){
        this.wFInstanceId = wFInstanceId ;
        this.wFInstanceIdDirtyFlag = true ;
    }

    /**
     * 获取 [实例]脏标记
     */
    @JsonIgnore
    public boolean getWFInstanceIdDirtyFlag(){
        return this.wFInstanceIdDirtyFlag ;
    }



}
