package com.ibiz.web.r7rt_org.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[部门用户]
 */
public class OrgDeptUser implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 部门用户标识
     */
    private String orgDeptUserId;

    @JsonIgnore
    private boolean orgDeptUserIdDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * 是否启用
     */
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;
    
    /**
     * 部门用户名称
     */
    private String orgDeptUserName;

    @JsonIgnore
    private boolean orgDeptUserNameDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 组织名称
     */
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;
    
    /**
     * 部门名称
     */
    private String orgDeptName;

    @JsonIgnore
    private boolean orgDeptNameDirtyFlag;
    
    /**
     * 组织用户名称
     */
    private String orgUserName;

    @JsonIgnore
    private boolean orgUserNameDirtyFlag;
    
    /**
     * 组织用户标识
     */
    private String orgUserId;

    @JsonIgnore
    private boolean orgUserIdDirtyFlag;
    
    /**
     * 组织标识
     */
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;
    
    /**
     * 部门标识
     */
    private String orgDeptId;

    @JsonIgnore
    private boolean orgDeptIdDirtyFlag;
    

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [部门用户标识]
     */
    @JsonProperty("orgdeptuserid")
    public String getOrgDeptUserId(){
        return this.orgDeptUserId ;
    }

    /**
     * 设置 [部门用户标识]
     */
    @JsonProperty("orgdeptuserid")
    public void setOrgDeptUserId(String  orgDeptUserId){
        this.orgDeptUserId = orgDeptUserId ;
        this.orgDeptUserIdDirtyFlag = true ;
    }

    /**
     * 获取 [部门用户标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptUserIdDirtyFlag(){
        return this.orgDeptUserIdDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [是否启用]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return this.enable ;
    }

    /**
     * 设置 [是否启用]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [是否启用]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return this.enableDirtyFlag ;
    }

    /**
     * 获取 [部门用户名称]
     */
    @JsonProperty("orgdeptusername")
    public String getOrgDeptUserName(){
        return this.orgDeptUserName ;
    }

    /**
     * 设置 [部门用户名称]
     */
    @JsonProperty("orgdeptusername")
    public void setOrgDeptUserName(String  orgDeptUserName){
        this.orgDeptUserName = orgDeptUserName ;
        this.orgDeptUserNameDirtyFlag = true ;
    }

    /**
     * 获取 [部门用户名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptUserNameDirtyFlag(){
        return this.orgDeptUserNameDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [组织名称]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return this.orgName ;
    }

    /**
     * 设置 [组织名称]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [组织名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return this.orgNameDirtyFlag ;
    }

    /**
     * 获取 [部门名称]
     */
    @JsonProperty("orgdeptname")
    public String getOrgDeptName(){
        return this.orgDeptName ;
    }

    /**
     * 设置 [部门名称]
     */
    @JsonProperty("orgdeptname")
    public void setOrgDeptName(String  orgDeptName){
        this.orgDeptName = orgDeptName ;
        this.orgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [部门名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptNameDirtyFlag(){
        return this.orgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [组织用户名称]
     */
    @JsonProperty("orgusername")
    public String getOrgUserName(){
        return this.orgUserName ;
    }

    /**
     * 设置 [组织用户名称]
     */
    @JsonProperty("orgusername")
    public void setOrgUserName(String  orgUserName){
        this.orgUserName = orgUserName ;
        this.orgUserNameDirtyFlag = true ;
    }

    /**
     * 获取 [组织用户名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserNameDirtyFlag(){
        return this.orgUserNameDirtyFlag ;
    }

    /**
     * 获取 [组织用户标识]
     */
    @JsonProperty("orguserid")
    public String getOrgUserId(){
        return this.orgUserId ;
    }

    /**
     * 设置 [组织用户标识]
     */
    @JsonProperty("orguserid")
    public void setOrgUserId(String  orgUserId){
        this.orgUserId = orgUserId ;
        this.orgUserIdDirtyFlag = true ;
    }

    /**
     * 获取 [组织用户标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserIdDirtyFlag(){
        return this.orgUserIdDirtyFlag ;
    }

    /**
     * 获取 [组织标识]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return this.orgId ;
    }

    /**
     * 设置 [组织标识]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [组织标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return this.orgIdDirtyFlag ;
    }

    /**
     * 获取 [部门标识]
     */
    @JsonProperty("orgdeptid")
    public String getOrgDeptId(){
        return this.orgDeptId ;
    }

    /**
     * 设置 [部门标识]
     */
    @JsonProperty("orgdeptid")
    public void setOrgDeptId(String  orgDeptId){
        this.orgDeptId = orgDeptId ;
        this.orgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [部门标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptIdDirtyFlag(){
        return this.orgDeptIdDirtyFlag ;
    }



}
