package com.ibiz.web.ht.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[业务协作]
 */
public class BC implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * 备注
     */
    private String bz;

    @JsonIgnore
    private boolean bzDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 部门领导清单
     */
    private String bmldids;

    @JsonIgnore
    private boolean bmldidsDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * WFINSTANCEID
     */
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;
    
    /**
     * 工作流步骤
     */
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;
    
    /**
     * 业务协作名称
     */
    private String bCName;

    @JsonIgnore
    private boolean bCNameDirtyFlag;
    
    /**
     * 流程状态
     */
    private String bcwfstate;

    @JsonIgnore
    private boolean bcwfstateDirtyFlag;
    
    /**
     * 业务协作标识
     */
    private String bCId;

    @JsonIgnore
    private boolean bCIdDirtyFlag;
    
    /**
     * 部门名称
     */
    private String orgDeptName;

    @JsonIgnore
    private boolean orgDeptNameDirtyFlag;
    
    /**
     * 重要事项标识
     */
    private String iMId;

    @JsonIgnore
    private boolean iMIdDirtyFlag;
    
    /**
     * 部门标识
     */
    private String orgDeptId;

    @JsonIgnore
    private boolean orgDeptIdDirtyFlag;
    

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [备注]
     */
    @JsonProperty("bz")
    public String getBz(){
        return this.bz ;
    }

    /**
     * 设置 [备注]
     */
    @JsonProperty("bz")
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [备注]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return this.bzDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [部门领导清单]
     */
    @JsonProperty("bmldids")
    public String getBmldids(){
        return this.bmldids ;
    }

    /**
     * 设置 [部门领导清单]
     */
    @JsonProperty("bmldids")
    public void setBmldids(String  bmldids){
        this.bmldids = bmldids ;
        this.bmldidsDirtyFlag = true ;
    }

    /**
     * 获取 [部门领导清单]脏标记
     */
    @JsonIgnore
    public boolean getBmldidsDirtyFlag(){
        return this.bmldidsDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return this.wfinstanceid ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return this.wfinstanceidDirtyFlag ;
    }

    /**
     * 获取 [工作流步骤]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return this.wfstep ;
    }

    /**
     * 设置 [工作流步骤]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [工作流步骤]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return this.wfstepDirtyFlag ;
    }

    /**
     * 获取 [业务协作名称]
     */
    @JsonProperty("bcname")
    public String getBCName(){
        return this.bCName ;
    }

    /**
     * 设置 [业务协作名称]
     */
    @JsonProperty("bcname")
    public void setBCName(String  bCName){
        this.bCName = bCName ;
        this.bCNameDirtyFlag = true ;
    }

    /**
     * 获取 [业务协作名称]脏标记
     */
    @JsonIgnore
    public boolean getBCNameDirtyFlag(){
        return this.bCNameDirtyFlag ;
    }

    /**
     * 获取 [流程状态]
     */
    @JsonProperty("bcwfstate")
    public String getBcwfstate(){
        return this.bcwfstate ;
    }

    /**
     * 设置 [流程状态]
     */
    @JsonProperty("bcwfstate")
    public void setBcwfstate(String  bcwfstate){
        this.bcwfstate = bcwfstate ;
        this.bcwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [流程状态]脏标记
     */
    @JsonIgnore
    public boolean getBcwfstateDirtyFlag(){
        return this.bcwfstateDirtyFlag ;
    }

    /**
     * 获取 [业务协作标识]
     */
    @JsonProperty("bcid")
    public String getBCId(){
        return this.bCId ;
    }

    /**
     * 设置 [业务协作标识]
     */
    @JsonProperty("bcid")
    public void setBCId(String  bCId){
        this.bCId = bCId ;
        this.bCIdDirtyFlag = true ;
    }

    /**
     * 获取 [业务协作标识]脏标记
     */
    @JsonIgnore
    public boolean getBCIdDirtyFlag(){
        return this.bCIdDirtyFlag ;
    }

    /**
     * 获取 [部门名称]
     */
    @JsonProperty("orgdeptname")
    public String getOrgDeptName(){
        return this.orgDeptName ;
    }

    /**
     * 设置 [部门名称]
     */
    @JsonProperty("orgdeptname")
    public void setOrgDeptName(String  orgDeptName){
        this.orgDeptName = orgDeptName ;
        this.orgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [部门名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptNameDirtyFlag(){
        return this.orgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [重要事项标识]
     */
    @JsonProperty("imid")
    public String getIMId(){
        return this.iMId ;
    }

    /**
     * 设置 [重要事项标识]
     */
    @JsonProperty("imid")
    public void setIMId(String  iMId){
        this.iMId = iMId ;
        this.iMIdDirtyFlag = true ;
    }

    /**
     * 获取 [重要事项标识]脏标记
     */
    @JsonIgnore
    public boolean getIMIdDirtyFlag(){
        return this.iMIdDirtyFlag ;
    }

    /**
     * 获取 [部门标识]
     */
    @JsonProperty("orgdeptid")
    public String getOrgDeptId(){
        return this.orgDeptId ;
    }

    /**
     * 设置 [部门标识]
     */
    @JsonProperty("orgdeptid")
    public void setOrgDeptId(String  orgDeptId){
        this.orgDeptId = orgDeptId ;
        this.orgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [部门标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptIdDirtyFlag(){
        return this.orgDeptIdDirtyFlag ;
    }



}
