package com.ibiz.wfweb.htwf.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb.htwf.service.WFBCService;
import com.ibiz.wfweb.htwf.domain.WFBC;
import com.ibiz.wfweb.htwf.filter.*;

@RestController
@RequestMapping(value = "")
public class WFBCController {
	@Autowired
    WFBCService wfbcservice;


	@RequestMapping(method = RequestMethod.DELETE, value = "/wfbcs/{wfbc_id}")
    @PreAuthorize("@wfbc_pms.check(#wfbc_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("wfbc_id") String wfbc_id) {
        boolean b = wfbcservice.remove( wfbc_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfbcs")
    @PreAuthorize("@wfbc_pms.check('CREATE')")
    public ResponseEntity<WFBC> create(@RequestBody WFBC wfbc) {
        WFBC wfbc2 = wfbcservice.create(wfbc);
        return ResponseEntity.status(HttpStatus.OK).body(wfbc2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfbcs/{wfbc_id}")
    @PreAuthorize("@wfbc_pms.check(#wfbc_id,'READ')")
    public ResponseEntity<WFBC> get(@PathVariable("wfbc_id") String wfbc_id) {
        WFBC wfbc = wfbcservice.get( wfbc_id);
        return ResponseEntity.status(HttpStatus.OK).body(wfbc);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/save")
    @PreAuthorize("@wfbc_pms.check(#wfbc_id,'')")
    public ResponseEntity<WFBC> save(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBC wfbc) {
        WFBC wfbc2 = wfbcservice.save(wfbc_id, wfbc);
        return ResponseEntity.status(HttpStatus.OK).body(wfbc2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfbcs/checkkey")
    @PreAuthorize("@wfbc_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFBC wfbc) {
        boolean b = wfbcservice.checkKey(wfbc);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfbcs/getdraft")
    @PreAuthorize("@wfbc_pms.check('CREATE')")
    public ResponseEntity<WFBC> getDraft() {
        //WFBC wfbc = wfbcservice.getDraft( wfbc_id);
        return ResponseEntity.status(HttpStatus.OK).body(new WFBC());
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/wfbcs/{wfbc_id}")
    @PreAuthorize("@wfbc_pms.check(#wfbc_id,'UPDATE')")
    public ResponseEntity<WFBC> update(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBC wfbc) {
        WFBC wfbc2 = wfbcservice.update(wfbc_id, wfbc);
        return ResponseEntity.status(HttpStatus.OK).body(wfbc2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/wfbcs/{wfbc_id}")
    @PreAuthorize("@wfbc_pms.check(#wfbc_id,'UPDATE')")
    public ResponseEntity<WFBC> api_update(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBC wfbc) {
        WFBC wfbc2 = wfbcservice.update(wfbc_id, wfbc);
        return ResponseEntity.status(HttpStatus.OK).body(wfbc2);
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfbcs/fetchdefault")
    @PreAuthorize("@wfbc_pms.check('READ')")
	public ResponseEntity<List<WFBC>> fetchDefault(WFBCSearchContext searchContext,Pageable pageable) {
        
        Page<WFBC> page = wfbcservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


    /** 工作流行为 **/

    /**
     * 开始流程【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfstart")
    public ResponseEntity<JSONObject> wfStart(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", false);
        if (wfbcservice.wfStart(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 开始流程2【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/api/wfbcs/wfstart")
    public ResponseEntity<JSONObject> wfStart(@RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", true);
        if (wfbcservice.wfStart(null, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程处理【WFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfsubmit")
    public ResponseEntity<JSONObject> wfSubmit(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (wfbcservice.wfSubmit(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 测试当前用户是否提交过工作流【testUserWFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/testuserwfsubmit")
    public ResponseEntity<Boolean> testUserWFSubmit(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbcservice.testUserWFSubmit(wfbc_id, data));
    }

    /**
     * 测试当前用户是否存在工作任务【testUserExistWorklist】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/testuserexistworklist")
    public ResponseEntity<Boolean> testUserExistWorklist(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbcservice.testUserExistWorklist(wfbc_id, data));
    }

    /**
     * 流程结束【WFClose】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfclose")
    public ResponseEntity<JSONObject> wfClose(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (wfbcservice.wfClose(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程跳转【WFGoto】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfgoto")
    public ResponseEntity<JSONObject> wfGoto(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (wfbcservice.wfGoto(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重启【WFRestart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfrestart")
    public ResponseEntity<JSONObject> wfRestart(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (wfbcservice.wfRestart(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程撤回【WFRollback】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfrollback")
    public ResponseEntity<JSONObject> wfRollback(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (wfbcservice.wfRollback(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程退回【WFSendBack】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfsendback")
    public ResponseEntity<JSONObject> wfSendBack(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (wfbcservice.wfSendBack(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重新分配【WFReassign】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfreassign")
    public ResponseEntity<JSONObject> wfReassign(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        if (wfbcservice.wfReassign(wfbc_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程标记已读【WFMarkRead】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbcs/{wfbc_id}/wfmarkread")
    public ResponseEntity<Boolean> wfMarkRead(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbcservice.wfMarkRead(wfbc_id, data));
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    @RequestMapping(method = RequestMethod.POST, value = "api/wfbcs/{wfbc_id}/wfaction")
    public ResponseEntity<JSONObject> wfAction(@PathVariable("wfbc_id") String wfbc_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbcservice.wfAction(wfbc_id, data));
    }

    /**
     * 获取代理数据【WFGetProxyData】
     */
    @RequestMapping(method = RequestMethod.GET, value = "/wfbcs/{wfbc_id}/wfgetproxydata")
    public ResponseEntity<JSONObject> wfGetProxyData(@PathVariable("wfbc_id") String wfbc_id) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbcservice.wfGetProxyData(wfbc_id));
    }


}
