package com.ibiz.wfweb.htwf.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb.htwf.domain.WFAS;
import com.ibiz.wfweb.htwf.filter.*;


public interface WFASFeignClient {



	@RequestMapping(method = RequestMethod.GET, value = "/web/wfas/{wfas_id}")
    public WFAS get(@PathVariable("wfas_id") String wfas_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfas/{wfas_id}/save")
    public WFAS save(@PathVariable("wfas_id") String wfas_id, @RequestBody WFAS wfas) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfas/{wfas_id}")
    public Boolean remove(@PathVariable("wfas_id") String wfas_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfas/checkkey")
    public Boolean checkKey(@RequestBody WFAS wfas) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfas/{wfas_id}")
    public WFAS update(@PathVariable("wfas_id") String wfas_id, @RequestBody WFAS wfas) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfas/{wfas_id}/getdraft")
    public WFAS getDraft(@PathVariable("wfas_id") String wfas_id, @RequestBody WFAS wfas) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfas")
    public WFAS create(@RequestBody WFAS wfas) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfas/fetchdefault")
	public Page<WFAS> fetchDefault(WFASSearchContext searchContext) ;
}
