package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.WFIMDTO;
import com.ibiz.core.htwf.domain.WFIM;
import com.ibiz.core.htwf.service.IWFIMService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.htwf.filter.WFIMSearchContext;

@Api(tags = {"WFIM" })
@RestController
@RequestMapping("")
public class WFIMResource {

    @Autowired
    private IWFIMService wfimService;

    public IWFIMService getWfimService() {
        return this.wfimService;
    }

    @ApiOperation(value = "Remove", tags = {"WFIM" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfims/{wfim_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("wfim_id") String wfim_id) {
        WFIMDTO wfimdto = new WFIMDTO();
		WFIM domain = new WFIM();
		wfimdto.setWFIMId(wfim_id);
		domain.setWFIMId(wfim_id);
        Boolean rst = wfimService.remove(domain.getWFIMId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Update", tags = {"WFIM" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfims/{wfim_id}")
    @Transactional
    public ResponseEntity<WFIMDTO> update(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIMDTO wfimdto) {
		WFIM domain = wfimdto.toDO();
        domain.setWFIMId(wfim_id);
		wfimService.update(domain);
		WFIMDTO dto = new WFIMDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"WFIM" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfims/{wfim_id}/getdraft")
    @Transactional
    public ResponseEntity<WFIMDTO> getDraft(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIMDTO wfimdto) {
        WFIM wfim = wfimdto.toDO();
    	wfim = wfimService.getDraft(wfim) ;
    	wfimdto.fromDO(wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfimdto);
    }

    @ApiOperation(value = "Save", tags = {"WFIM" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfims/{wfim_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody WFIMDTO wfimdto) {
        WFIM wfim = wfimdto.toDO();
    	Boolean b = wfimService.save(wfim) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Create", tags = {"WFIM" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfims")
    @Transactional
    public ResponseEntity<WFIMDTO> create(@RequestBody WFIMDTO wfimdto) {
        WFIMDTO dto = new WFIMDTO();
        WFIM domain = wfimdto.toDO();
		wfimService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"WFIM" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfims/{wfim_id}")
    public ResponseEntity<WFIMDTO> get(@PathVariable("wfim_id") String wfim_id) {
        WFIMDTO dto = new WFIMDTO();
        WFIM domain = wfimService.get(wfim_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"WFIM" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfims/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFIMDTO wfimdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"WFIM" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfims/fetchdefault")
	public ResponseEntity<Page<WFIMDTO>> fetchDefault(WFIMSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFIMDTO> list = new ArrayList<WFIMDTO>();
        
        Page<WFIM> domains = wfimService.searchDefault(context) ;
        for(WFIM wfim : domains.getContent()){
            WFIMDTO dto = new WFIMDTO();
            dto.fromDO(wfim);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
