package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.ht.valuerule.anno.srffile.*;
import com.ibiz.core.ht.domain.SRFFILE;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[SRFFILEDTO]
 */
public class SRFFILEDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [FILEPATH]
     *
     */
    @SRFFILEFilepathDefault(info = "默认规则")
    private String filepath;

    @JsonIgnore
    private boolean filepathDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @SRFFILEUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [OWNERID]
     *
     */
    @SRFFILEOwneridDefault(info = "默认规则")
    private String ownerid;

    @JsonIgnore
    private boolean owneridDirtyFlag;

    /**
     * 属性 [DIGESTCODE]
     *
     */
    @SRFFILEDigestcodeDefault(info = "默认规则")
    private String digestcode;

    @JsonIgnore
    private boolean digestcodeDirtyFlag;

    /**
     * 属性 [FOLDER]
     *
     */
    @SRFFILEFolderDefault(info = "默认规则")
    private String folder;

    @JsonIgnore
    private boolean folderDirtyFlag;

    /**
     * 属性 [PICHEIGHT]
     *
     */
    @SRFFILEPicheightDefault(info = "默认规则")
    private Integer picheight;

    @JsonIgnore
    private boolean picheightDirtyFlag;

    /**
     * 属性 [SRFFILENAME]
     *
     */
    @SRFFILESRFFILENameDefault(info = "默认规则")
    private String sRFFILEName;

    @JsonIgnore
    private boolean sRFFILENameDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @SRFFILECreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @SRFFILEUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [PICWIDTH]
     *
     */
    @SRFFILEPicwidthDefault(info = "默认规则")
    private Integer picwidth;

    @JsonIgnore
    private boolean picwidthDirtyFlag;

    /**
     * 属性 [SRFFILEID]
     *
     */
    @SRFFILESRFFILEIdDefault(info = "默认规则")
    private String sRFFILEId;

    @JsonIgnore
    private boolean sRFFILEIdDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @SRFFILECreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [FILEEXT]
     *
     */
    @SRFFILEFileextDefault(info = "默认规则")
    private String fileext;

    @JsonIgnore
    private boolean fileextDirtyFlag;

    /**
     * 属性 [FILESIZE]
     *
     */
    @SRFFILEFilesizeDefault(info = "默认规则")
    private Integer filesize;

    @JsonIgnore
    private boolean filesizeDirtyFlag;


    /**
     * 获取 [FILEPATH]
     */
    @JsonProperty("filepath")
    public String getFilepath(){
        return filepath ;
    }

    /**
     * 设置 [FILEPATH]
     */
    @JsonProperty("filepath")
    public void setFilepath(String  filepath){
        this.filepath = filepath ;
        this.filepathDirtyFlag = true ;
    }

    /**
     * 获取 [FILEPATH]脏标记
     */
    @JsonIgnore
    public boolean getFilepathDirtyFlag(){
        return filepathDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [OWNERID]
     */
    @JsonProperty("ownerid")
    public String getOwnerid(){
        return ownerid ;
    }

    /**
     * 设置 [OWNERID]
     */
    @JsonProperty("ownerid")
    public void setOwnerid(String  ownerid){
        this.ownerid = ownerid ;
        this.owneridDirtyFlag = true ;
    }

    /**
     * 获取 [OWNERID]脏标记
     */
    @JsonIgnore
    public boolean getOwneridDirtyFlag(){
        return owneridDirtyFlag ;
    }

    /**
     * 获取 [DIGESTCODE]
     */
    @JsonProperty("digestcode")
    public String getDigestcode(){
        return digestcode ;
    }

    /**
     * 设置 [DIGESTCODE]
     */
    @JsonProperty("digestcode")
    public void setDigestcode(String  digestcode){
        this.digestcode = digestcode ;
        this.digestcodeDirtyFlag = true ;
    }

    /**
     * 获取 [DIGESTCODE]脏标记
     */
    @JsonIgnore
    public boolean getDigestcodeDirtyFlag(){
        return digestcodeDirtyFlag ;
    }

    /**
     * 获取 [FOLDER]
     */
    @JsonProperty("folder")
    public String getFolder(){
        return folder ;
    }

    /**
     * 设置 [FOLDER]
     */
    @JsonProperty("folder")
    public void setFolder(String  folder){
        this.folder = folder ;
        this.folderDirtyFlag = true ;
    }

    /**
     * 获取 [FOLDER]脏标记
     */
    @JsonIgnore
    public boolean getFolderDirtyFlag(){
        return folderDirtyFlag ;
    }

    /**
     * 获取 [PICHEIGHT]
     */
    @JsonProperty("picheight")
    public Integer getPicheight(){
        return picheight ;
    }

    /**
     * 设置 [PICHEIGHT]
     */
    @JsonProperty("picheight")
    public void setPicheight(Integer  picheight){
        this.picheight = picheight ;
        this.picheightDirtyFlag = true ;
    }

    /**
     * 获取 [PICHEIGHT]脏标记
     */
    @JsonIgnore
    public boolean getPicheightDirtyFlag(){
        return picheightDirtyFlag ;
    }

    /**
     * 获取 [SRFFILENAME]
     */
    @JsonProperty("srffilename")
    public String getSRFFILEName(){
        return sRFFILEName ;
    }

    /**
     * 设置 [SRFFILENAME]
     */
    @JsonProperty("srffilename")
    public void setSRFFILEName(String  sRFFILEName){
        this.sRFFILEName = sRFFILEName ;
        this.sRFFILENameDirtyFlag = true ;
    }

    /**
     * 获取 [SRFFILENAME]脏标记
     */
    @JsonIgnore
    public boolean getSRFFILENameDirtyFlag(){
        return sRFFILENameDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [PICWIDTH]
     */
    @JsonProperty("picwidth")
    public Integer getPicwidth(){
        return picwidth ;
    }

    /**
     * 设置 [PICWIDTH]
     */
    @JsonProperty("picwidth")
    public void setPicwidth(Integer  picwidth){
        this.picwidth = picwidth ;
        this.picwidthDirtyFlag = true ;
    }

    /**
     * 获取 [PICWIDTH]脏标记
     */
    @JsonIgnore
    public boolean getPicwidthDirtyFlag(){
        return picwidthDirtyFlag ;
    }

    /**
     * 获取 [SRFFILEID]
     */
    @JsonProperty("srffileid")
    public String getSRFFILEId(){
        return sRFFILEId ;
    }

    /**
     * 设置 [SRFFILEID]
     */
    @JsonProperty("srffileid")
    public void setSRFFILEId(String  sRFFILEId){
        this.sRFFILEId = sRFFILEId ;
        this.sRFFILEIdDirtyFlag = true ;
    }

    /**
     * 获取 [SRFFILEID]脏标记
     */
    @JsonIgnore
    public boolean getSRFFILEIdDirtyFlag(){
        return sRFFILEIdDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [FILEEXT]
     */
    @JsonProperty("fileext")
    public String getFileext(){
        return fileext ;
    }

    /**
     * 设置 [FILEEXT]
     */
    @JsonProperty("fileext")
    public void setFileext(String  fileext){
        this.fileext = fileext ;
        this.fileextDirtyFlag = true ;
    }

    /**
     * 获取 [FILEEXT]脏标记
     */
    @JsonIgnore
    public boolean getFileextDirtyFlag(){
        return fileextDirtyFlag ;
    }

    /**
     * 获取 [FILESIZE]
     */
    @JsonProperty("filesize")
    public Integer getFilesize(){
        return filesize ;
    }

    /**
     * 设置 [FILESIZE]
     */
    @JsonProperty("filesize")
    public void setFilesize(Integer  filesize){
        this.filesize = filesize ;
        this.filesizeDirtyFlag = true ;
    }

    /**
     * 获取 [FILESIZE]脏标记
     */
    @JsonIgnore
    public boolean getFilesizeDirtyFlag(){
        return filesizeDirtyFlag ;
    }



    public SRFFILE toDO() {
        SRFFILE srfdomain = new SRFFILE();
        if(getFilepathDirtyFlag())
            srfdomain.setFilepath(filepath);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getOwneridDirtyFlag())
            srfdomain.setOwnerid(ownerid);
        if(getDigestcodeDirtyFlag())
            srfdomain.setDigestcode(digestcode);
        if(getFolderDirtyFlag())
            srfdomain.setFolder(folder);
        if(getPicheightDirtyFlag())
            srfdomain.setPicheight(picheight);
        if(getSRFFILENameDirtyFlag())
            srfdomain.setSRFFILEName(sRFFILEName);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getPicwidthDirtyFlag())
            srfdomain.setPicwidth(picwidth);
        if(getSRFFILEIdDirtyFlag())
            srfdomain.setSRFFILEId(sRFFILEId);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getFileextDirtyFlag())
            srfdomain.setFileext(fileext);
        if(getFilesizeDirtyFlag())
            srfdomain.setFilesize(filesize);

        return srfdomain;
    }

    public void fromDO(SRFFILE srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getFilepathDirtyFlag())
            this.setFilepath(srfdomain.getFilepath());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getOwneridDirtyFlag())
            this.setOwnerid(srfdomain.getOwnerid());
        if(srfdomain.getDigestcodeDirtyFlag())
            this.setDigestcode(srfdomain.getDigestcode());
        if(srfdomain.getFolderDirtyFlag())
            this.setFolder(srfdomain.getFolder());
        if(srfdomain.getPicheightDirtyFlag())
            this.setPicheight(srfdomain.getPicheight());
        if(srfdomain.getSRFFILENameDirtyFlag())
            this.setSRFFILEName(srfdomain.getSRFFILEName());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getPicwidthDirtyFlag())
            this.setPicwidth(srfdomain.getPicwidth());
        if(srfdomain.getSRFFILEIdDirtyFlag())
            this.setSRFFILEId(srfdomain.getSRFFILEId());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getFileextDirtyFlag())
            this.setFileext(srfdomain.getFileext());
        if(srfdomain.getFilesizeDirtyFlag())
            this.setFilesize(srfdomain.getFilesize());

    }

    public List<SRFFILEDTO> fromDOPage(List<SRFFILE> poPage)   {
        if(poPage == null)
            return null;
        List<SRFFILEDTO> dtos=new ArrayList<SRFFILEDTO>();
        for(SRFFILE domain : poPage) {
            SRFFILEDTO dto = new SRFFILEDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

