package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.r7rt_org.valuerule.anno.orguser.*;
import com.ibiz.core.r7rt_org.domain.OrgUser;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[OrgUserDTO]
 */
public class OrgUserDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [SEX]
     *
     */
    @OrgUserSexDefault(info = "默认规则")
    private String sex;

    @JsonIgnore
    private boolean sexDirtyFlag;

    /**
     * 属性 [ORGUSERID]
     *
     */
    @OrgUserOrgUserIdDefault(info = "默认规则")
    private String orgUserId;

    @JsonIgnore
    private boolean orgUserIdDirtyFlag;

    /**
     * 属性 [MOBILEPHONE]
     *
     */
    @OrgUserMobilePhoneDefault(info = "默认规则")
    private String mobilePhone;

    @JsonIgnore
    private boolean mobilePhoneDirtyFlag;

    /**
     * 属性 [CERTTYPE]
     *
     */
    @OrgUserCertTypeDefault(info = "默认规则")
    private String certType;

    @JsonIgnore
    private boolean certTypeDirtyFlag;

    /**
     * 属性 [ORGUSERNAME]
     *
     */
    @OrgUserOrgUserNameDefault(info = "默认规则")
    private String orgUserName;

    @JsonIgnore
    private boolean orgUserNameDirtyFlag;

    /**
     * 属性 [USERCODE]
     *
     */
    @OrgUserUserCodeDefault(info = "默认规则")
    private String userCode;

    @JsonIgnore
    private boolean userCodeDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @OrgUserCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @OrgUserUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @OrgUserCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [ENABLE]
     *
     */
    @OrgUserEnableDefault(info = "默认规则")
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;

    /**
     * 属性 [LOGINNAME]
     *
     */
    @OrgUserLoginNameDefault(info = "默认规则")
    private String loginName;

    @JsonIgnore
    private boolean loginNameDirtyFlag;

    /**
     * 属性 [CERTNO]
     *
     */
    @OrgUserCertNoDefault(info = "默认规则")
    private String certNo;

    @JsonIgnore
    private boolean certNoDirtyFlag;

    /**
     * 属性 [USERID]
     *
     */
    @OrgUserUserIdDefault(info = "默认规则")
    private String userId;

    @JsonIgnore
    private boolean userIdDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @OrgUserUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [MEMO]
     *
     */
    @OrgUserMemoDefault(info = "默认规则")
    private String memo;

    @JsonIgnore
    private boolean memoDirtyFlag;

    /**
     * 属性 [ORGNAME]
     *
     */
    @OrgUserOrgNameDefault(info = "默认规则")
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;

    /**
     * 属性 [ORGID]
     *
     */
    @OrgUserOrgIdDefault(info = "默认规则")
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;


    /**
     * 获取 [SEX]
     */
    @JsonProperty("sex")
    public String getSex(){
        return sex ;
    }

    /**
     * 设置 [SEX]
     */
    @JsonProperty("sex")
    public void setSex(String  sex){
        this.sex = sex ;
        this.sexDirtyFlag = true ;
    }

    /**
     * 获取 [SEX]脏标记
     */
    @JsonIgnore
    public boolean getSexDirtyFlag(){
        return sexDirtyFlag ;
    }

    /**
     * 获取 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public String getOrgUserId(){
        return orgUserId ;
    }

    /**
     * 设置 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public void setOrgUserId(String  orgUserId){
        this.orgUserId = orgUserId ;
        this.orgUserIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERID]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserIdDirtyFlag(){
        return orgUserIdDirtyFlag ;
    }

    /**
     * 获取 [MOBILEPHONE]
     */
    @JsonProperty("mobilephone")
    public String getMobilePhone(){
        return mobilePhone ;
    }

    /**
     * 设置 [MOBILEPHONE]
     */
    @JsonProperty("mobilephone")
    public void setMobilePhone(String  mobilePhone){
        this.mobilePhone = mobilePhone ;
        this.mobilePhoneDirtyFlag = true ;
    }

    /**
     * 获取 [MOBILEPHONE]脏标记
     */
    @JsonIgnore
    public boolean getMobilePhoneDirtyFlag(){
        return mobilePhoneDirtyFlag ;
    }

    /**
     * 获取 [CERTTYPE]
     */
    @JsonProperty("certtype")
    public String getCertType(){
        return certType ;
    }

    /**
     * 设置 [CERTTYPE]
     */
    @JsonProperty("certtype")
    public void setCertType(String  certType){
        this.certType = certType ;
        this.certTypeDirtyFlag = true ;
    }

    /**
     * 获取 [CERTTYPE]脏标记
     */
    @JsonIgnore
    public boolean getCertTypeDirtyFlag(){
        return certTypeDirtyFlag ;
    }

    /**
     * 获取 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public String getOrgUserName(){
        return orgUserName ;
    }

    /**
     * 设置 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public void setOrgUserName(String  orgUserName){
        this.orgUserName = orgUserName ;
        this.orgUserNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserNameDirtyFlag(){
        return orgUserNameDirtyFlag ;
    }

    /**
     * 获取 [USERCODE]
     */
    @JsonProperty("usercode")
    public String getUserCode(){
        return userCode ;
    }

    /**
     * 设置 [USERCODE]
     */
    @JsonProperty("usercode")
    public void setUserCode(String  userCode){
        this.userCode = userCode ;
        this.userCodeDirtyFlag = true ;
    }

    /**
     * 获取 [USERCODE]脏标记
     */
    @JsonIgnore
    public boolean getUserCodeDirtyFlag(){
        return userCodeDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [ENABLE]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return enable ;
    }

    /**
     * 设置 [ENABLE]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [ENABLE]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return enableDirtyFlag ;
    }

    /**
     * 获取 [LOGINNAME]
     */
    @JsonProperty("loginname")
    public String getLoginName(){
        return loginName ;
    }

    /**
     * 设置 [LOGINNAME]
     */
    @JsonProperty("loginname")
    public void setLoginName(String  loginName){
        this.loginName = loginName ;
        this.loginNameDirtyFlag = true ;
    }

    /**
     * 获取 [LOGINNAME]脏标记
     */
    @JsonIgnore
    public boolean getLoginNameDirtyFlag(){
        return loginNameDirtyFlag ;
    }

    /**
     * 获取 [CERTNO]
     */
    @JsonProperty("certno")
    public String getCertNo(){
        return certNo ;
    }

    /**
     * 设置 [CERTNO]
     */
    @JsonProperty("certno")
    public void setCertNo(String  certNo){
        this.certNo = certNo ;
        this.certNoDirtyFlag = true ;
    }

    /**
     * 获取 [CERTNO]脏标记
     */
    @JsonIgnore
    public boolean getCertNoDirtyFlag(){
        return certNoDirtyFlag ;
    }

    /**
     * 获取 [USERID]
     */
    @JsonProperty("userid")
    public String getUserId(){
        return userId ;
    }

    /**
     * 设置 [USERID]
     */
    @JsonProperty("userid")
    public void setUserId(String  userId){
        this.userId = userId ;
        this.userIdDirtyFlag = true ;
    }

    /**
     * 获取 [USERID]脏标记
     */
    @JsonIgnore
    public boolean getUserIdDirtyFlag(){
        return userIdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [MEMO]
     */
    @JsonProperty("memo")
    public String getMemo(){
        return memo ;
    }

    /**
     * 设置 [MEMO]
     */
    @JsonProperty("memo")
    public void setMemo(String  memo){
        this.memo = memo ;
        this.memoDirtyFlag = true ;
    }

    /**
     * 获取 [MEMO]脏标记
     */
    @JsonIgnore
    public boolean getMemoDirtyFlag(){
        return memoDirtyFlag ;
    }

    /**
     * 获取 [ORGNAME]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return orgName ;
    }

    /**
     * 设置 [ORGNAME]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return orgNameDirtyFlag ;
    }

    /**
     * 获取 [ORGID]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return orgId ;
    }

    /**
     * 设置 [ORGID]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGID]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return orgIdDirtyFlag ;
    }



    public OrgUser toDO() {
        OrgUser srfdomain = new OrgUser();
        if(getSexDirtyFlag())
            srfdomain.setSex(sex);
        if(getOrgUserIdDirtyFlag())
            srfdomain.setOrgUserId(orgUserId);
        if(getMobilePhoneDirtyFlag())
            srfdomain.setMobilePhone(mobilePhone);
        if(getCertTypeDirtyFlag())
            srfdomain.setCertType(certType);
        if(getOrgUserNameDirtyFlag())
            srfdomain.setOrgUserName(orgUserName);
        if(getUserCodeDirtyFlag())
            srfdomain.setUserCode(userCode);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getEnableDirtyFlag())
            srfdomain.setEnable(enable);
        if(getLoginNameDirtyFlag())
            srfdomain.setLoginName(loginName);
        if(getCertNoDirtyFlag())
            srfdomain.setCertNo(certNo);
        if(getUserIdDirtyFlag())
            srfdomain.setUserId(userId);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getMemoDirtyFlag())
            srfdomain.setMemo(memo);
        if(getOrgNameDirtyFlag())
            srfdomain.setOrgName(orgName);
        if(getOrgIdDirtyFlag())
            srfdomain.setOrgId(orgId);

        return srfdomain;
    }

    public void fromDO(OrgUser srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getSexDirtyFlag())
            this.setSex(srfdomain.getSex());
        if(srfdomain.getOrgUserIdDirtyFlag())
            this.setOrgUserId(srfdomain.getOrgUserId());
        if(srfdomain.getMobilePhoneDirtyFlag())
            this.setMobilePhone(srfdomain.getMobilePhone());
        if(srfdomain.getCertTypeDirtyFlag())
            this.setCertType(srfdomain.getCertType());
        if(srfdomain.getOrgUserNameDirtyFlag())
            this.setOrgUserName(srfdomain.getOrgUserName());
        if(srfdomain.getUserCodeDirtyFlag())
            this.setUserCode(srfdomain.getUserCode());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getEnableDirtyFlag())
            this.setEnable(srfdomain.getEnable());
        if(srfdomain.getLoginNameDirtyFlag())
            this.setLoginName(srfdomain.getLoginName());
        if(srfdomain.getCertNoDirtyFlag())
            this.setCertNo(srfdomain.getCertNo());
        if(srfdomain.getUserIdDirtyFlag())
            this.setUserId(srfdomain.getUserId());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getMemoDirtyFlag())
            this.setMemo(srfdomain.getMemo());
        if(srfdomain.getOrgNameDirtyFlag())
            this.setOrgName(srfdomain.getOrgName());
        if(srfdomain.getOrgIdDirtyFlag())
            this.setOrgId(srfdomain.getOrgId());

    }

    public List<OrgUserDTO> fromDOPage(List<OrgUser> poPage)   {
        if(poPage == null)
            return null;
        List<OrgUserDTO> dtos=new ArrayList<OrgUserDTO>();
        for(OrgUser domain : poPage) {
            OrgUserDTO dto = new OrgUserDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

