
package com.ibiz.wfweb2.r7rt_org.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb2.r7rt_org.domain.OrgDept;
import com.ibiz.wfweb2.r7rt_org.filter.*;
import com.ibiz.wfweb2.r7rt_org.feign.OrgDeptFeignClient;
import com.ibiz.wfweb2.WFWeb2Application.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;

@Service
public class OrgDeptService {

    OrgDeptFeignClient client;

    @Autowired
    public OrgDeptService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgDeptFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgDeptFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public OrgDept save(String orgdept_id, OrgDept orgdept) {
        return client.save(orgdept_id, orgdept);
    }

    public OrgDept syncToUserGroup(String orgdept_id, OrgDept orgdept) {
        return client.syncToUserGroup(orgdept_id, orgdept);
    }

    public OrgDept getOrgDeptChild(String orgdept_id, OrgDept orgdept) {
        return client.getOrgDeptChild(orgdept_id, orgdept);
    }

    public boolean remove( String orgdept_id) {
        return client.remove( orgdept_id);
    }

    public OrgDept get( String orgdept_id) {
        return client.get( orgdept_id);
    }

    public OrgDept update(String orgdept_id, OrgDept orgdept) {
        return client.update(orgdept_id, orgdept);
    }

    public OrgDept getDraft(String orgdept_id, OrgDept orgdept) {
        return client.getDraft(orgdept_id, orgdept);
    }

	public OrgDept create(OrgDept orgdept) {
        return client.create(orgdept);
    }

    public boolean checkKey(OrgDept orgdept) {
        return client.checkKey(orgdept);
    }

    public OrgDept getOrgDeptPrent(String orgdept_id, OrgDept orgdept) {
        return client.getOrgDeptPrent(orgdept_id, orgdept);
    }

	public Page<OrgDept> fetchDefault(OrgDeptSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

	public Page<OrgDept> fetchCUR_ORG(OrgDeptSearchContext searchContext) {
        return client.fetchCUR_ORG(searchContext);
    }

}
