package com.ibiz.wfweb.job;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.core.io.ClassPathResource;
import com.alibaba.fastjson.JSONObject;

import java.io.InputStream;
import java.util.List;
import java.util.ArrayList;

import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.domain.*;

/**
 *
 */
@Component
public class WFAppJob implements ApplicationRunner {

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    SysInfoProperties sysInfoProperties;

    @Autowired
    public WFAppJob(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor, UniWFClientProperties uniWFClientProperties) {
        if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        /* ---------- 工作流应用注册内容 ---------- */

        // 注册工作流应用
        registWFApp();

        // 注册业务工作流版本
        registWFVer();

        // 注册流程处理
        registWFProcess();

        // 注册流程连接
        registWFLink();

        // 注册流程处理角色
        registWFProcRole();

        // 注册嵌套流程
        registPSWFProcSubWF();

    }

    /**
     * 注册工作流应用
     */
    private void registWFApp() {
        WFApp wfapp = new WFApp();
        wfapp.setWfappid(sysInfoProperties.getAppid());
        wfapp.setWfappname(sysInfoProperties.getAppname());
        wfapp.setPssystemid(sysInfoProperties.getSystemid());
        wfapp.setWorkflowid(sysInfoProperties.getDomainid());
        wfapp.setServiceid(sysInfoProperties.getServiceid());
        wfapp.setServiceurl(sysInfoProperties.getServiceurl());
        wfapp.setAppurl(sysInfoProperties.getAppurl());
        wfapp.setLogicname(sysInfoProperties.getApplogicname());
        uniWFFeignClient.registWFApp(wfapp);
    }

    /**
     * 注册业务工作流版本
     */
    private void registWFVer() {
        List<PSWFVersion> pswfversions = new ArrayList<PSWFVersion>();
        PSWFVersion pswfversion0 = new PSWFVersion();
        pswfversion0.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswfversion0.setPswfversionname("部门内审核 v1");
        pswfversion0.setLogicname("部门内审核 v1");
        pswfversion0.setPsworkflowid("7ba93f6994808554d57fd44f804ae8a2");
        pswfversion0.setPsworkflowname("部门内审核");
        pswfversion0.setWfappid(sysInfoProperties.getAppid());
        pswfversion0.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion0.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion0.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion0.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion0.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfbms"));
        pswfversion0.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion0.setModuleid("WFBM");
        pswfversion0.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion0DesignFile = new ClassPathResource("workflow/BMWFv1.bpmn");
        InputStream pswfversion0Is = null;
        try {
            pswfversion0Is = pswfversion0DesignFile.getInputStream();
            byte[] pswfversion0Content = new byte[pswfversion0Is.available()];
            pswfversion0Is.read(pswfversion0Content);
            pswfversion0.setFilename(pswfversion0.getPswfversionid() + "BMWFv1.bpmn");
            pswfversion0.setFilecontent(pswfversion0Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion0Is != null) {
                try {
                    pswfversion0Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion0Is = null;
        }
        pswfversions.add(pswfversion0);
        PSWFVersion pswfversion1 = new PSWFVersion();
        pswfversion1.setPswfversionid("4d2a2d866e44aa62df80b5521e0f01d7");
        pswfversion1.setPswfversionname("加签 v1");
        pswfversion1.setLogicname("加签 v1");
        pswfversion1.setPsworkflowid("61ba4cc481bd586d0f352ff23f7f1ace");
        pswfversion1.setPsworkflowname("加签");
        pswfversion1.setWfappid(sysInfoProperties.getAppid());
        pswfversion1.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion1.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion1.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion1.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion1.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfas"));
        pswfversion1.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion1.setModuleid("WFAS");
        pswfversion1.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion1DesignFile = new ClassPathResource("workflow/ASWFv1.bpmn");
        InputStream pswfversion1Is = null;
        try {
            pswfversion1Is = pswfversion1DesignFile.getInputStream();
            byte[] pswfversion1Content = new byte[pswfversion1Is.available()];
            pswfversion1Is.read(pswfversion1Content);
            pswfversion1.setFilename(pswfversion1.getPswfversionid() + "ASWFv1.bpmn");
            pswfversion1.setFilecontent(pswfversion1Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion1Is != null) {
                try {
                    pswfversion1Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion1Is = null;
        }
        pswfversions.add(pswfversion1);
        PSWFVersion pswfversion2 = new PSWFVersion();
        pswfversion2.setPswfversionid("0ccd959364f2eae9f3054e7fc56df96d");
        pswfversion2.setPswfversionname("业务协作审批 v1");
        pswfversion2.setLogicname("业务协作审批 v1");
        pswfversion2.setPsworkflowid("d95fe2a1d9f0fffd81b11a864f2fc7a7");
        pswfversion2.setPsworkflowname("业务协作审批");
        pswfversion2.setWfappid(sysInfoProperties.getAppid());
        pswfversion2.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion2.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion2.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion2.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion2.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfbcs"));
        pswfversion2.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion2.setModuleid("WFBC");
        pswfversion2.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion2DesignFile = new ClassPathResource("workflow/PSWFv1.bpmn");
        InputStream pswfversion2Is = null;
        try {
            pswfversion2Is = pswfversion2DesignFile.getInputStream();
            byte[] pswfversion2Content = new byte[pswfversion2Is.available()];
            pswfversion2Is.read(pswfversion2Content);
            pswfversion2.setFilename(pswfversion2.getPswfversionid() + "PSWFv1.bpmn");
            pswfversion2.setFilecontent(pswfversion2Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion2Is != null) {
                try {
                    pswfversion2Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion2Is = null;
        }
        pswfversions.add(pswfversion2);
        PSWFVersion pswfversion3 = new PSWFVersion();
        pswfversion3.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfversion3.setPswfversionname("重要事项审批 v1");
        pswfversion3.setLogicname("重要事项审批 v1");
        pswfversion3.setPsworkflowid("49cfb692bde2ae6d258b26681452fb57");
        pswfversion3.setPsworkflowname("重要事项审批");
        pswfversion3.setWfappid(sysInfoProperties.getAppid());
        pswfversion3.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion3.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion3.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion3.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion3.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfims"));
        pswfversion3.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion3.setModuleid("WFIM");
        pswfversion3.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion3DesignFile = new ClassPathResource("workflow/IMWFv1.bpmn");
        InputStream pswfversion3Is = null;
        try {
            pswfversion3Is = pswfversion3DesignFile.getInputStream();
            byte[] pswfversion3Content = new byte[pswfversion3Is.available()];
            pswfversion3Is.read(pswfversion3Content);
            pswfversion3.setFilename(pswfversion3.getPswfversionid() + "IMWFv1.bpmn");
            pswfversion3.setFilecontent(pswfversion3Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion3Is != null) {
                try {
                    pswfversion3Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion3Is = null;
        }
        pswfversions.add(pswfversion3);
        uniWFFeignClient.registPSWFVersion(pswfversions);
    }

    /**
     * 注册流程处理
     */
    private void registWFProcess() {
        List<PSWFProcess> pswfprocesses = new ArrayList<PSWFProcess>();
        PSWFProcess pswfprocess0 = new PSWFProcess();
        pswfprocess0.setPswfprocessid("37f5d9f1e5651c2441cb563c0dd6b130");
        pswfprocess0.setPswfprocessname("结束");
        pswfprocess0.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswfprocess0.setPswfversionname("部门内审核 v1");
        pswfprocess0.setWfprocesstype("END");
        pswfprocess0.setWfstepvalue("");
        pswfprocesses.add(pswfprocess0);
        PSWFProcess pswfprocess1 = new PSWFProcess();
        pswfprocess1.setPswfprocessid("032a192bf601e3728492a0ca757bc599");
        pswfprocess1.setPswfprocessname("相关人员审批");
        pswfprocess1.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswfprocess1.setPswfversionname("部门内审核 v1");
        pswfprocess1.setWfprocesstype("INTERACTIVE");
        pswfprocess1.setWfstepvalue("10");
        pswfprocess1.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess1);
        PSWFProcess pswfprocess2 = new PSWFProcess();
        pswfprocess2.setPswfprocessid("431eb0b7792baedbe404f95938b2a4ff");
        pswfprocess2.setPswfprocessname("部门领导审批");
        pswfprocess2.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswfprocess2.setPswfversionname("部门内审核 v1");
        pswfprocess2.setWfprocesstype("INTERACTIVE");
        pswfprocess2.setWfstepvalue("20");
        pswfprocess2.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess2);
        PSWFProcess pswfprocess3 = new PSWFProcess();
        pswfprocess3.setPswfprocessid("84e12275f614cd358c92e71d377f9590");
        pswfprocess3.setPswfprocessname("开始");
        pswfprocess3.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswfprocess3.setPswfversionname("部门内审核 v1");
        pswfprocess3.setWfprocesstype("START");
        pswfprocess3.setWfstepvalue("");
        pswfprocesses.add(pswfprocess3);
        PSWFProcess pswfprocess4 = new PSWFProcess();
        pswfprocess4.setPswfprocessid("294ff50372539a051471f74d70e5aabc");
        pswfprocess4.setPswfprocessname("处理");
        pswfprocess4.setPswfversionid("4d2a2d866e44aa62df80b5521e0f01d7");
        pswfprocess4.setPswfversionname("加签 v1");
        pswfprocess4.setWfprocesstype("START");
        pswfprocess4.setWfstepvalue("");
        pswfprocesses.add(pswfprocess4);
        PSWFProcess pswfprocess5 = new PSWFProcess();
        pswfprocess5.setPswfprocessid("626a68ec6377923a925322edc502388f");
        pswfprocess5.setPswfprocessname("加签");
        pswfprocess5.setPswfversionid("4d2a2d866e44aa62df80b5521e0f01d7");
        pswfprocess5.setPswfversionname("加签 v1");
        pswfprocess5.setWfprocesstype("INTERACTIVE");
        pswfprocess5.setWfstepvalue("10");
        pswfprocess5.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess5);
        PSWFProcess pswfprocess6 = new PSWFProcess();
        pswfprocess6.setPswfprocessid("b0f9f538a62566169c1eb9748a73320a");
        pswfprocess6.setPswfprocessname("处理");
        pswfprocess6.setPswfversionid("4d2a2d866e44aa62df80b5521e0f01d7");
        pswfprocess6.setPswfversionname("加签 v1");
        pswfprocess6.setWfprocesstype("END");
        pswfprocess6.setWfstepvalue("");
        pswfprocesses.add(pswfprocess6);
        PSWFProcess pswfprocess7 = new PSWFProcess();
        pswfprocess7.setPswfprocessid("4f711c134329a653331e2f900ed0e87d");
        pswfprocess7.setPswfprocessname("结束");
        pswfprocess7.setPswfversionid("0ccd959364f2eae9f3054e7fc56df96d");
        pswfprocess7.setPswfversionname("业务协作审批 v1");
        pswfprocess7.setWfprocesstype("END");
        pswfprocess7.setWfstepvalue("");
        pswfprocesses.add(pswfprocess7);
        PSWFProcess pswfprocess8 = new PSWFProcess();
        pswfprocess8.setPswfprocessid("4622eb3256c4b71dd6758818fcf53738");
        pswfprocess8.setPswfprocessname("开始");
        pswfprocess8.setPswfversionid("0ccd959364f2eae9f3054e7fc56df96d");
        pswfprocess8.setPswfversionname("业务协作审批 v1");
        pswfprocess8.setWfprocesstype("START");
        pswfprocess8.setWfstepvalue("");
        pswfprocesses.add(pswfprocess8);
        PSWFProcess pswfprocess9 = new PSWFProcess();
        pswfprocess9.setPswfprocessid("66c29d7e843e603e5e2aee546c85173e");
        pswfprocess9.setPswfprocessname("部门领导审批");
        pswfprocess9.setPswfversionid("0ccd959364f2eae9f3054e7fc56df96d");
        pswfprocess9.setPswfversionname("业务协作审批 v1");
        pswfprocess9.setWfprocesstype("INTERACTIVE");
        pswfprocess9.setWfstepvalue("10");
        pswfprocess9.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess9);
        PSWFProcess pswfprocess10 = new PSWFProcess();
        pswfprocess10.setPswfprocessid("4fccec9edcc7216d99e2593c3a83c857");
        pswfprocess10.setPswfprocessname("判断是否需要上级");
        pswfprocess10.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess10.setPswfversionname("重要事项审批 v1");
        pswfprocess10.setWfprocesstype("EXCLUSIVEGATEWAY");
        pswfprocess10.setWfstepvalue("");
        pswfprocesses.add(pswfprocess10);
        PSWFProcess pswfprocess11 = new PSWFProcess();
        pswfprocess11.setPswfprocessid("df657712f846983d619bb676fa117423");
        pswfprocess11.setPswfprocessname("首席风险官审核");
        pswfprocess11.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess11.setPswfversionname("重要事项审批 v1");
        pswfprocess11.setWfprocesstype("INTERACTIVE");
        pswfprocess11.setWfstepvalue("80");
        pswfprocess11.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess11);
        PSWFProcess pswfprocess12 = new PSWFProcess();
        pswfprocess12.setPswfprocessid("18efe0796811d556bef82402f2177d6d");
        pswfprocess12.setPswfprocessname("开始");
        pswfprocess12.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess12.setPswfversionname("重要事项审批 v1");
        pswfprocess12.setWfprocesstype("START");
        pswfprocess12.setWfstepvalue("");
        pswfprocesses.add(pswfprocess12);
        PSWFProcess pswfprocess13 = new PSWFProcess();
        pswfprocess13.setPswfprocessid("76309e6522c201a6d012e8cabceb7f52");
        pswfprocess13.setPswfprocessname("合规总监审批");
        pswfprocess13.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess13.setPswfversionname("重要事项审批 v1");
        pswfprocess13.setWfprocesstype("INTERACTIVE");
        pswfprocess13.setWfstepvalue("90");
        pswfprocess13.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess13);
        PSWFProcess pswfprocess14 = new PSWFProcess();
        pswfprocess14.setPswfprocessid("24fb13817c4bc47b2cfd21706aae582d");
        pswfprocess14.setPswfprocessname("部门会签");
        pswfprocess14.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess14.setPswfversionname("重要事项审批 v1");
        pswfprocess14.setWfprocesstype("INTERACTIVE");
        pswfprocess14.setWfstepvalue("40");
        pswfprocess14.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess14);
        PSWFProcess pswfprocess15 = new PSWFProcess();
        pswfprocess15.setPswfprocessid("36a4e165999a9d40be83bcb803ffe6db");
        pswfprocess15.setPswfprocessname("上级部门审核");
        pswfprocess15.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess15.setPswfversionname("重要事项审批 v1");
        pswfprocess15.setTargetpswfid("7ba93f6994808554d57fd44f804ae8a2");
        pswfprocess15.setTargetpswfname("部门内审核");
        pswfprocess15.setWfprocesstype("CALLORGACTIVITY");
        pswfprocess15.setWfstepvalue("20");
        pswfprocesses.add(pswfprocess15);
        PSWFProcess pswfprocess16 = new PSWFProcess();
        pswfprocess16.setPswfprocessid("521a22059058b749172dc7f364f8a318");
        pswfprocess16.setPswfprocessname("部门内审核");
        pswfprocess16.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess16.setPswfversionname("重要事项审批 v1");
        pswfprocess16.setTargetpswfid("7ba93f6994808554d57fd44f804ae8a2");
        pswfprocess16.setTargetpswfname("部门内审核");
        pswfprocess16.setWfprocesstype("CALLORGACTIVITY");
        pswfprocess16.setWfstepvalue("10");
        pswfprocesses.add(pswfprocess16);
        PSWFProcess pswfprocess17 = new PSWFProcess();
        pswfprocess17.setPswfprocessid("2995d4d48f85cf045d25148baddbbd60");
        pswfprocess17.setPswfprocessname("跨公司会签");
        pswfprocess17.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess17.setPswfversionname("重要事项审批 v1");
        pswfprocess17.setWfprocesstype("INTERACTIVE");
        pswfprocess17.setWfstepvalue("50");
        pswfprocess17.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess17);
        PSWFProcess pswfprocess18 = new PSWFProcess();
        pswfprocess18.setPswfprocessid("d328f061b4c1af5c66e60cadaea856d4");
        pswfprocess18.setPswfprocessname("分送");
        pswfprocess18.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess18.setPswfversionname("重要事项审批 v1");
        pswfprocess18.setWfprocesstype("INTERACTIVE");
        pswfprocess18.setWfstepvalue("30");
        pswfprocess18.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess18);
        PSWFProcess pswfprocess19 = new PSWFProcess();
        pswfprocess19.setPswfprocessid("b0a1f80cf10c4c859b7cd90b85f988c7");
        pswfprocess19.setPswfprocessname("结束");
        pswfprocess19.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess19.setPswfversionname("重要事项审批 v1");
        pswfprocess19.setWfprocesstype("END");
        pswfprocess19.setWfstepvalue("");
        pswfprocesses.add(pswfprocess19);
        PSWFProcess pswfprocess20 = new PSWFProcess();
        pswfprocess20.setPswfprocessid("3e6ca0dd7dcd9455464ad400cc0fa7ff");
        pswfprocess20.setPswfprocessname("业务协作");
        pswfprocess20.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswfprocess20.setPswfversionname("重要事项审批 v1");
        pswfprocess20.setWfprocesstype("EMBED");
        pswfprocess20.setWfstepvalue("70");
        pswfprocesses.add(pswfprocess20);
        uniWFFeignClient.registPSWFProcess(pswfprocesses);
    }

    /**
     * 注册流程连接
     */
    private void registWFLink() {
        List<PSWFLink> pswflinks = new ArrayList<PSWFLink>();
        PSWFLink pswflink0 = new PSWFLink();
        pswflink0.setPswflinkid("8e732b1b30bac57be044c9b419fc87cc");
        pswflink0.setPswflinkname("C73");
        pswflink0.setLogicname("审核通过");
        pswflink0.setFrompswfprocid("032a192bf601e3728492a0ca757bc599");
        pswflink0.setTopswfprocid("431eb0b7792baedbe404f95938b2a4ff");
        pswflink0.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswflink0.setPswfversionname("部门内审核 v1");
        pswflinks.add(pswflink0);
        PSWFLink pswflink1 = new PSWFLink();
        pswflink1.setPswflinkid("126603f18773a9cd1b53bec25df19307");
        pswflink1.setPswflinkname("C63");
        pswflink1.setLogicname("审核通过");
        pswflink1.setFrompswfprocid("431eb0b7792baedbe404f95938b2a4ff");
        pswflink1.setTopswfprocid("37f5d9f1e5651c2441cb563c0dd6b130");
        pswflink1.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswflink1.setPswfversionname("部门内审核 v1");
        pswflinks.add(pswflink1);
        PSWFLink pswflink2 = new PSWFLink();
        pswflink2.setPswflinkid("295fdaa231b8746509cd8332dca1cc9f");
        pswflink2.setPswflinkname("连接65");
        pswflink2.setLogicname("");
        pswflink2.setFrompswfprocid("84e12275f614cd358c92e71d377f9590");
        pswflink2.setTopswfprocid("032a192bf601e3728492a0ca757bc599");
        pswflink2.setPswfversionid("c6d90f402346046491d30dba90a3c561");
        pswflink2.setPswfversionname("部门内审核 v1");
        pswflinks.add(pswflink2);
        PSWFLink pswflink3 = new PSWFLink();
        pswflink3.setPswflinkid("739c466c07bbc7e7dd2aab3258c38ec1");
        pswflink3.setPswflinkname("连接75");
        pswflink3.setLogicname("");
        pswflink3.setFrompswfprocid("294ff50372539a051471f74d70e5aabc");
        pswflink3.setTopswfprocid("626a68ec6377923a925322edc502388f");
        pswflink3.setPswfversionid("4d2a2d866e44aa62df80b5521e0f01d7");
        pswflink3.setPswfversionname("加签 v1");
        pswflinks.add(pswflink3);
        PSWFLink pswflink4 = new PSWFLink();
        pswflink4.setPswflinkid("51437022aba36c0aa362e7b74024a7d2");
        pswflink4.setPswflinkname("C3598");
        pswflink4.setLogicname("提交");
        pswflink4.setFrompswfprocid("626a68ec6377923a925322edc502388f");
        pswflink4.setTopswfprocid("b0f9f538a62566169c1eb9748a73320a");
        pswflink4.setPswfversionid("4d2a2d866e44aa62df80b5521e0f01d7");
        pswflink4.setPswfversionname("加签 v1");
        pswflinks.add(pswflink4);
        PSWFLink pswflink5 = new PSWFLink();
        pswflink5.setPswflinkid("5a6d35a9c94b2f3a88150c4353042cc5");
        pswflink5.setPswflinkname("C43");
        pswflink5.setLogicname("操作43");
        pswflink5.setFrompswfprocid("66c29d7e843e603e5e2aee546c85173e");
        pswflink5.setTopswfprocid("4f711c134329a653331e2f900ed0e87d");
        pswflink5.setPswfversionid("0ccd959364f2eae9f3054e7fc56df96d");
        pswflink5.setPswfversionname("业务协作审批 v1");
        pswflinks.add(pswflink5);
        PSWFLink pswflink6 = new PSWFLink();
        pswflink6.setPswflinkid("27f394273823f8febe5aba467115146d");
        pswflink6.setPswflinkname("连接5");
        pswflink6.setLogicname("");
        pswflink6.setFrompswfprocid("4622eb3256c4b71dd6758818fcf53738");
        pswflink6.setTopswfprocid("66c29d7e843e603e5e2aee546c85173e");
        pswflink6.setPswfversionid("0ccd959364f2eae9f3054e7fc56df96d");
        pswflink6.setPswfversionname("业务协作审批 v1");
        pswflinks.add(pswflink6);
        PSWFLink pswflink7 = new PSWFLink();
        pswflink7.setPswflinkid("0300034ce711a165393fe186340398d9");
        pswflink7.setPswflinkname("C35");
        pswflink7.setLogicname("提交");
        pswflink7.setFrompswfprocid("24fb13817c4bc47b2cfd21706aae582d");
        pswflink7.setTopswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink7.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink7.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink7);
        PSWFLink pswflink8 = new PSWFLink();
        pswflink8.setPswflinkid("3dfa84d8355dc1569df019722022f440");
        pswflink8.setPswflinkname("C4158");
        pswflink8.setLogicname("提交");
        pswflink8.setFrompswfprocid("2995d4d48f85cf045d25148baddbbd60");
        pswflink8.setTopswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink8.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink8.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink8);
        PSWFLink pswflink9 = new PSWFLink();
        pswflink9.setPswflinkid("5f4d6b5b95a5a8a589a41ae0c67646e9");
        pswflink9.setPswflinkname("C34");
        pswflink9.setLogicname("操作34");
        pswflink9.setFrompswfprocid("3e6ca0dd7dcd9455464ad400cc0fa7ff");
        pswflink9.setTopswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink9.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink9.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink9);
        PSWFLink pswflink10 = new PSWFLink();
        pswflink10.setPswflinkid("559a8b1af3379cf556f6f92d18c15c69");
        pswflink10.setPswflinkname("连接2");
        pswflink10.setLogicname("");
        pswflink10.setFrompswfprocid("18efe0796811d556bef82402f2177d6d");
        pswflink10.setTopswfprocid("521a22059058b749172dc7f364f8a318");
        pswflink10.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink10.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink10);
        PSWFLink pswflink11 = new PSWFLink();
        pswflink11.setPswflinkid("d6e2b920492627c711bfddd0fe324197");
        pswflink11.setPswflinkname("C59");
        pswflink11.setLogicname("操作59");
        pswflink11.setFrompswfprocid("521a22059058b749172dc7f364f8a318");
        pswflink11.setTopswfprocid("4fccec9edcc7216d99e2593c3a83c857");
        pswflink11.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink11.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink11);
        PSWFLink pswflink12 = new PSWFLink();
        pswflink12.setPswflinkid("f345076c3e7e83e7e4fa28609a7284ae");
        pswflink12.setPswflinkname("C84");
        pswflink12.setLogicname("操作84");
        pswflink12.setFrompswfprocid("36a4e165999a9d40be83bcb803ffe6db");
        pswflink12.setTopswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink12.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink12.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink12);
        PSWFLink pswflink13 = new PSWFLink();
        pswflink13.setPswflinkid("479f7720515baad4c60d07360f89732f");
        pswflink13.setPswflinkname("C66");
        pswflink13.setLogicname("送会签");
        pswflink13.setFrompswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink13.setTopswfprocid("24fb13817c4bc47b2cfd21706aae582d");
        pswflink13.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink13.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink13);
        PSWFLink pswflink14 = new PSWFLink();
        pswflink14.setPswflinkid("5335096900f69aa0ebdc4e5ba89bd588");
        pswflink14.setPswflinkname("C47");
        pswflink14.setLogicname("送首席风险官审核");
        pswflink14.setFrompswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink14.setTopswfprocid("df657712f846983d619bb676fa117423");
        pswflink14.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink14.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink14);
        PSWFLink pswflink15 = new PSWFLink();
        pswflink15.setPswflinkid("964ce51fda67d5677f7f8ff5ee2955fe");
        pswflink15.setPswflinkname("C37");
        pswflink15.setLogicname("送跨公司会签");
        pswflink15.setFrompswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink15.setTopswfprocid("2995d4d48f85cf045d25148baddbbd60");
        pswflink15.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink15.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink15);
        PSWFLink pswflink16 = new PSWFLink();
        pswflink16.setPswflinkid("1c9e532019ad31108629aaec0b834ba0");
        pswflink16.setPswflinkname("C44");
        pswflink16.setLogicname("送合规总监审批");
        pswflink16.setFrompswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink16.setTopswfprocid("76309e6522c201a6d012e8cabceb7f52");
        pswflink16.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink16.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink16);
        PSWFLink pswflink17 = new PSWFLink();
        pswflink17.setPswflinkid("8344dd0016154c3de6b23f15424c746d");
        pswflink17.setPswflinkname("C85");
        pswflink17.setLogicname("送业务协作");
        pswflink17.setFrompswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink17.setTopswfprocid("3e6ca0dd7dcd9455464ad400cc0fa7ff");
        pswflink17.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink17.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink17);
        PSWFLink pswflink18 = new PSWFLink();
        pswflink18.setPswflinkid("38416ad6f691e7753d78906bd7a346f9");
        pswflink18.setPswflinkname("C8501");
        pswflink18.setLogicname("送办结");
        pswflink18.setFrompswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink18.setTopswfprocid("b0a1f80cf10c4c859b7cd90b85f988c7");
        pswflink18.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink18.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink18);
        PSWFLink pswflink19 = new PSWFLink();
        pswflink19.setPswflinkid("c418cd6fa67c06d194d2975c7014326c");
        pswflink19.setPswflinkname("C893");
        pswflink19.setLogicname("");
        pswflink19.setFrompswfprocid("4fccec9edcc7216d99e2593c3a83c857");
        pswflink19.setTopswfprocid("36a4e165999a9d40be83bcb803ffe6db");
        pswflink19.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink19.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink19);
        PSWFLink pswflink20 = new PSWFLink();
        pswflink20.setPswflinkid("e4759521db013d70687d552aee9dcd73");
        pswflink20.setPswflinkname("C7118");
        pswflink20.setLogicname("");
        pswflink20.setFrompswfprocid("4fccec9edcc7216d99e2593c3a83c857");
        pswflink20.setTopswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink20.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink20.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink20);
        PSWFLink pswflink21 = new PSWFLink();
        pswflink21.setPswflinkid("3926f62b16765bcd8ab513f866637670");
        pswflink21.setPswflinkname("C297");
        pswflink21.setLogicname("提交");
        pswflink21.setFrompswfprocid("76309e6522c201a6d012e8cabceb7f52");
        pswflink21.setTopswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink21.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink21.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink21);
        PSWFLink pswflink22 = new PSWFLink();
        pswflink22.setPswflinkid("f3bb49f211da063c727ead28e886eace");
        pswflink22.setPswflinkname("C9391");
        pswflink22.setLogicname("提交");
        pswflink22.setFrompswfprocid("df657712f846983d619bb676fa117423");
        pswflink22.setTopswfprocid("d328f061b4c1af5c66e60cadaea856d4");
        pswflink22.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        pswflink22.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink22);
        uniWFFeignClient.registPSWFLink(pswflinks);
    }

    /**
     * 注册流程处理角色
     */
    private void registWFProcRole() {
        List<PSWFProcRole> pswfprocroles = new ArrayList<PSWFProcRole>();
        JSONObject data0 = new JSONObject();
        data0.put("pswfprocessid", "37f5d9f1e5651c2441cb563c0dd6b130");
        uniWFFeignClient.clearPSWFProcRole(data0);
        JSONObject data1 = new JSONObject();
        data1.put("pswfprocessid", "032a192bf601e3728492a0ca757bc599");
        uniWFFeignClient.clearPSWFProcRole(data1);
        PSWFProcRole pswfprocrole0 = new PSWFProcRole();
        pswfprocrole0.setPswfprocessid("032a192bf601e3728492a0ca757bc599");
        pswfprocrole0.setPswfprocessname("相关人员审批");
        pswfprocrole0.setPswfprocroleid("33c54f3d794afded6a00acf425fcaff8");
        pswfprocrole0.setPswfprocrolename("[当前数据属性]");
        pswfprocrole0.setPswfprocrolename("[当前数据属性]NGSHIDS");
        pswfprocrole0.setUdfield("NGSHIDS");
        pswfprocrole0.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole0);
        JSONObject data2 = new JSONObject();
        data2.put("pswfprocessid", "431eb0b7792baedbe404f95938b2a4ff");
        uniWFFeignClient.clearPSWFProcRole(data2);
        PSWFProcRole pswfprocrole1 = new PSWFProcRole();
        pswfprocrole1.setPswfprocessid("431eb0b7792baedbe404f95938b2a4ff");
        pswfprocrole1.setPswfprocessname("部门领导审批");
        pswfprocrole1.setPswfprocroleid("9d6289f9d132a3545506c50930e3a7d6");
        pswfprocrole1.setPswfprocrolename("[当前数据属性]");
        pswfprocrole1.setPswfprocrolename("[当前数据属性]BMLDIDS");
        pswfprocrole1.setUdfield("BMLDIDS");
        pswfprocrole1.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole1);
        JSONObject data3 = new JSONObject();
        data3.put("pswfprocessid", "84e12275f614cd358c92e71d377f9590");
        uniWFFeignClient.clearPSWFProcRole(data3);
        JSONObject data4 = new JSONObject();
        data4.put("pswfprocessid", "294ff50372539a051471f74d70e5aabc");
        uniWFFeignClient.clearPSWFProcRole(data4);
        JSONObject data5 = new JSONObject();
        data5.put("pswfprocessid", "626a68ec6377923a925322edc502388f");
        uniWFFeignClient.clearPSWFProcRole(data5);
        JSONObject data6 = new JSONObject();
        data6.put("pswfprocessid", "b0f9f538a62566169c1eb9748a73320a");
        uniWFFeignClient.clearPSWFProcRole(data6);
        JSONObject data7 = new JSONObject();
        data7.put("pswfprocessid", "4f711c134329a653331e2f900ed0e87d");
        uniWFFeignClient.clearPSWFProcRole(data7);
        JSONObject data8 = new JSONObject();
        data8.put("pswfprocessid", "4622eb3256c4b71dd6758818fcf53738");
        uniWFFeignClient.clearPSWFProcRole(data8);
        JSONObject data9 = new JSONObject();
        data9.put("pswfprocessid", "66c29d7e843e603e5e2aee546c85173e");
        uniWFFeignClient.clearPSWFProcRole(data9);
        PSWFProcRole pswfprocrole2 = new PSWFProcRole();
        pswfprocrole2.setPswfprocessid("66c29d7e843e603e5e2aee546c85173e");
        pswfprocrole2.setPswfprocessname("部门领导审批");
        pswfprocrole2.setPswfprocroleid("5f5584ee1555ada951f5b17d4baea6df");
        pswfprocrole2.setPswfprocrolename("[当前数据属性]");
        pswfprocrole2.setPswfprocrolename("[当前数据属性]BMLDIDS");
        pswfprocrole2.setUdfield("BMLDIDS");
        pswfprocrole2.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole2);
        JSONObject data10 = new JSONObject();
        data10.put("pswfprocessid", "4fccec9edcc7216d99e2593c3a83c857");
        uniWFFeignClient.clearPSWFProcRole(data10);
        JSONObject data11 = new JSONObject();
        data11.put("pswfprocessid", "df657712f846983d619bb676fa117423");
        uniWFFeignClient.clearPSWFProcRole(data11);
        PSWFProcRole pswfprocrole3 = new PSWFProcRole();
        pswfprocrole3.setPswfprocessid("df657712f846983d619bb676fa117423");
        pswfprocrole3.setPswfprocessname("首席风险官审核");
        pswfprocrole3.setPswfprocroleid("318f5d97d04daa464b5e77b09e131c83");
        pswfprocrole3.setPswfprocrolename("首席风险官");
        pswfprocrole3.setPswfroleid("b54aceeaef2df5de5492fe9f091b09b2");
        pswfprocrole3.setPswfrolename("首席风险官");
        pswfprocrole3.setPswfprocrolename("首席风险官");
        pswfprocrole3.setUdfield("");
        pswfprocrole3.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole3);
        JSONObject data12 = new JSONObject();
        data12.put("pswfprocessid", "18efe0796811d556bef82402f2177d6d");
        uniWFFeignClient.clearPSWFProcRole(data12);
        JSONObject data13 = new JSONObject();
        data13.put("pswfprocessid", "76309e6522c201a6d012e8cabceb7f52");
        uniWFFeignClient.clearPSWFProcRole(data13);
        PSWFProcRole pswfprocrole4 = new PSWFProcRole();
        pswfprocrole4.setPswfprocessid("76309e6522c201a6d012e8cabceb7f52");
        pswfprocrole4.setPswfprocessname("合规总监审批");
        pswfprocrole4.setPswfprocroleid("37e86c3eda3041a064c2e7d49e64309b");
        pswfprocrole4.setPswfprocrolename("合规总监");
        pswfprocrole4.setPswfroleid("431f4105523a30fbf66e1c6a40ce51cc");
        pswfprocrole4.setPswfrolename("合规总监");
        pswfprocrole4.setPswfprocrolename("合规总监");
        pswfprocrole4.setUdfield("");
        pswfprocrole4.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole4);
        JSONObject data14 = new JSONObject();
        data14.put("pswfprocessid", "24fb13817c4bc47b2cfd21706aae582d");
        uniWFFeignClient.clearPSWFProcRole(data14);
        PSWFProcRole pswfprocrole5 = new PSWFProcRole();
        pswfprocrole5.setPswfprocessid("24fb13817c4bc47b2cfd21706aae582d");
        pswfprocrole5.setPswfprocessname("部门会签");
        pswfprocrole5.setPswfprocroleid("cdb6751176f49aa58e93945192c751d0");
        pswfprocrole5.setPswfprocrolename("[当前数据属性]");
        pswfprocrole5.setPswfprocrolename("[当前数据属性]HQBMIDS");
        pswfprocrole5.setUdfield("HQBMIDS");
        pswfprocrole5.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole5);
        JSONObject data15 = new JSONObject();
        data15.put("pswfprocessid", "36a4e165999a9d40be83bcb803ffe6db");
        uniWFFeignClient.clearPSWFProcRole(data15);
        PSWFProcRole pswfprocrole6 = new PSWFProcRole();
        pswfprocrole6.setPswfprocessid("36a4e165999a9d40be83bcb803ffe6db");
        pswfprocrole6.setPswfprocessname("上级部门审核");
        pswfprocrole6.setPswfprocroleid("8c3c17625b7c7709d758a7ce184d59e3");
        pswfprocrole6.setPswfprocrolename("当前父部门");
        pswfprocrole6.setPswfroleid("af365d7d3bc8e5f87d20a05f625fb593");
        pswfprocrole6.setPswfrolename("当前父部门");
        pswfprocrole6.setPswfprocrolename("当前父部门");
        pswfprocrole6.setUdfield("");
        pswfprocrole6.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole6);
        JSONObject data16 = new JSONObject();
        data16.put("pswfprocessid", "521a22059058b749172dc7f364f8a318");
        uniWFFeignClient.clearPSWFProcRole(data16);
        PSWFProcRole pswfprocrole7 = new PSWFProcRole();
        pswfprocrole7.setPswfprocessid("521a22059058b749172dc7f364f8a318");
        pswfprocrole7.setPswfprocessname("部门内审核");
        pswfprocrole7.setPswfprocroleid("a282037eab555656815546354c209a7d");
        pswfprocrole7.setPswfprocrolename("当前部门");
        pswfprocrole7.setPswfroleid("5d0b93fa52d3ab0d048652b80b67cb6e");
        pswfprocrole7.setPswfrolename("当前部门");
        pswfprocrole7.setPswfprocrolename("当前部门");
        pswfprocrole7.setUdfield("");
        pswfprocrole7.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole7);
        JSONObject data17 = new JSONObject();
        data17.put("pswfprocessid", "2995d4d48f85cf045d25148baddbbd60");
        uniWFFeignClient.clearPSWFProcRole(data17);
        PSWFProcRole pswfprocrole8 = new PSWFProcRole();
        pswfprocrole8.setPswfprocessid("2995d4d48f85cf045d25148baddbbd60");
        pswfprocrole8.setPswfprocessname("跨公司会签");
        pswfprocrole8.setPswfprocroleid("672e3766aebc3c21e487df5cf8888abd");
        pswfprocrole8.setPswfprocrolename("[当前数据属性]");
        pswfprocrole8.setPswfprocrolename("[当前数据属性]KGSBMIDS");
        pswfprocrole8.setUdfield("KGSBMIDS");
        pswfprocrole8.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole8);
        JSONObject data18 = new JSONObject();
        data18.put("pswfprocessid", "d328f061b4c1af5c66e60cadaea856d4");
        uniWFFeignClient.clearPSWFProcRole(data18);
        PSWFProcRole pswfprocrole9 = new PSWFProcRole();
        pswfprocrole9.setPswfprocessid("d328f061b4c1af5c66e60cadaea856d4");
        pswfprocrole9.setPswfprocessname("分送");
        pswfprocrole9.setPswfprocroleid("4c3cf320280ff0b2a5f69f6da94655f4");
        pswfprocrole9.setPswfprocrolename("分送人");
        pswfprocrole9.setPswfroleid("c24e4bdc1b87ba82187623202a70a603");
        pswfprocrole9.setPswfrolename("分送人");
        pswfprocrole9.setPswfprocrolename("分送人");
        pswfprocrole9.setUdfield("");
        pswfprocrole9.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole9);
        JSONObject data19 = new JSONObject();
        data19.put("pswfprocessid", "b0a1f80cf10c4c859b7cd90b85f988c7");
        uniWFFeignClient.clearPSWFProcRole(data19);
        JSONObject data20 = new JSONObject();
        data20.put("pswfprocessid", "3e6ca0dd7dcd9455464ad400cc0fa7ff");
        uniWFFeignClient.clearPSWFProcRole(data20);
        uniWFFeignClient.registPSWFProcRole(pswfprocroles);
    }

    /**
     * 注册嵌套流程
     */
    private void registPSWFProcSubWF() {
        List<PSWFProcSubWF> pswfprocsubwfs = new ArrayList<PSWFProcSubWF>();
        JSONObject data0 = new JSONObject();
        data0.put("pswfprocessid", "37f5d9f1e5651c2441cb563c0dd6b130");
        uniWFFeignClient.clearPSWFProcSubWF(data0);
        JSONObject data1 = new JSONObject();
        data1.put("pswfprocessid", "032a192bf601e3728492a0ca757bc599");
        uniWFFeignClient.clearPSWFProcSubWF(data1);
        JSONObject data2 = new JSONObject();
        data2.put("pswfprocessid", "431eb0b7792baedbe404f95938b2a4ff");
        uniWFFeignClient.clearPSWFProcSubWF(data2);
        JSONObject data3 = new JSONObject();
        data3.put("pswfprocessid", "84e12275f614cd358c92e71d377f9590");
        uniWFFeignClient.clearPSWFProcSubWF(data3);
        JSONObject data4 = new JSONObject();
        data4.put("pswfprocessid", "294ff50372539a051471f74d70e5aabc");
        uniWFFeignClient.clearPSWFProcSubWF(data4);
        JSONObject data5 = new JSONObject();
        data5.put("pswfprocessid", "626a68ec6377923a925322edc502388f");
        uniWFFeignClient.clearPSWFProcSubWF(data5);
        JSONObject data6 = new JSONObject();
        data6.put("pswfprocessid", "b0f9f538a62566169c1eb9748a73320a");
        uniWFFeignClient.clearPSWFProcSubWF(data6);
        JSONObject data7 = new JSONObject();
        data7.put("pswfprocessid", "4f711c134329a653331e2f900ed0e87d");
        uniWFFeignClient.clearPSWFProcSubWF(data7);
        JSONObject data8 = new JSONObject();
        data8.put("pswfprocessid", "4622eb3256c4b71dd6758818fcf53738");
        uniWFFeignClient.clearPSWFProcSubWF(data8);
        JSONObject data9 = new JSONObject();
        data9.put("pswfprocessid", "66c29d7e843e603e5e2aee546c85173e");
        uniWFFeignClient.clearPSWFProcSubWF(data9);
        JSONObject data10 = new JSONObject();
        data10.put("pswfprocessid", "4fccec9edcc7216d99e2593c3a83c857");
        uniWFFeignClient.clearPSWFProcSubWF(data10);
        JSONObject data11 = new JSONObject();
        data11.put("pswfprocessid", "df657712f846983d619bb676fa117423");
        uniWFFeignClient.clearPSWFProcSubWF(data11);
        JSONObject data12 = new JSONObject();
        data12.put("pswfprocessid", "18efe0796811d556bef82402f2177d6d");
        uniWFFeignClient.clearPSWFProcSubWF(data12);
        JSONObject data13 = new JSONObject();
        data13.put("pswfprocessid", "76309e6522c201a6d012e8cabceb7f52");
        uniWFFeignClient.clearPSWFProcSubWF(data13);
        JSONObject data14 = new JSONObject();
        data14.put("pswfprocessid", "24fb13817c4bc47b2cfd21706aae582d");
        uniWFFeignClient.clearPSWFProcSubWF(data14);
        JSONObject data15 = new JSONObject();
        data15.put("pswfprocessid", "36a4e165999a9d40be83bcb803ffe6db");
        uniWFFeignClient.clearPSWFProcSubWF(data15);
        JSONObject data16 = new JSONObject();
        data16.put("pswfprocessid", "521a22059058b749172dc7f364f8a318");
        uniWFFeignClient.clearPSWFProcSubWF(data16);
        JSONObject data17 = new JSONObject();
        data17.put("pswfprocessid", "2995d4d48f85cf045d25148baddbbd60");
        uniWFFeignClient.clearPSWFProcSubWF(data17);
        JSONObject data18 = new JSONObject();
        data18.put("pswfprocessid", "d328f061b4c1af5c66e60cadaea856d4");
        uniWFFeignClient.clearPSWFProcSubWF(data18);
        JSONObject data19 = new JSONObject();
        data19.put("pswfprocessid", "b0a1f80cf10c4c859b7cd90b85f988c7");
        uniWFFeignClient.clearPSWFProcSubWF(data19);
        JSONObject data20 = new JSONObject();
        data20.put("pswfprocessid", "3e6ca0dd7dcd9455464ad400cc0fa7ff");
        uniWFFeignClient.clearPSWFProcSubWF(data20);
        PSWFProcSubWF pswfprocsubwf0 = new PSWFProcSubWF();
        pswfprocsubwf0.setPswfprocsubwfname("业务协作");
        pswfprocsubwf0.setPswfprocsubwfid("e60bed432f525876556ed1093931833c");
        pswfprocsubwf0.setPswfversionid("0ccd959364f2eae9f3054e7fc56df96d");
        pswfprocsubwf0.setPswfprocessid("3e6ca0dd7dcd9455464ad400cc0fa7ff");
        pswfprocsubwf0.setPsworkflowid("d95fe2a1d9f0fffd81b11a864f2fc7a7");
        pswfprocsubwf0.setSubwfdeid("d1a54da97f37e5d110b31724de3916ac");
        pswfprocsubwf0.setSubwfdedataset("Default");
        pswfprocsubwfs.add(pswfprocsubwf0);
        uniWFFeignClient.registPSWFProcSubWF(pswfprocsubwfs);
    }
}
