package com.ibiz.wfweb.htwf.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb.htwf.service.WFASService;
import com.ibiz.wfweb.htwf.domain.WFAS;
import com.ibiz.wfweb.htwf.filter.*;

@RestController
@RequestMapping(value = "")
public class WFASController {
	@Autowired
    WFASService wfasservice;


	@RequestMapping(method = RequestMethod.GET, value = "/wfas/{wfas_id}")
    @PreAuthorize("@wfas_pms.check(#wfas_id,'READ')")
    public ResponseEntity<WFAS> get(@PathVariable("wfas_id") String wfas_id) {
        WFAS wfas = wfasservice.get( wfas_id);
        return ResponseEntity.status(HttpStatus.OK).body(wfas);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/save")
    @PreAuthorize("@wfas_pms.check(#wfas_id,'')")
    public ResponseEntity<WFAS> save(@PathVariable("wfas_id") String wfas_id, @RequestBody WFAS wfas) {
        WFAS wfas2 = wfasservice.save(wfas_id, wfas);
        return ResponseEntity.status(HttpStatus.OK).body(wfas2);
    }

	@RequestMapping(method = RequestMethod.DELETE, value = "/wfas/{wfas_id}")
    @PreAuthorize("@wfas_pms.check(#wfas_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("wfas_id") String wfas_id) {
        boolean b = wfasservice.remove( wfas_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfas/checkkey")
    @PreAuthorize("@wfas_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFAS wfas) {
        boolean b = wfasservice.checkKey(wfas);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/wfas/{wfas_id}")
    @PreAuthorize("@wfas_pms.check(#wfas_id,'UPDATE')")
    public ResponseEntity<WFAS> update(@PathVariable("wfas_id") String wfas_id, @RequestBody WFAS wfas) {
        WFAS wfas2 = wfasservice.update(wfas_id, wfas);
        return ResponseEntity.status(HttpStatus.OK).body(wfas2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/wfas/{wfas_id}")
    @PreAuthorize("@wfas_pms.check(#wfas_id,'UPDATE')")
    public ResponseEntity<WFAS> api_update(@PathVariable("wfas_id") String wfas_id, @RequestBody WFAS wfas) {
        WFAS wfas2 = wfasservice.update(wfas_id, wfas);
        return ResponseEntity.status(HttpStatus.OK).body(wfas2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfas/getdraft")
    @PreAuthorize("@wfas_pms.check('CREATE')")
    public ResponseEntity<WFAS> getDraft() {
        //WFAS wfas = wfasservice.getDraft( wfas_id);
        return ResponseEntity.status(HttpStatus.OK).body(new WFAS());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfas")
    @PreAuthorize("@wfas_pms.check('CREATE')")
    public ResponseEntity<WFAS> create(@RequestBody WFAS wfas) {
        WFAS wfas2 = wfasservice.create(wfas);
        return ResponseEntity.status(HttpStatus.OK).body(wfas2);
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfas/fetchdefault")
    @PreAuthorize("@wfas_pms.check('READ')")
	public ResponseEntity<List<WFAS>> fetchDefault(WFASSearchContext searchContext,Pageable pageable) {
        
        Page<WFAS> page = wfasservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


    /** 工作流行为 **/

    /**
     * 开始流程【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfstart")
    public ResponseEntity<JSONObject> wfStart(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", false);
        if (wfasservice.wfStart(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 开始流程2【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/api/wfas/wfstart")
    public ResponseEntity<JSONObject> wfStart(@RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", true);
        if (wfasservice.wfStart(null, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程处理【WFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfsubmit")
    public ResponseEntity<JSONObject> wfSubmit(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (wfasservice.wfSubmit(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 测试当前用户是否提交过工作流【testUserWFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/testuserwfsubmit")
    public ResponseEntity<Boolean> testUserWFSubmit(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfasservice.testUserWFSubmit(wfas_id, data));
    }

    /**
     * 测试当前用户是否存在工作任务【testUserExistWorklist】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/testuserexistworklist")
    public ResponseEntity<Boolean> testUserExistWorklist(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfasservice.testUserExistWorklist(wfas_id, data));
    }

    /**
     * 流程结束【WFClose】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfclose")
    public ResponseEntity<JSONObject> wfClose(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (wfasservice.wfClose(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程跳转【WFGoto】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfgoto")
    public ResponseEntity<JSONObject> wfGoto(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (wfasservice.wfGoto(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重启【WFRestart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfrestart")
    public ResponseEntity<JSONObject> wfRestart(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (wfasservice.wfRestart(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程撤回【WFRollback】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfrollback")
    public ResponseEntity<JSONObject> wfRollback(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (wfasservice.wfRollback(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程退回【WFSendBack】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfsendback")
    public ResponseEntity<JSONObject> wfSendBack(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (wfasservice.wfSendBack(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重新分配【WFReassign】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfreassign")
    public ResponseEntity<JSONObject> wfReassign(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        if (wfasservice.wfReassign(wfas_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程标记已读【WFMarkRead】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfas/{wfas_id}/wfmarkread")
    public ResponseEntity<Boolean> wfMarkRead(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfasservice.wfMarkRead(wfas_id, data));
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    @RequestMapping(method = RequestMethod.POST, value = "api/wfas/{wfas_id}/wfaction")
    public ResponseEntity<JSONObject> wfAction(@PathVariable("wfas_id") String wfas_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfasservice.wfAction(wfas_id, data));
    }

    /**
     * 获取代理数据【WFGetProxyData】
     */
    @RequestMapping(method = RequestMethod.GET, value = "/wfas/{wfas_id}/wfgetproxydata")
    public ResponseEntity<JSONObject> wfGetProxyData(@PathVariable("wfas_id") String wfas_id) {
        return ResponseEntity.status(HttpStatus.OK).body(wfasservice.wfGetProxyData(wfas_id));
    }


}
