
package com.ibiz.wfweb.ht.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb.ht.domain.BC;
import com.ibiz.wfweb.ht.filter.*;
import com.ibiz.wfweb.ht.feign.BCFeignClient;
import com.ibiz.wfweb.WFWebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.domain.*;

@Service
public class BCService {

    BCFeignClient client;
    @Autowired
    SysInfoProperties sysInfoProperties;

    UniWFClientProperties uniWFClientProperties;

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    public BCService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties, UniWFClientProperties uniWFClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(BCFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(BCFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
        this.uniWFClientProperties = uniWFClientProperties;
		if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    public BC get( String bc_id) {
        return client.get( bc_id);
    }

    public BC getDraft(String bc_id, BC bc) {
        return client.getDraft(bc_id, bc);
    }

	public BC create(BC bc) {
        return client.create(bc);
    }

    public boolean remove( String bc_id) {
        return client.remove( bc_id);
    }

    public BC update(String bc_id, BC bc) {
        return client.update(bc_id, bc);
    }

    public boolean checkKey(BC bc) {
        return client.checkKey(bc);
    }

    public BC save(String bc_id, BC bc) {
        return client.save(bc_id, bc);
    }

	public Page<BC> fetchDefault(BCSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

	public JSONObject wfStart(String bc_id) {
	    PSDataEntity psdataentity = new PSDataEntity();
        psdataentity.setPsdataentityid("d1a54da97f37e5d110b31724de3916ac");
        psdataentity.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity.setPssystemid(sysInfoProperties.getSystemid());
        String uniwfUrl = "http://localhost:8111/";
        if (uniWFClientProperties.getAppUrl() != null && !uniWFClientProperties.getAppUrl().isEmpty()) {
            uniwfUrl = uniWFClientProperties.getAppUrl();
        }
    	JSONObject json = new JSONObject();
    	json.put("url", uniwfUrl
                        + "#/selectindexview/null/pswfversions/null/dataview?customParams=dataentityid:"
                        + psdataentity.getPsdataentityid() + ","
                        + "proxydataid:" + bc_id + ","
                        + "proxymoduleid:BC"
    			);

        return json;
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    public JSONObject wfAction(String bc_id, JSONObject data) {
        if (data == null
            || data.getString("type") == null
            || data.getString("wfinstanceid") == null) {
            System.err.println("传入参数缺失");
            data.put("rst", "0");
            data.put("msg", "传入参数缺失");
            return data;
        }
        String type = data.getString("type");
        String wfinstanceid = data.getString("wfinstanceid");
        String wfstep = data.getString("wfstep");

        // 业务实体
        BC bc = this.get(bc_id);

        WFInstance wfinstance = this.uniWFFeignClient.getWFInstance(wfinstanceid);
        if (wfinstance == null) {
            System.err.println("查询不到流程实例");
            data.put("rst", "0");
            data.put("msg", "查询不到流程实例");
            return data;
        }
        JSONObject psdewfCond = new JSONObject();
        psdewfCond.put("n_psworkflowid_eq", wfinstance.getPsworkflowid());
        psdewfCond.put("n_psdataentityid_eq", "d1a54da97f37e5d110b31724de3916ac");
        Page<PSDEWF> psdewfs = this.uniWFFeignClient.getPSDEWFByCondition(psdewfCond);
        if (psdewfs == null || psdewfs.getContent().size() == 0) {
            data.put("rst", "0");
            data.put("msg", "未查到流程实体");
            return data;
        }
        PSDEWF psdewf = psdewfs.getContent().get(0);

         // 业务状态
        String status = null;
        if ("start".equals(type)) {
            status = psdewf.getProcessvalue();
        } else if ("gotostep".equals(type)) {
            status = psdewf.getProcessvalue();
        } else if ("finish".equals(type)) {
            status = psdewf.getFinishvalue();
        } else if ("cancel".equals(type)) {

        } else if ("error".equals(type)) {
            status = psdewf.getErrorvalue();
        }

        // 保存当前数据
        if (status != null && !status.isEmpty()) {
            bc.setBcwfstate(status);
        }
        if (wfstep != null && !wfstep.isEmpty()) {
        }

        // 保存业务数据
        this.update(bc_id, bc);

        data.put("rst", "1");
        return data;
    }
}
