
package com.ibiz.wfweb.htwf.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb.htwf.domain.WFIM;
import com.ibiz.wfweb.htwf.filter.*;
import com.ibiz.wfweb.htwf.feign.WFIMFeignClient;
import com.ibiz.wfweb.WFWebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.domain.*;
import com.ibiz.util.helper.SpringContextHolder;
import com.ibiz.util.security.userdetail.LoginUser;
import java.lang.reflect.Method;
import com.ibiz.util.config.WFActivitiEngineClientProperties;
import com.ibiz.util.feign.WFEngineFeignClient;

@Service
public class WFIMService {

    WFIMFeignClient client;
    @Autowired
    SysInfoProperties sysInfoProperties;

    UniWFClientProperties uniWFClientProperties;

    WFActivitiEngineClientProperties wfActivitiEngineClientProperties;

    WFEngineFeignClient wfActivitiEngineFeignClient;

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    public WFIMService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties, UniWFClientProperties uniWFClientProperties, WFActivitiEngineClientProperties wfActivitiEngineClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFIMFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFIMFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
        this.uniWFClientProperties = uniWFClientProperties;
		if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
        this.wfActivitiEngineClientProperties = wfActivitiEngineClientProperties;
		if (wfActivitiEngineClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.wfActivitiEngineFeignClient = nameBuilder.target(WFEngineFeignClient.class,"http://" + wfActivitiEngineClientProperties.getServiceId() + "/") ;
		} else if (wfActivitiEngineClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.wfActivitiEngineFeignClient = nameBuilder.target(WFEngineFeignClient.class, "http://" + wfActivitiEngineClientProperties.getServiceUrl() + "/") ;
		}
    }

    public boolean remove( String wfim_id) {
        return client.remove( wfim_id);
    }

    public WFIM update(String wfim_id, WFIM wfim) {
        return client.update(wfim_id, wfim);
    }

    public WFIM getDraft(String wfim_id, WFIM wfim) {
        return client.getDraft(wfim_id, wfim);
    }

    public WFIM save(String wfim_id, WFIM wfim) {
        return client.save(wfim_id, wfim);
    }

	public WFIM create(WFIM wfim) {
        return client.create(wfim);
    }

    public WFIM get( String wfim_id) {
        return client.get( wfim_id);
    }

    public boolean checkKey(WFIM wfim) {
        return client.checkKey(wfim);
    }

	public Page<WFIM> fetchDefault(WFIMSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

    /** 工作流行为 **/

    /**
     * 开始流程【WFStart】
     */
    public boolean wfStart(String wfim_id, JSONObject data) {
        if (data == null
                || (!data.getBoolean("noET") && data.getJSONObject("wfdata") == null)
                || (data.getBoolean("noET") && (data.getString("proxymoduleid") == null || data.getString("proxydataid") == null))) {
            System.err.println("传入参数缺失");
            data.put("srfmsg", "传入参数缺失");
            return false;
        }

        String loginuserStr = null;

        // 流程数据
        WFInstance pWfinstance = null;
        WFIM wfim = null;
        if (data.getBoolean("noET")) {
            wfim = new WFIM();
            wfim.setProxydataid(data.getString("proxydataid"));
            wfim.setProxymoduleid(data.getString("proxymoduleid"));

            String pinstid = data.getString("pinstid");
            if(pinstid != null && !pinstid.isEmpty()) {
                pWfinstance = this.uniWFFeignClient.getWFInstance(pinstid);
                wfim.setWFIMName(pWfinstance.getWfinstancename());
            }
            wfim = this.client.create(wfim);
            wfim_id = wfim.getWFIMId();
        } else {
            JSONObject itemJo = data.getJSONObject("wfdata");
            wfim = itemJo.toJavaObject(WFIM.class);
        }

        String proxmoduleid = wfim.getProxymoduleid();
        String proxydataid = wfim.getProxydataid();
        if (proxmoduleid == null || proxmoduleid.isEmpty() || proxydataid == null || proxydataid.isEmpty()) {
            System.err.println("流程数据异常");
            data.put("srfmsg", "流程数据异常");
            return false;
        }

        // 统一工作流申请实例
        WFInstance wfinstance = new WFInstance();
        wfinstance.setBsdata(proxydataid);
        wfinstance.setBswfdata(wfim_id);
        wfinstance.setPsworkflowid("49cfb692bde2ae6d258b26681452fb57");
        wfinstance.setWfengineid("ACTIVITI");
        wfinstance.setPswfversionid("94475baa1c89a06ea5aab1a8783d8701");
        wfinstance.setWfinstancename("重要事项审批 v1 - " + wfim.getWFIMName());
        wfinstance.setWfappid(sysInfoProperties.getAppid());
        wfinstance.setWorkflowid(sysInfoProperties.getDomainid());
        wfinstance.setPssystemid(sysInfoProperties.getSystemid());
        wfinstance.setProxymoduleid(proxmoduleid);

        if (pWfinstance != null) {
            if (pWfinstance.getMajorinstid() == null || pWfinstance.getMajorinstid().isEmpty()) {
                wfinstance.setMajorinstid(pWfinstance.getWfinstanceid());
            } else {
                wfinstance.setMajorinstid(pWfinstance.getMajorinstid());
            }
            wfinstance.setParentinstid(pWfinstance.getWfinstanceid());

            // 组织信息存储
            wfinstance.setOriginpersonid(pWfinstance.getOriginpersonid());
            wfinstance.setOriginpersonname(pWfinstance.getOriginpersonname());
            wfinstance.setOriginorgid(pWfinstance.getOriginorgid());
            wfinstance.setOriginorgname(pWfinstance.getOriginorgname());
            wfinstance.setOriginorgdeptid(pWfinstance.getOriginorgdeptid());
            wfinstance.setOriginorgdeptname(pWfinstance.getOriginorgdeptname());
            wfinstance.setOrgid(data.getString("orgid"));
            wfinstance.setOrgdeptid(data.getString("orgdeptid"));
            wfinstance.setWfuserid(data.getString("wfuserid"));
            wfinstance.setInstancetype(data.getString("instancetype"));

            loginuserStr = pWfinstance.getOriginpersonid();
        } else {
            // 登录用户信息
            LoginUser loginUser = SpringContextHolder.getCurLoginUser();
            if (loginUser == null) {
                data.put("srfmsg", "用户未登录");
                return false;
            }
            // 组织信息存储
            wfinstance.setOriginpersonid(loginUser.getPersonId());
            wfinstance.setOriginpersonname(loginUser.getOrgUserName());
            wfinstance.setOriginorgid(loginUser.getOrgId());
            wfinstance.setOriginorgname(loginUser.getOrgName());
            wfinstance.setOriginorgdeptid(loginUser.getOrgDeptId());
            wfinstance.setOriginorgdeptname(loginUser.getOrgDeptName());

            loginuserStr = loginUser.getPersonId();
        }
        wfinstance = uniWFFeignClient.createWFInstance(wfinstance);
        wfim.setWfinstanceid(wfinstance.getWfinstanceid());
        client.update(wfim_id, wfim);
        // 引擎创建实例

        // 获取工作流版本标识
        PSWFVersion wfVer = uniWFFeignClient.getPSWFVersion(wfinstance.getPswfversionid());

        // 业务数据
        String bsServiceStr = proxmoduleid + "Service";
        Class bsService = SpringContextHolder.getBean(bsServiceStr).getClass();
        Method bsServiceMethod = null;
        Object bsData = null;
        try {
            bsServiceMethod = bsService.getDeclaredMethod("get", String.class);
            bsData = bsServiceMethod.invoke(SpringContextHolder.getBean(bsServiceStr), proxydataid);
        } catch (Exception e) {
            e.printStackTrace();
            data.put("srfmsg", "获取业务数据异常");
            return false;
        }
        if (bsData == null) {
            System.err.println("业务数据为空");
            data.put("srfmsg", "业务数据为空");
            return false;
        }

        JSONObject bsJo = (JSONObject) JSONObject.toJSON(bsData);
        JSONObject params = new JSONObject();
        // 模拟用户
        params.put("srfuserid", loginuserStr);
        // 工作流引擎工作流标识
        params.put("srfdeployid", wfVer.getWfenginedeployid());
        // 业务数据
        params.put("srfbodata", bsJo);
        // 流程数据
        params.put("srfwfdata", wfim);
        // 实例数据标识
        params.put("srfwfinstanceid", wfinstance.getWfinstanceid());
        // 访问url
        params.put("srfviewurl", wfVer.getViewurl() + "?srfkey=" + wfim_id + ";srfappde=WFIM;");
        // 意见签
        params.put("srfwfmemo", data.getString("srfwfmemo"));

        JSONObject rstObj = wfActivitiEngineFeignClient.wfStart(params);
        if (rstObj.getInteger("rst") == 0) {
            if (rstObj.getString("msg") != null) {
                System.err.println(rstObj.getString("msg"));
            }
            data.put("srfmsg", "引擎处理发生异常");
            return false;
        }
        return true;
    }

    /**
     * 流程处理【WFSubmit】
     */
    public boolean wfSubmit(String wfim_id, JSONObject data) {
        if (data == null ||
            data.getJSONObject("wfdata") == null || data.getJSONObject("opdata") == null ||
            data.getJSONObject("opdata").getString("srfwfiatag") == null || data.getJSONObject("opdata").getString("srfwfstep") == null) {
            System.err.println("传入参数缺失");
            data.put("srfmsg", "传入参数缺失");
            return false;
        }

        // 登录用户信息
        LoginUser loginUser = SpringContextHolder.getCurLoginUser();
        if (loginUser == null) {
            data.put("srfmsg", "用户未登录");
            return false;
        }

        // 流程数据
        JSONObject itemJo = data.getJSONObject("wfdata");
        WFIM wfim = itemJo.toJavaObject(WFIM.class);

        // 待办检查
        String wfworklistid = data.getString("worklistid");
        WFWorkList wfworklist = null;
        if (wfworklistid != null) {
            // 此块逻辑暂不开放
            // if (!testUserWFSubmit(wfworklistid, wfim.getWfinstanceid())) {
            //     data.put("srfmsg", "传入待办信息有误或已处理");
            //     return false;
            // }
            // wfworklist = uniWFFeignClient.getWFWorkList(wfworklistid);
            // 先使用此处逻辑 start
            wfworklist = this.getUserWorklist(wfim.getWfinstanceid());
            if (wfworklist == null) {
                data.put("srfmsg", "当前用户无待办");
                return false;
            }
            // 先使用此处逻辑 end
        } else {
            wfworklist = this.getUserWorklist(wfim.getWfinstanceid());
            if (wfworklist == null) {
                data.put("srfmsg", "当前用户无待办");
                return false;
            }
        }

        // 业务数据
        String bsServiceStr = wfim.getProxymoduleid() + "Service";
        Class bsService = SpringContextHolder.getBean(bsServiceStr).getClass();
        Method bsServiceMethod = null;
        Object bsData = null;
        try {
            bsServiceMethod = bsService.getDeclaredMethod("get", String.class);
            bsData = bsServiceMethod.invoke(SpringContextHolder.getBean(bsServiceStr), wfim.getProxydataid());
        } catch (Exception e) {
            e.printStackTrace();
            data.put("srfmsg", "获取业务数据异常");
            return false;
        }
        if (bsData == null) {
            System.err.println("业务数据为空");
            data.put("srfmsg", "业务数据为空");
            return false;
        }

        JSONObject bsJo = (JSONObject) JSONObject.toJSON(bsData);
        JSONObject params = new JSONObject();
        // 模拟用户
        params.put("srfuserid", loginUser.getPersonId());
        // 业务数据
        params.put("srfbodata", bsJo);
        // 流程数据
        params.put("srfwfdata", wfim);
        // 操作行为
        params.put("srfconnection", data.getJSONObject("opdata").getString("srfwfiatag"));
        // 流程实例标识
        params.put("srfwfinstanceid", wfworklist.getWfinstanceid());
        // 引擎工作列表标识
        params.put("srfwfengineworklistid", wfworklist.getWfengineworklistid());
        // 访问url
        PSWFVersion wfVer = uniWFFeignClient.getPSWFVersion("94475baa1c89a06ea5aab1a8783d8701");
        params.put("srfviewurl", wfVer.getViewurl() + "?srfkey=" + wfim_id + ";srfappde=WFIM;");
        // 意见签
        params.put("srfwfmemo", data.getString("srfwfmemo"));

        JSONObject rstObj = wfActivitiEngineFeignClient.wfSubmit(params);
        if (rstObj.getInteger("rst") == 0) {
            if (rstObj.getString("msg") != null) {
                System.err.println(rstObj.getString("msg"));
            }
            data.put("srfmsg", "引擎处理发生异常");
            return false;
        }
        return true;
    }

    /**
     * 测试当前用户是否提交过工作流【testUserWFSubmit】
     */
    public boolean testUserWFSubmit(String wfim_id, JSONObject data) {
        if (data == null || data.getJSONObject("wfdata") == null) {
            System.err.println("传入参数缺失");
            data.put("srfmsg", "传入参数缺失");
            return false;
        }
        String wfworklistid = data.getString("worklistid");
        // 流程数据
        JSONObject itemJo = data.getJSONObject("wfdata");
        WFIM wfim = itemJo.toJavaObject(WFIM.class);

        return testUserWFSubmit(wfworklistid, wfim.getWfinstanceid());
    }

    /**
     * 测试当前用户是否存在工作任务【testUserExistWorklist】
     */
    public boolean testUserExistWorklist(String wfim_id, JSONObject data) {
        if (data == null || data.getJSONObject("wfdata") == null) {
            System.err.println("传入参数缺失");
            data.put("srfmsg", "传入参数缺失");
            return false;
        }
        // 流程数据
        JSONObject itemJo = data.getJSONObject("wfdata");
        WFIM wfim = itemJo.toJavaObject(WFIM.class);
        WFWorkList curUserWorklist = this.getUserWorklist(wfim.getWfinstanceid());
        return curUserWorklist != null;
    }

    /**
     * 测试当前用户是否提交过工作流
     */
    private boolean testUserWFSubmit(String worklistid, String wfinstanceid) {
        // 登录用户信息
        LoginUser loginUser = SpringContextHolder.getCurLoginUser();
        if (loginUser == null) {
            return false;
        }
        if (worklistid == null || wfinstanceid == null || worklistid.isEmpty() || wfinstanceid.isEmpty()) {
            return false;
        }
        // 实际从业务中获取
        JSONObject data = new JSONObject();
        data.put("worklistid", worklistid);
        data.put("wfinstanceid", wfinstanceid);
        data.put("userid", loginUser.getPersonId());
        return uniWFFeignClient.testUserWFSubmit(worklistid, data);
    }

    /**
     * 获取当前用户工作列表信息
     */
    private WFWorkList getUserWorklist(String wfinstanceid) {
        LoginUser loginUser = SpringContextHolder.getCurLoginUser();
        if (loginUser == null) {
            // 用户未登录
            return null;
        }
        JSONObject condition = new JSONObject();
        condition.put("page", 0);
        condition.put("size", 1);
        condition.put("n_wfuserid_eq", loginUser.getPersonId());
        condition.put("n_isclosed_noteq", 1);
        condition.put("n_wfinstanceid_eq", wfinstanceid);
        Page<WFWorkList> wfworklists = uniWFFeignClient.getWFWorkListByCondition(condition);
        if (wfworklists == null || wfworklists.getContent().size() == 0) {
            return null;
        }
        return wfworklists.getContent().get(0);
    }

    /**
     * 流程结束【WFClose】
     */
    public boolean wfClose(String wfim_id, JSONObject data) {
        if (data == null || data.getJSONObject("wfdata") == null) {
            System.err.println("传入参数缺失");
            data.put("srfmsg", "传入参数缺失");
            return false;
        }
        // 登录用户信息
        LoginUser loginUser = SpringContextHolder.getCurLoginUser();
        if (loginUser == null) {
            data.put("srfmsg", "用户未登录");
            return false;
        }

        // 流程数据
        JSONObject itemJo = data.getJSONObject("wfdata");
        WFIM wfim = itemJo.toJavaObject(WFIM.class);

        WFInstance wfinstance = uniWFFeignClient.getWFInstance(wfim.getWfinstanceid());

        // 子流程实例检查
        JSONObject subInstCond = new JSONObject();
        subInstCond.put("page", 0);
        subInstCond.put("size", 1);
        subInstCond.put("n_parentinstid_eq", wfinstance.getWfinstanceid());
        subInstCond.put("n_isclosed_eq", 1);
        Page<WFInstance> subWfintances = uniWFFeignClient.getWFInstanceByCondition(subInstCond);
        if (subWfintances != null && subWfintances.getContent().size() > 0) {
            data.put("srfmsg", "当前实例存在子流程，请先关闭子流程");
            return false;
        }

         // 业务数据
        String bsServiceStr = wfim.getProxymoduleid() + "Service";
        Class bsService = SpringContextHolder.getBean(bsServiceStr).getClass();
        Method bsServiceMethod = null;
        Object bsData = null;
        try {
            bsServiceMethod = bsService.getDeclaredMethod("get", String.class);
            bsData = bsServiceMethod.invoke(SpringContextHolder.getBean(bsServiceStr), wfim.getProxydataid());
        } catch (Exception e) {
            e.printStackTrace();
            data.put("srfmsg", "获取业务数据异常");
            return false;
        }
        if (bsData == null) {
            System.err.println("业务数据为空");
            data.put("srfmsg", "业务数据为空");
            return false;
        }

        JSONObject bsJo = (JSONObject) JSONObject.toJSON(bsData);
        JSONObject params = new JSONObject();
        // 模拟用户
        params.put("srfuserid", loginUser.getPersonId());
        // 业务数据
        params.put("srfbodata", bsJo);
        // 流程数据
        params.put("srfwfdata", wfim);
        // 操作行为
        params.put("srfconnection", data.getJSONObject("opdata").getString("srfwfiatag"));
        // 流程实例标识
        params.put("srfwfinstanceid", wfinstance.getWfinstanceid());
        // 意见签
        params.put("srfwfmemo", data.getString("srfwfmemo"));

        JSONObject rstObj = wfActivitiEngineFeignClient.wfClose(params);
        if (rstObj.getInteger("rst") == 0) {
            if (rstObj.getString("msg") != null) {
                System.err.println(rstObj.getString("msg"));
            }
            data.put("srfmsg", "引擎处理发生异常");
            return false;
        }
        return true;
    }

    /**
     * 流程跳转【WFGoto】
     */
    public boolean wfGoto(String wfim_id, JSONObject data) {
        // 待实现
        return true;
    }

    /**
     * 流程重启【WFRestart】
     */
    public boolean wfRestart(String wfim_id, JSONObject data) {
        // 待实现
        return true;
    }

    /**
     * 流程撤回【WFRollback】
     */
    public boolean wfRollback(String wfim_id, JSONObject data) {
        // 待实现
        return true;
    }

    /**
     * 流程退回【WFSendBack】
     */
    public boolean wfSendBack(String wfim_id, JSONObject data) {
        // 待实现
        return true;
    }

    /**
     * 流程重新分配【WFReassign】
     */
    public boolean wfReassign(String wfim_id, JSONObject data) {
        // 待实现
        return true;
    }

    /**
     * 流程标记已读【WFMarkRead】
     */
    public boolean wfMarkRead(String wfim_id, JSONObject data) {
        if (data == null || data.getJSONObject("wfdata") == null) {
            System.err.println("传入参数缺失");
            data.put("srfmsg", "传入参数缺失");
            return false;
        }
        String wfworklistid = data.getString("worklistid");
        // 流程数据
        JSONObject itemJo = data.getJSONObject("wfdata");
        WFIM wfim = itemJo.toJavaObject(WFIM.class);
        String wfinstanceid = wfim.getWfinstanceid();

        if (wfworklistid == null || wfinstanceid == null || wfworklistid.isEmpty() || wfinstanceid.isEmpty()) {
            return false;
        }
        // 实际从业务中获取
        String userid = "systems";
        JSONObject data2 = new JSONObject();
        data2.put("worklistid", wfworklistid);
        data2.put("wfinstanceid", wfinstanceid);
        data2.put("userid", userid);
        return uniWFFeignClient.wfMarkRead(wfworklistid, data2);
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    public JSONObject wfAction(String wfim_id, JSONObject data) {
        if (data == null
            || data.getString("type") == null
            || data.getString("wfinstanceid") == null) {
            System.err.println("传入参数缺失");
            data.put("rst", "0");
            data.put("msg", "传入参数缺失");
            return data;
        }
        String type = data.getString("type");
        String wfinstanceid = data.getString("wfinstanceid");
        String wfstep = data.getString("wfstep");

        // 流程实体
        WFIM wfim = this.get(wfim_id);

        WFInstance wfinstance = this.uniWFFeignClient.getWFInstance(wfinstanceid);
        if (wfinstance == null) {
            System.err.println("查询不到流程实例");
            data.put("rst", "0");
            data.put("msg", "查询不到流程实例");
            return data;
        }
        JSONObject psdewfCond = new JSONObject();
        psdewfCond.put("n_psworkflowid_eq", wfinstance.getPsworkflowid());
        psdewfCond.put("n_psdataentityid_eq", "c6568ad867530ddf86ef2996d73ede25");
        Page<PSDEWF> psdewfs = this.uniWFFeignClient.getPSDEWFByCondition(psdewfCond);
        if (psdewfs == null || psdewfs.getContent().size() == 0) {
            data.put("rst", "0");
            data.put("msg", "未查到流程实体");
            return data;
        }
        PSDEWF psdewf = psdewfs.getContent().get(0);

         // 业务状态
        String status = null;
        if ("start".equals(type)) {
            status = psdewf.getProcessvalue();
        } else if ("gotostep".equals(type)) {
            status = psdewf.getProcessvalue();
        } else if ("finish".equals(type)) {
            status = psdewf.getFinishvalue();
        } else if ("cancel".equals(type)) {

        } else if ("error".equals(type)) {
            status = psdewf.getErrorvalue();
        }

        // 保存当前数据
        if (status != null && !status.isEmpty()) {
            wfim.setWfstate(Integer.parseInt(status));
            wfim.setState(status);
        }
        if (wfstep != null && !wfstep.isEmpty()) {
            wfim.setWfstep(wfstep);
        }

        // 保存业务数据
        this.update(wfim_id, wfim);

        data.put("rst", "1");
        return data;
    }

    /**
     * 获取代理数据【WFGetProxyData】
     */
    public JSONObject wfGetProxyData(String wfim_id) {
        JSONObject data = new JSONObject();
        String proxyviewurl = uniWFFeignClient.wfGetProxyData(wfim_id);
        data.put("proxyviewurl", proxyviewurl);
        return data;
    }

}
