package com.ibiz.web.r7rt_org.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.web.r7rt_org.domain.Org;
import com.ibiz.web.r7rt_org.filter.*;


public interface OrgFeignClient {



	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}/getdraft")
    public Org getDraft(@PathVariable("org_id") String org_id, @RequestBody Org org) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}/getorgprent")
    public Org getOrgPrent(@PathVariable("org_id") String org_id, @RequestBody Org org) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgs/{org_id}")
    public Boolean remove(@PathVariable("org_id") String org_id) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgs/{org_id}")
    public Org update(@PathVariable("org_id") String org_id, @RequestBody Org org) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}")
    public Org get(@PathVariable("org_id") String org_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs")
    public Org create(@RequestBody Org org) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/{org_id}/save")
    public Org save(@PathVariable("org_id") String org_id, @RequestBody Org org) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/{org_id}/synctousergroup")
    public Org syncToUserGroup(@PathVariable("org_id") String org_id, @RequestBody Org org) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/checkkey")
    public Boolean checkKey(@RequestBody Org org) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}/getorgchild")
    public Org getOrgChild(@PathVariable("org_id") String org_id, @RequestBody Org org) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/orgs/fetchdefault")
	public Page<Org> fetchDefault(OrgSearchContext searchContext) ;
}
