package com.ibiz.mybatis.ht;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.BCRepository;
import com.ibiz.core.repository.po.BC;
import com.ibiz.core.ht.filter.BCSearchContext;
import com.ibiz.mybatis.ht.mapper.T_BCMapper;
import com.ibiz.mybatis.ht.po.T_BCImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_BC]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "bc", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_BCRepositoryImpl extends ServiceImpl<T_BCMapper, T_BCImpl> implements BCRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_BC]持久层映射对象
     */
    @Autowired
	T_BCMapper t_BCMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public BC createPO(){
        return new T_BCImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public BC get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(BC po){
        boolean bOk = this.save((T_BCImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(BC po){
        boolean bOk = this.updateById((T_BCImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<BC> searchDefault(BCSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<BC> page_datas=t_BCMapper.searchDefault(page,context,qw);
        List<BC> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<BC>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.ht.domain.BC convert2Domain( BC po ,com.ibiz.core.ht.domain.BC domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.ht.domain.BC();
        }
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getBzDirtyFlag())
        domain.setBz(po.getBz());
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getBmldidsDirtyFlag())
        domain.setBmldids(po.getBmldids());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getWfinstanceidDirtyFlag())
        domain.setWfinstanceid(po.getWfinstanceid());
        //if(po.getWfstepDirtyFlag())
        domain.setWfstep(po.getWfstep());
        //if(po.getBCNameDirtyFlag())
        domain.setBCName(po.getBCName());
        //if(po.getBcwfstateDirtyFlag())
        domain.setBcwfstate(po.getBcwfstate());
        //if(po.getBCIdDirtyFlag())
        domain.setBCId(po.getBCId());
        //if(po.getOrgDeptNameDirtyFlag())
        domain.setOrgDeptName(po.getOrgDeptName());
        //if(po.getIMIdDirtyFlag())
        domain.setIMId(po.getIMId());
        //if(po.getOrgDeptIdDirtyFlag())
        domain.setOrgDeptId(po.getOrgDeptId());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public BC convert2PO(com.ibiz.core.ht.domain.BC domain , BC po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getBzDirtyFlag())
            po.setBz(domain.getBz());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getBmldidsDirtyFlag())
            po.setBmldids(domain.getBmldids());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getWfinstanceidDirtyFlag())
            po.setWfinstanceid(domain.getWfinstanceid());
        if(domain.getWfstepDirtyFlag())
            po.setWfstep(domain.getWfstep());
        if(domain.getBCNameDirtyFlag())
            po.setBCName(domain.getBCName());
        if(domain.getBcwfstateDirtyFlag())
            po.setBcwfstate(domain.getBcwfstate());
        if(domain.getBCIdDirtyFlag())
            po.setBCId(domain.getBCId());
        if(domain.getOrgDeptNameDirtyFlag())
            po.setOrgDeptName(domain.getOrgDeptName());
        if(domain.getIMIdDirtyFlag())
            po.setIMId(domain.getIMId());
        if(domain.getOrgDeptIdDirtyFlag())
            po.setOrgDeptId(domain.getOrgDeptId());

        return po ;
    }
}
