package com.ibiz.mybatis.htwf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.WFIMRepository;
import com.ibiz.core.repository.po.WFIM;
import com.ibiz.core.htwf.filter.WFIMSearchContext;
import com.ibiz.mybatis.htwf.mapper.T_WFIMMapper;
import com.ibiz.mybatis.htwf.po.T_WFIMImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_WFIM]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "wfim", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_WFIMRepositoryImpl extends ServiceImpl<T_WFIMMapper, T_WFIMImpl> implements WFIMRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_WFIM]持久层映射对象
     */
    @Autowired
	T_WFIMMapper t_WFIMMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public WFIM createPO(){
        return new T_WFIMImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public WFIM get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(WFIM po){
        boolean bOk = this.save((T_WFIMImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(WFIM po){
        boolean bOk = this.updateById((T_WFIMImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<WFIM> searchDefault(WFIMSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<WFIM> page_datas=t_WFIMMapper.searchDefault(page,context,qw);
        List<WFIM> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<WFIM>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.htwf.domain.WFIM convert2Domain( WFIM po ,com.ibiz.core.htwf.domain.WFIM domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.htwf.domain.WFIM();
        }
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getWfstepDirtyFlag())
        domain.setWfstep(po.getWfstep());
        //if(po.getProxydataidDirtyFlag())
        domain.setProxydataid(po.getProxydataid());
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getWFIMNameDirtyFlag())
        domain.setWFIMName(po.getWFIMName());
        //if(po.getWFIMIdDirtyFlag())
        domain.setWFIMId(po.getWFIMId());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getWfstateDirtyFlag())
        domain.setWfstate(po.getWfstate());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getStateDirtyFlag())
        domain.setState(po.getState());
        //if(po.getProxymoduleidDirtyFlag())
        domain.setProxymoduleid(po.getProxymoduleid());
        //if(po.getWfinstanceidDirtyFlag())
        domain.setWfinstanceid(po.getWfinstanceid());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public WFIM convert2PO(com.ibiz.core.htwf.domain.WFIM domain , WFIM po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getWfstepDirtyFlag())
            po.setWfstep(domain.getWfstep());
        if(domain.getProxydataidDirtyFlag())
            po.setProxydataid(domain.getProxydataid());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getWFIMNameDirtyFlag())
            po.setWFIMName(domain.getWFIMName());
        if(domain.getWFIMIdDirtyFlag())
            po.setWFIMId(domain.getWFIMId());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getWfstateDirtyFlag())
            po.setWfstate(domain.getWfstate());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getStateDirtyFlag())
            po.setState(domain.getState());
        if(domain.getProxymoduleidDirtyFlag())
            po.setProxymoduleid(domain.getProxymoduleid());
        if(domain.getWfinstanceidDirtyFlag())
            po.setWfinstanceid(domain.getWfinstanceid());

        return po ;
    }
}
