package com.ibiz.wfweb.r7rt_wf.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb.r7rt_wf.domain.WFIAAction;
import com.ibiz.wfweb.r7rt_wf.filter.*;


public interface WFIAActionFeignClient {



	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfiaactions/{wfiaaction_id}")
    public Boolean remove(@PathVariable("wfiaaction_id") String wfiaaction_id) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfiaactions/{wfiaaction_id}")
    public WFIAAction update(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAAction wfiaaction) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfiaactions/{wfiaaction_id}/save")
    public WFIAAction save(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAAction wfiaaction) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfiaactions/{wfiaaction_id}")
    public WFIAAction get(@PathVariable("wfiaaction_id") String wfiaaction_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfiaactions/checkkey")
    public Boolean checkKey(@RequestBody WFIAAction wfiaaction) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfiaactions/{wfiaaction_id}/getdraft")
    public WFIAAction getDraft(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAAction wfiaaction) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfiaactions")
    public WFIAAction create(@RequestBody WFIAAction wfiaaction) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfiaactions/fetchdefault")
	public Page<WFIAAction> fetchDefault(WFIAActionSearchContext searchContext) ;
}
