package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.WFASDTO;
import com.ibiz.core.htwf.domain.WFAS;
import com.ibiz.core.htwf.service.IWFASService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.htwf.filter.WFASSearchContext;

@Api(tags = {"WFAS" })
@RestController
@RequestMapping("")
public class WFASResource {

    @Autowired
    private IWFASService wfasService;

    public IWFASService getWfasService() {
        return this.wfasService;
    }

    @ApiOperation(value = "Get", tags = {"WFAS" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfas/{wfas_id}")
    public ResponseEntity<WFASDTO> get(@PathVariable("wfas_id") String wfas_id) {
        WFASDTO dto = new WFASDTO();
        WFAS domain = wfasService.get(wfas_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"WFAS" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfas/{wfas_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody WFASDTO wfasdto) {
        WFAS wfas = wfasdto.toDO();
    	Boolean b = wfasService.save(wfas) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Remove", tags = {"WFAS" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfas/{wfas_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("wfas_id") String wfas_id) {
        WFASDTO wfasdto = new WFASDTO();
		WFAS domain = new WFAS();
		wfasdto.setWFASId(wfas_id);
		domain.setWFASId(wfas_id);
        Boolean rst = wfasService.remove(domain.getWFASId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "CheckKey", tags = {"WFAS" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfas/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFASDTO wfasdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Update", tags = {"WFAS" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfas/{wfas_id}")
    @Transactional
    public ResponseEntity<WFASDTO> update(@PathVariable("wfas_id") String wfas_id, @RequestBody WFASDTO wfasdto) {
		WFAS domain = wfasdto.toDO();
        domain.setWFASId(wfas_id);
		wfasService.update(domain);
		WFASDTO dto = new WFASDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"WFAS" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfas/{wfas_id}/getdraft")
    @Transactional
    public ResponseEntity<WFASDTO> getDraft(@PathVariable("wfas_id") String wfas_id, @RequestBody WFASDTO wfasdto) {
        WFAS wfas = wfasdto.toDO();
    	wfas = wfasService.getDraft(wfas) ;
    	wfasdto.fromDO(wfas);
        return ResponseEntity.status(HttpStatus.OK).body(wfasdto);
    }

    @ApiOperation(value = "Create", tags = {"WFAS" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfas")
    @Transactional
    public ResponseEntity<WFASDTO> create(@RequestBody WFASDTO wfasdto) {
        WFASDTO dto = new WFASDTO();
        WFAS domain = wfasdto.toDO();
		wfasService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"WFAS" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfas/fetchdefault")
	public ResponseEntity<Page<WFASDTO>> fetchDefault(WFASSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFASDTO> list = new ArrayList<WFASDTO>();
        
        Page<WFAS> domains = wfasService.searchDefault(context) ;
        for(WFAS wfas : domains.getContent()){
            WFASDTO dto = new WFASDTO();
            dto.fromDO(wfas);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
