package com.ibiz.wfweb2.r7rt_org.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb2.r7rt_org.domain.OrgDeptUser;
import com.ibiz.wfweb2.r7rt_org.filter.*;


public interface OrgDeptUserFeignClient {



	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdeptusers/{orgdeptuser_id}/getdraft")
    public OrgDeptUser getDraft(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUser orgdeptuser) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/orgdeptusers/{orgdeptuser_id}")
    public OrgDeptUser get(@PathVariable("orgdeptuser_id") String orgdeptuser_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdeptusers/{orgdeptuser_id}/save")
    public OrgDeptUser save(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUser orgdeptuser) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdeptusers")
    public OrgDeptUser create(@RequestBody OrgDeptUser orgdeptuser) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgdeptusers/{orgdeptuser_id}")
    public Boolean remove(@PathVariable("orgdeptuser_id") String orgdeptuser_id) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgdeptusers/{orgdeptuser_id}")
    public OrgDeptUser update(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUser orgdeptuser) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/orgdeptusers/checkkey")
    public Boolean checkKey(@RequestBody OrgDeptUser orgdeptuser) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/orgdeptusers/fetchgetorgdeptuser")
	public Page<OrgDeptUser> fetchGetorgdeptuser(OrgDeptUserSearchContext searchContext) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/orgdeptusers/fetchdefault")
	public Page<OrgDeptUser> fetchDefault(OrgDeptUserSearchContext searchContext) ;
}
