
package com.ibiz.web.r7rt_wf.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.web.r7rt_wf.domain.WFSTEPDATA;
import com.ibiz.web.r7rt_wf.filter.*;
import com.ibiz.web.r7rt_wf.feign.WFSTEPDATAFeignClient;
import com.ibiz.web.WebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;

@Service
public class WFSTEPDATAService {

    WFSTEPDATAFeignClient client;

    @Autowired
    public WFSTEPDATAService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFSTEPDATAFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFSTEPDATAFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public boolean checkKey(WFSTEPDATA wfstepdata) {
        return client.checkKey(wfstepdata);
    }

    public WFSTEPDATA get( String wfstepdata_id) {
        return client.get( wfstepdata_id);
    }

    public WFSTEPDATA getDraft(String wfstepdata_id, WFSTEPDATA wfstepdata) {
        return client.getDraft(wfstepdata_id, wfstepdata);
    }

	public WFSTEPDATA create(WFSTEPDATA wfstepdata) {
        return client.create(wfstepdata);
    }

    public WFSTEPDATA update(String wfstepdata_id, WFSTEPDATA wfstepdata) {
        return client.update(wfstepdata_id, wfstepdata);
    }

    public WFSTEPDATA save(String wfstepdata_id, WFSTEPDATA wfstepdata) {
        return client.save(wfstepdata_id, wfstepdata);
    }

    public boolean remove( String wfstepdata_id) {
        return client.remove( wfstepdata_id);
    }

	public Page<WFSTEPDATA> fetchByBswfdata(WFSTEPDATASearchContext searchContext) {
        return client.fetchByBswfdata(searchContext);
    }

	public Page<WFSTEPDATA> fetchByBsdata(WFSTEPDATASearchContext searchContext) {
        return client.fetchByBsdata(searchContext);
    }

	public Page<WFSTEPDATA> fetchDefault(WFSTEPDATASearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
