package com.sinosig.util.domain;

import java.io.Serializable;
import org.springframework.util.DigestUtils;

public class PSWFVersion implements Serializable {
    /**
	 * default serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

    /**
	 * 业务流程版本标识
	 */
	String pswfversionid;

	/**
	 * 业务流程版本名称
	 */
	String pswfversionname;

	/**
	 * 工作流应用标识
	 */
	String wfappid;

	/**
	 * 业务工作流标识
	 */
	String psworkflowid;

	/**
     * 业务工作流名称
     */
    String psworkflowname;

	/**
	 * 工作流模式标识
	 */
	String wfmodeid;

	/*
	 * 逻辑名
	 */
	String logicname;

	/**
     * 部署系统标识
     */
    String pssystemid;

    /**
     * 部署域标识
     */
    String workflowid;

    /**
     * 引擎部署标识
     */
    String wfenginedeployid;

    /**
     * 文件名
     */
    String filename;

    /**
     * 文件内容
     */
    byte[] filecontent;

	public String getPswfversionid() {
		if (this.pswfversionid == null) {
            return this.pswfversionid;
        }
        String srtTmp = this.pswfversionid;
        if (this.pssystemid != null) {
            srtTmp = this.pssystemid + srtTmp;
        }
        if (this.workflowid != null) {
            srtTmp = this.workflowid + srtTmp;
        }
        return DigestUtils.md5DigestAsHex(srtTmp.getBytes());
	}

	public void setPswfversionid(String pswfversionid) {
		this.pswfversionid = pswfversionid;
	}

	public String getPswfversionname() {
		return this.pswfversionname;
	}

	public void setPswfversionname(String pswfversionname) {
		this.pswfversionname = pswfversionname;
	}

	public String getWfappid() {
		if (this.wfappid == null) {
            return this.wfappid;
        }
        String srtTmp = this.wfappid;
        if (this.pssystemid != null) {
            srtTmp = this.pssystemid + srtTmp;
        }
        if (this.workflowid != null) {
            srtTmp = this.workflowid + srtTmp;
        }
        return DigestUtils.md5DigestAsHex(srtTmp.getBytes());
	}

	public void setWfappid(String wfappid) {
		this.wfappid = wfappid;
	}

	public String getPsworkflowid() {
		if (this.psworkflowid == null) {
            return this.psworkflowid;
        }
        String srtTmp = this.psworkflowid;
        if (this.pssystemid != null) {
            srtTmp = this.pssystemid + srtTmp;
        }
        if (this.workflowid != null) {
            srtTmp = this.workflowid + srtTmp;
        }
        return DigestUtils.md5DigestAsHex(srtTmp.getBytes());
	}

	public void setPsworkflowid(String psworkflowid) {
		this.psworkflowid = psworkflowid;
	}

	public String getWfmodeid() {
		if (this.wfmodeid == null) {
            return this.wfmodeid;
        }
        String srtTmp = this.wfmodeid;
        if (this.pssystemid != null) {
            srtTmp = this.pssystemid + srtTmp;
        }
        if (this.workflowid != null) {
            srtTmp = this.workflowid + srtTmp;
        }
        return DigestUtils.md5DigestAsHex(srtTmp.getBytes());
	}

	public void setWfmodeid(String wfmodeid) {
		this.wfmodeid = wfmodeid;
	}

	public String getPssystemid() {
        if (this.pssystemid == null) {
            return this.pssystemid;
        }
        String srtTmp = this.pssystemid;
        if (this.workflowid != null) {
            srtTmp = this.workflowid + srtTmp;
        }
        return DigestUtils.md5DigestAsHex(srtTmp.getBytes());
    }

    public void setPssystemid(String pssystemid) {
        this.pssystemid = pssystemid;
    }

    public String getWorkflowid() {
        if (this.workflowid != null) {
            return DigestUtils.md5DigestAsHex(this.workflowid.getBytes());
        }
        return this.workflowid;
    }

    public void setWorkflowid(String workflowid) {
        this.workflowid = workflowid;
    }

    public String getLogicname() {
		return logicname;
	}

	public void setLogicname(String logicname) {
		this.logicname = logicname;
	}

	public String getPsworkflowname() {
        return this.psworkflowname;
    }

    public void setPsworkflowname(String psworkflowname) {
        this.psworkflowname = psworkflowname;
    }

    public String getWfenginedeployid() {
        return this.wfenginedeployid;
    }

    public void setWfenginedeployid(String wfenginedeployid) {
        this.wfenginedeployid = wfenginedeployid;
    }

    public void setFilename(String filename) {
		this.filename = filename;
	}

	public String getFilename() {
        return this.pswfversionid + "_" + this.filename;
    }

    public void setFilecontent(byte[] filecontent) {
		this.filecontent = filecontent;
	}

	public byte[] getFilecontent() {
        return this.filecontent;
    }
}
