package com.sinosig.util.domain;

import java.io.Serializable;
import org.springframework.util.DigestUtils;

public class WFAppDTO implements Serializable {
    /**
	 * default serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

    /**
     * 部署工作流应用标识
     */
    String wfappid;

    /**
     * 部署工作流应用名称
     */
    String wfappname;

    /*
	 * 逻辑名
	 */
	String logicname;

    /**
     * 部署系统标识
     */
    String pssystemid;

    /**
     * 部署域标识
     */
    String workflowid;

    /**
	 * 服务标识
	 */
	String serviceid;

	/**
	 * 服务路径
	 */
	String serviceurl;

    public String getWfappid() {
        return this.wfappid;
	}

	public void setWfappid(String wfappid) {
		this.wfappid = wfappid;
	}

	public String getWfappname() {
		return this.wfappname;
	}

	public void setWfappname(String wfappname) {
		this.wfappname = wfappname;
	}

	public String getPssystemid() {
        return this.pssystemid;
    }

	public void setPssystemid(String pssystemid) {
		this.pssystemid = pssystemid;
	}

	public String getWorkflowid() {
        if (this.workflowid != null) {
            return DigestUtils.md5DigestAsHex(this.workflowid.getBytes());
        }
        return this.workflowid;
    }

    public void setWorkflowid(String workflowid) {
        this.workflowid = workflowid;
    }

    public String getServiceid() {
		return serviceid;
	}

	public void setServiceid(String serviceid) {
		this.serviceid = serviceid;
	}

	public String getServiceurl() {
		return serviceurl;
	}

	public void setServiceurl(String serviceurl) {
		this.serviceurl = serviceurl;
	}

	public String getLogicname() {
		return logicname;
	}

	public void setLogicname(String logicname) {
		this.logicname = logicname;
	}

}
