package com.sinosig.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

@Data
public class SearchContext implements ISearchContext {

	public String customCond; // 自定义查询条件
	public String query; // 快速搜索
	
	/**
	 * 条件
	 */
	List<SearchFilter> condition = new ArrayList<SearchFilter>() ;

	/**
	 * 上下文参数
	 */
	Map<String,Object> params = new HashMap<String,Object>() ;

    @JsonIgnore
    Pageable pageable = PageRequest.of(0, 20);

    /**
    * 获取数据上下文
    * @return
    */
    public Map<String,Object> getDatacontext() {
    	return params;
    }
    
    /**
    * 获取网页请求上下文
    * @return
    */
    public Map<String,Object> getWebcontext() {
    	return params;
    }

    /**
    * 获取用户上下文
    * @return
    */
    public Map<String,Object> getSessioncontext() {
    	return params;
    }
	
    @JsonAnyGetter
    public Map<String , Object> any() {
        return params;
    }
 
    @JsonAnySetter
    public void set(String name, Object value) {
        params.put(name, value);
    }

}
