package com.sinosig.util.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.alibaba.fastjson.JSONObject;

/**
 * 工作流引擎服务
 */
public interface WFEngineFeignClient {

    /**
     * 工作流注册
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfdeploy")
    public JSONObject wfDeploy(@RequestBody JSONObject et);

    /**
     * 工作流启动
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfstart")
    public JSONObject wfStart(@RequestBody JSONObject et);

    /**
     * 工作流提交处理
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfsubmit")
    public JSONObject wfSubmit(JSONObject et);

    /**
     * 工作流关闭
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfclose")
    public JSONObject wfClose(JSONObject et);

    /**
     * 工作流跳转
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfgoto")
    public JSONObject wfGoto(JSONObject et);

    /**
     * 工作流重新启动
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfrestart")
    public JSONObject wfRestart(JSONObject et);

    /**
     * 工作流撤回
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfrollback")
    public JSONObject wfRollback(JSONObject et);

    /**
     * 工作流退回
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfsendback")
    public JSONObject wfSendBack(JSONObject et);

    /**
     * 工作流重新分配（处理人）
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfreassign")
    public JSONObject wfReassign(JSONObject et);

    /**
     * 工作流标记为已读
     */
	@RequestMapping(method = RequestMethod.POST, value = "/wfmarkread")
    public JSONObject wfMarkRead(JSONObject et);

}
