package com.sinosig.util.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.data.domain.Page;

import com.alibaba.fastjson.JSONObject;

import com.sinosig.util.domain.*;

/**
 * 统一工作流服务
 */
public interface UniWFFeignClient {

    /* ---------- 业务系统注册内容 ---------- */

    /**
     * 注册统一工作流（域注册）
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/workflows/regist")
    public WorkflowDTO registDomain(@RequestBody Workflow workflow);

    /**
     * 注册工作流引擎
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfengines/regist")
    public List<WFEngineDTO> registWFEngine(@RequestBody List<WFEngine> wfengines);

    /**
     * 注册业务系统（部署系统）
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pssystems/regist")
    public PSSystem registPSSystem(@RequestBody PSSystem pssystem);

    /**
     * 注册业务工作流
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/psworkflows/regist")
    public List<PSWorkflowDTO> registPSWorkflow(@RequestBody List<PSWorkflow> psworkflows);

    /**
     * 注册业务实体工作流
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/psdewfs/regist")
    public List<PSDEWFDTO> registPSDEWF(@RequestBody List<PSDEWF> psdewfs);

    /**
     * 注册业务实体
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/psdataentities/regist")
    public List<PSDataEntityDTO> registPSDataEntity(@RequestBody List<PSDataEntity> psdataentities);

    /**
     * 注册业务工作流模式
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfmodes/regist")
    public List<WFModeDTO> registWFMode(@RequestBody List<WFMode> wfmodes);

    /* ---------- 工作流应用注册内容 ---------- */

    /**
     * 注册业务工作流版本
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfapps/regist")
    public WFAppDTO registWFApp(@RequestBody WFApp wfapp);


    /**
     * 注册业务工作流版本
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/pswfversions/regist")
    public List<PSWFVersionDTO> registPSWFVersion(@RequestBody List<PSWFVersion> pswfversions);

    /* ---------- 工作流应用启动流程 ---------- */

    /**
     * 创建工作流实例
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/wfinstances/")
    public WFInstanceDTO createWFInstance(@RequestBody WFInstance wfinstance);

    /**
     * 权限检查
     */
    @RequestMapping(method = RequestMethod.POST, value = "/uniwfinternalservice/checkPermisson/")
    public boolean checkPermission();

    /* ---------- 获取数据 ---------- */
    /**
     * 获取业务工作流版本
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/pswfversions/{pswfversion_id}")
    public PSWFVersionDTO getPSWFVersion(@PathVariable("pswfversion_id") String pswfversion_id);

    /**
     * 获取工作列表
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfworklists/{wfworklist_id}")
    public WFWorkListDTO getWFWorkList(@PathVariable("wfworklist_id") String wfworklist_id);

    /**
     * 获取工作列表（查询条件）
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfworklists/fetchdefault")
    public Page<WFWorkListDTO> getWFWorkListByCondition(@RequestBody JSONObject condition);

    /**
     * 获取流程实例
     */
    @RequestMapping(method = RequestMethod.GET, value = "/uniwfinternalservice/wfinstances/{wfinstance_id}")
    public WFInstanceDTO getWFInstance(@PathVariable("wfinstance_id") String wfinstance_id);
}
