package com.sinosig.util.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

@ConfigurationProperties
@Data
public class SysInfoProperties {

	/**
     * 部署系统标识
     */
    @Value("${ibiz.systemid:#{null}}")
    String systemid;

	/**
     * 部署域标识
     */
    @Value("${ibiz.domainid:#{null}}")
    String domainid;

    /**
     * 部署域名称
     */
    @Value("${ibiz.domainname:#{null}}")
    String domainname;

    /**
	 * 服务标识
	 */
	@Value("${spring.application.name:#{null}}")
	String serviceid;

	/**
	 * 服务路径
	 */
	@Value("${spring.cloud.nacos.discovery.server-addr:#{null}}")
	String serviceurl;

	/*
	 * 系统逻辑名
	 */
    @Value("${ibiz.systemlogicname:#{null}}")
	String systemlogicname;

	/**
     * 部署系统名称
     */
    @Value("${ibiz.systemname:#{null}}")
    String systemname;

    /**
	 * 应用标识
	 */
	@Value("${ibiz.appid:#{null}}")
	String appid;

	/*
	 * 应用逻辑名
	 */
	@Value("${ibiz.applogicname:#{null}}")
	String applogicname;

	/**
     * 应用名称
     */
    @Value("${ibiz.appname:#{null}}")
    String appname;

    /*
	 * 逻辑名
	 */
    @Value("${ibiz.domainlogicname:#{null}}")
	String domainlogicname;

	public String getSystemid() {
		return systemid;
	}

	public void setSystemid(String systemid) {
		this.systemid = systemid;
	}

	public String getDomainid() {
		return domainid;
	}

	public void setDomainid(String domainid) {
		this.domainid = domainid;
	}

	public String getDomainname() {
		return domainname;
	}

	public void setDomainname(String domainname) {
		this.domainname = domainname;
	}

	public String getServiceid() {
		return serviceid;
	}

	public void setServiceid(String serviceid) {
		this.serviceid = serviceid;
	}

	public String getServiceurl() {
		return serviceurl;
	}

	public void setServiceurl(String serviceurl) {
		this.serviceurl = serviceurl;
	}

	public String getSystemlogicname() {
		return systemlogicname;
	}

	public void setSystemlogicname(String systemlogicname) {
		this.systemlogicname = systemlogicname;
	}

	public String getSystemname() {
		return systemname;
	}

	public void setSystemname(String systemname) {
		this.systemname = systemname;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getApplogicname() {
		return applogicname;
	}

	public void setApplogicname(String applogicname) {
		this.applogicname = applogicname;
	}

	public String getAppname() {
		return appname;
	}

	public void setAppname(String appname) {
		this.appname = appname;
	}

	public String getDomainlogicname() {
		return domainlogicname;
	}

	public void setDomainlogicname(String domainlogicname) {
		this.domainlogicname = domainlogicname;
	}
}
