package com.sinosig.client.external.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.sinosig.core.client.model.ISYXBJ;
import com.sinosig.client.external.config.ExternalClientProperties;
import com.sinosig.core.client.service.ISYXBJClientService;
import com.sinosig.client.external.model.SYXBJImpl;
import com.sinosig.client.external.feign.SYXBJFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.sinosig.util.feign.FeignRequestInterceptor;
import com.sinosig.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.sinosig.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[SYXBJ] 服务对象接口
 */
@Service
public class SYXBJClientServiceImpl implements ISYXBJClientService {

    SYXBJFeignClient sYXBJFeignClient;

    @Autowired
    public SYXBJClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,ExternalClientProperties externalClientProperties) {
        if (externalClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.sYXBJFeignClient = nameBuilder.target(SYXBJFeignClient.class,"http://"+externalClientProperties.getServiceId()+"/") ;
		}else if (externalClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.sYXBJFeignClient = nameBuilder.target(SYXBJFeignClient.class,"http://"+externalClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public ISYXBJ createModel() {
		return new SYXBJImpl();
	}


    public Page<ISYXBJ> fetchDefault(SearchContext context){
        Page<SYXBJImpl> page = this.sYXBJFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public void get(ISYXBJ syxbj){
        ISYXBJ clientModel = sYXBJFeignClient.get(syxbj.getSYXBJId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), syxbj.getClass(), false);
        copier.copy(clientModel, syxbj, null);
    }


    public Page<ISYXBJ> select(SearchContext context){
        return null ;
    }


    public void save(ISYXBJ syxbj){
        ISYXBJ clientModel = sYXBJFeignClient.save((SYXBJImpl)syxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), syxbj.getClass(), false);
        copier.copy(clientModel, syxbj, null);
    }


    public void remove(ISYXBJ syxbj){
        sYXBJFeignClient.remove(syxbj.getSYXBJId()) ;
    }


    public void getDraft(ISYXBJ syxbj){
        ISYXBJ clientModel = sYXBJFeignClient.getDraft((SYXBJImpl)syxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), syxbj.getClass(), false);
        copier.copy(clientModel, syxbj, null);
    }


    public void checkKey(ISYXBJ syxbj){
        ISYXBJ clientModel = sYXBJFeignClient.checkKey((SYXBJImpl)syxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), syxbj.getClass(), false);
        copier.copy(clientModel, syxbj, null);
    }


    public void update(ISYXBJ syxbj){
        ISYXBJ clientModel = sYXBJFeignClient.update(syxbj.getSYXBJId(),(SYXBJImpl)syxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), syxbj.getClass(), false);
        copier.copy(clientModel, syxbj, null);
    }


    public void create(ISYXBJ syxbj){
        ISYXBJ clientModel = sYXBJFeignClient.create((SYXBJImpl)syxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), syxbj.getClass(), false);
        copier.copy(clientModel, syxbj, null);
    }



}

